/*
 * Decompiled with CFR 0.152.
 */
package oracle.j2ee.connector.logging;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.connector.logging.JCADeploymentMessageBundle;
import oracle.j2ee.util.CustomerLogger;

public class JCADeploymentMessages {
    private static Logger m_logger = CustomerLogger.getLogger("oracle.j2ee.connector.deployment", JCADeploymentMessageBundle.class.getName());

    public static Logger getLogger() {
        return m_logger;
    }

    public static boolean isLoggable(Level level) {
        return m_logger.isLoggable(level);
    }

    public static void warningBadConnFactoryLocationStandalone(String jndiLocation, String message) {
        if (m_logger.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE JCA-02001", new Object[]{jndiLocation, message});
        }
    }

    public static void warningBadConnFactoryLocation(String jndiLocation, String appName, String message) {
        if (m_logger.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE JCA-02002", new Object[]{jndiLocation, appName, message});
        }
    }

    public static void warningJNDILocationNotDefinedStandalone(String connectorModuleName) {
        if (JCADeploymentMessages.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE JCA-02003", new Object[]{connectorModuleName});
        }
    }

    public static void warningJNDILocationNotDefined(String connectorModuleName, String appName) {
        if (JCADeploymentMessages.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE JCA-02004", new Object[]{connectorModuleName, appName});
        }
    }

    public static void warningJNDILocationAlreadyInUseStandalone(String raWrapper, String objectName, String connectorModuleName) {
        if (JCADeploymentMessages.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE JCA-02005", new Object[]{raWrapper, objectName, connectorModuleName});
        }
    }

    public static void warningJNDILocationAlreadyInUse(String raWrapper, String objectName, String connectorModuleName, String appName) {
        if (JCADeploymentMessages.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE JCA-02006", new Object[]{raWrapper, objectName, connectorModuleName, appName});
        }
    }

    public static void warningJNDILocationBindFailedStandalone(String raWrapper, String connectorModuleName, String message) {
        if (JCADeploymentMessages.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE JCA-02007", new Object[]{raWrapper, connectorModuleName, message});
        }
    }

    public static void warningJNDILocationBindFailed(String raWrapper, String connectorModuleName, String appName, String message) {
        if (JCADeploymentMessages.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE JCA-02008", new Object[]{raWrapper, connectorModuleName, appName, message});
        }
    }

    public static void warningDuplicateMsgLsnrType() {
        if (JCADeploymentMessages.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE JCA-02009");
        }
    }

    public static void warningActivationSpecNotImplementedInterface(String className) {
        if (JCADeploymentMessages.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE JCA-02010", new Object[]{className});
        }
    }

    public static void warningActivationSpecNullConstructor(String className) {
        if (JCADeploymentMessages.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE JCA-02011", new Object[]{className});
        }
    }

    public static void warningActivationSpecRequiredCPGetterMethodMissing(String className) {
        if (JCADeploymentMessages.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE JCA-02012", new Object[]{className});
        }
    }
}

