/*
 * Decompiled with CFR 0.152.
 */
package oracle.j2ee.connector;

import java.security.Principal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import oracle.j2ee.connector.InitiatingGroup;
import org.w3c.dom.Node;

public class InitiatingPrincipal
implements Principal {
    private String m_userName;
    private Set m_groups;
    private String m_realm;

    public InitiatingPrincipal(String userName) {
        this.m_userName = userName;
    }

    public boolean equals(Object other) {
        if (!(other instanceof InitiatingPrincipal)) {
            return false;
        }
        return this.m_userName.equals(((InitiatingPrincipal)other).getName());
    }

    public String getName() {
        return this.m_userName;
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.m_userName != null) {
            hashCode = this.m_userName.hashCode();
        }
        return hashCode;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("name : " + InitiatingPrincipal.encode(this.getName()));
        if (this.m_groups != null) {
            sb.append("groups : ");
            Iterator iter = this.m_groups.iterator();
            while (iter.hasNext()) {
                sb.append("\n" + iter.next());
            }
        }
        return sb.toString();
    }

    public void addGroup(InitiatingGroup group) {
        if (this.m_groups == null) {
            this.m_groups = new HashSet();
        }
        this.m_groups.add(group);
    }

    public Set getGroups() {
        return this.m_groups;
    }

    public void setRealm(String realmName) {
        this.m_realm = realmName;
    }

    public String getRealm() {
        return this.m_realm;
    }

    static String getStringValue(Node node) {
        Node child = node.getFirstChild();
        if (child == null) {
            return "";
        }
        String value = child.getNodeValue();
        if (value == null) {
            return "";
        }
        return value.trim();
    }

    static String encode(String string) {
        if (string == null) {
            return "";
        }
        if (string.indexOf(38) >= 0) {
            string = InitiatingPrincipal.replace(string, '&', "&amp;");
        }
        if (string.indexOf(60) >= 0) {
            string = InitiatingPrincipal.replace(string, '<', "&lt;");
        }
        if (string.indexOf(62) >= 0) {
            string = InitiatingPrincipal.replace(string, '>', "&gt;");
        }
        if (string.indexOf(34) >= 0) {
            string = InitiatingPrincipal.replace(string, '\"', "&quot;");
        }
        return string;
    }

    private static String replace(String source, char original, String newDelimeter) {
        int swapIndex = source.indexOf(original);
        if (swapIndex >= 0) {
            StringBuffer result = new StringBuffer();
            int lastSwapIndex = 0;
            while (swapIndex >= 0) {
                result.append(source.substring(lastSwapIndex, swapIndex));
                result.append(newDelimeter);
                lastSwapIndex = swapIndex + 1;
                swapIndex = source.indexOf(original, lastSwapIndex);
            }
            if (lastSwapIndex < source.length()) {
                result.append(source.substring(lastSwapIndex, source.length()));
            }
            return result.toString();
        }
        return source;
    }
}

