/*
 * Decompiled with CFR 0.152.
 */
package oracle.j2ee.connector;

import com.evermind.server.Application;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.NotificationListener;
import oracle.j2ee.connector.ConnectorMessageBundle;
import oracle.j2ee.util.CustomerLogger;
import oracle.j2ee.util.LoggingMessages;
import oracle.j2ee.util.LoggingUtils;

public class ConnectorMessages
extends LoggingMessages
implements NotificationListener {
    private static Logger m_logger = CustomerLogger.getLogger("oracle.j2ee.connector", ConnectorMessageBundle.class.getName());
    public static boolean LOG_LEVEL_FINEST_OR_HIGHER = false;
    public static boolean LOG_LEVEL_FINER_OR_HIGHER = false;
    public static boolean LOG_LEVEL_FINE_OR_HIGHER = false;
    public static boolean LOG_LEVEL_CONFIG_OR_HIGHER = false;
    public static boolean LOG_LEVEL_INFO_OR_HIGHER = true;
    public static boolean LOG_LEVEL_WARNING_OR_HIGHER = false;
    public static boolean LOG_LEVEL_SEVERE_OR_HIGHER = false;

    public ConnectorMessages() {
        this.init();
    }

    protected Logger getLogger() {
        return m_logger;
    }

    public void setLogLevels(boolean finestOrHigher, boolean finerOrHigher, boolean fineOrHigher, boolean configOrHigher, boolean infoOrHigher, boolean warningOrHigher, boolean severOrHiger) {
        LOG_LEVEL_FINEST_OR_HIGHER = finestOrHigher;
        LOG_LEVEL_FINER_OR_HIGHER = finerOrHigher;
        LOG_LEVEL_FINE_OR_HIGHER = fineOrHigher;
        LOG_LEVEL_CONFIG_OR_HIGHER = configOrHigher;
        LOG_LEVEL_INFO_OR_HIGHER = infoOrHigher;
        LOG_LEVEL_WARNING_OR_HIGHER = warningOrHigher;
        LOG_LEVEL_SEVERE_OR_HIGHER = severOrHiger;
    }

    public static boolean isLoggable(Level level) {
        return m_logger.isLoggable(level);
    }

    public static void warningBadAdminLocation(String locationName, Application application, Exception exception) {
        m_logger.log(Level.WARNING, "J2EE JCA-00002", new Object[]{locationName, application.getName(), exception.getMessage()});
    }

    public static void warningBadAdminLocationStandalone(String locationName, Exception exception) {
        m_logger.log(Level.WARNING, "J2EE JCA-00001", new Object[]{locationName, exception.getMessage()});
    }

    public static void warningUnclosedConnection(Throwable throwable) {
        m_logger.log(Level.WARNING, "J2EE JCA-00003");
        LoggingUtils.logWarningStackTrace(m_logger, throwable);
    }

    public static void debugWaitingForConnection(String thread, long waitTime) {
        m_logger.log(Level.FINER, "J2EE JCA-00004", new Object[]{thread, new Long(waitTime)});
    }

    public static void debugUnableToGetConnection(String thread) {
        m_logger.log(Level.FINER, "J2EE JCA-00005", new Object[]{thread});
    }

    public static void debugGotConnection(String thread) {
        m_logger.log(Level.FINER, "J2EE JCA-00006", new Object[]{thread});
    }

    public static void warningMinPoolSize(int min) {
        m_logger.log(Level.WARNING, "J2EE JCA-00007", new Object[]{"" + min});
    }
}

