/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.container.timer.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;
import oracle.ias.container.timer.TimerEntry;

public class TimeBasedEntry
extends TimerEntry {
    boolean _repeats = false;
    private Date _initialExpiration;
    private long _intervalDuration = 0L;
    public static final long MIN_INITIAL_EXPIRATION = 500L;

    public TimeBasedEntry(long duration, String className, Serializable info) throws IllegalArgumentException {
        if (duration < 500L) {
            duration = 500L;
        }
        this._initialExpiration = new Date(System.currentTimeMillis() + duration);
        this.init(this._initialExpiration, 0L, className, info);
    }

    public TimeBasedEntry(long initialDuration, long intervalDuration, String className, Serializable info) throws IllegalArgumentException {
        if (initialDuration < 500L) {
            initialDuration = 500L;
        }
        this._initialExpiration = new Date(System.currentTimeMillis() + initialDuration);
        this.init(this._initialExpiration, intervalDuration, className, info);
    }

    public TimeBasedEntry(Date expiration, String className, Serializable info) throws IllegalArgumentException {
        Date min_init_expiration = new Date(System.currentTimeMillis() + 500L);
        if (expiration.before(min_init_expiration)) {
            expiration = min_init_expiration;
        }
        this.init(expiration, 0L, className, info);
    }

    public TimeBasedEntry(Date initialExpiration, long intervalDuration, String className, Serializable info) throws IllegalArgumentException {
        Date min_init_expiration = new Date(System.currentTimeMillis() + 500L);
        if (initialExpiration.before(min_init_expiration)) {
            initialExpiration = min_init_expiration;
        }
        this.init(initialExpiration, intervalDuration, className, info);
    }

    public Date getInitialExpiration() {
        return this._initialExpiration;
    }

    private void init(Date initialExpiration, long intervalDuration, String className, Serializable info) {
        this._initialExpiration = initialExpiration;
        this._intervalDuration = intervalDuration;
        this._repeats = this._intervalDuration != 0L;
        this._info = info;
        super.setClass(className);
    }

    public long getTimeRemaining() {
        long retCode = Long.MAX_VALUE;
        Date timeout = this.getNextTimeout();
        if (timeout != null) {
            Date now = new Date();
            retCode = timeout.getTime() - now.getTime();
            if (retCode < 0L) {
                retCode = Long.MAX_VALUE;
            }
        }
        return retCode;
    }

    public Date getNextTimeout() {
        Date now = new Date();
        return this.getNextTimeout(now.getTime());
    }

    public Date getNextTimeout(long fromTime) {
        Date expirationTime = null;
        long initialExpiration = this._initialExpiration.getTime();
        if (!this._repeats) {
            if (initialExpiration >= fromTime) {
                expirationTime = this._initialExpiration;
            }
        } else {
            long timeSinceInitialExpire;
            long timeTilNextExpire;
            expirationTime = initialExpiration >= fromTime ? this._initialExpiration : ((timeTilNextExpire = this._intervalDuration - (timeSinceInitialExpire = fromTime - initialExpiration) % this._intervalDuration) == this._intervalDuration ? new Date(fromTime) : new Date(fromTime + timeTilNextExpire));
        }
        return expirationTime;
    }

    public long nextEvent(long fromTime) {
        long retCode = Long.MAX_VALUE;
        Date timeout = this.getNextTimeout(fromTime);
        if (timeout != null) {
            Date now = new Date();
            retCode = timeout.getTime();
            if (retCode < 0L) {
                retCode = Long.MAX_VALUE;
            }
        }
        return retCode;
    }

    public boolean repeats() {
        return this._repeats;
    }

    public String toString() {
        return "@: x" + this._initialExpiration + " i" + this._intervalDuration + " nextTimeout " + this.getNextTimeout(this.lastScheduled) + " lastScheduled " + new Date(this.lastScheduled);
    }

    public TimeBasedEntry() {
    }

    public void readEntry(ObjectInputStream in) throws ClassNotFoundException, IOException {
        Date min_init_expiration;
        this._repeats = in.readBoolean();
        this._intervalDuration = in.readLong();
        long initialExpiration = in.readLong();
        this._initialExpiration = new Date(initialExpiration);
        if (!this._repeats && this._initialExpiration.before(min_init_expiration = new Date(System.currentTimeMillis() + 60000L))) {
            this._initialExpiration = min_init_expiration;
        }
        this.read(in);
    }

    public void writeEntry(ObjectOutputStream out) throws IOException {
        out.writeBoolean(this._repeats);
        out.writeLong(this._intervalDuration);
        out.writeLong(this._initialExpiration.getTime());
        this.write(out);
    }
}

