/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.container.timer.internal;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;

public class DateUtil {
    static java.sql.Date _minusInfinity;
    static java.sql.Date _plusInfinity;
    static final int k_leap_years_in_february = 29;
    static final int k_february = 1;
    public static final String[] k_dayNames;
    public static final String[] k_monthNames;
    public static final String[] k_dayShortNames;
    public static final String[] k_monthShortNames;
    public static final int k_seconds_per_minute = 60;
    public static final int k_minutes_per_hour = 60;
    public static final int k_hours_per_day = 24;
    public static final int k_days_per_month = 31;
    public static final int k_dayes_per_week = 7;
    public static final int k_months_per_year = 12;
    public static final int k_startBaseYear;
    public static final int k_stopBaseYears = 100;
    public static final int k_start_with_one = 1;
    public static final int k_start_with_zero = 0;
    public static final int k_invalid = -1;
    public static final TimeUnitSpec k_secondSpec;
    public static final TimeUnitSpec k_minuteSpec;
    public static final TimeUnitSpec k_hourSpec;
    public static final TimeUnitSpec k_dateSpec;
    public static final TimeUnitSpec k_monthSpec;
    public static final TimeUnitSpec k_daySpec;
    public static final TimeUnitSpec k_yearSpec;
    public static final TimeUnitSpec[] CRON_STYLE;
    public static final TimeUnitSpec[] CRON_STYLE_AND_YEARS;
    public static final TimeUnitSpec[] CRON_STYLE_WITH_SECONDS_AND_YEARS;

    public static java.sql.Date minusInfinity() {
        DateUtil.init();
        return _minusInfinity;
    }

    public static java.sql.Date plusInfinity() {
        DateUtil.init();
        return _plusInfinity;
    }

    public static Timestamp timestampNow() {
        return new Timestamp(new Date().getTime());
    }

    public static boolean leapYear(int year) {
        if (year % 400 == 0) {
            return true;
        }
        if (year % 100 == 0) {
            return false;
        }
        return year % 4 == 0;
    }

    public static int monthSize(int month) {
        int[] monthSizes = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        return monthSizes[month];
    }

    public static int getDaysInMonth(int month, int year) {
        if (month == 1 && DateUtil.leapYear(year)) {
            return 29;
        }
        return DateUtil.monthSize(month);
    }

    public static boolean isValidDate(int date, int month, int year) {
        return 0 < date && date <= DateUtil.getDaysInMonth(month, year);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void init() {
        if (_minusInfinity == null) {
            Class clazz = DateUtil.class;
            synchronized (clazz) {
                if (_minusInfinity == null) {
                    Calendar cal = Calendar.getInstance();
                    cal.set(1, 0, 1);
                    Date d = cal.getTime();
                    _minusInfinity = new java.sql.Date(d.getTime());
                    cal.set(9999, 11, 31);
                    d = cal.getTime();
                    _plusInfinity = new java.sql.Date(d.getTime());
                }
            }
        }
    }

    static int calcThisYear() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        return cal.get(1);
    }

    static {
        k_dayNames = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
        k_monthNames = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
        k_dayShortNames = new String[]{"SUN", "MON", "TUE", "WED", "THU", "FRI", "SAT"};
        k_monthShortNames = new String[]{"JAN", "k_february", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"};
        k_startBaseYear = DateUtil.calcThisYear();
        k_secondSpec = new TimeUnitSpec("second", "Seconds", 60, 0, null, null);
        k_minuteSpec = new TimeUnitSpec("minute", "Minutes", 60, 0, null, null);
        k_hourSpec = new TimeUnitSpec("hour", "Hours", 24, 0, null, null);
        k_dateSpec = new TimeUnitSpec("date", "Dates", 31, 1, null, null);
        k_monthSpec = new TimeUnitSpec("month", "Months", 12, 1, k_monthShortNames, k_monthNames);
        k_daySpec = new TimeUnitSpec("day", "Days", 7, 0, k_dayShortNames, k_dayNames);
        k_yearSpec = new TimeUnitSpec("year", "Years", 100, k_startBaseYear, null, null);
        CRON_STYLE = new TimeUnitSpec[]{k_minuteSpec, k_hourSpec, k_dateSpec, k_monthSpec, k_daySpec};
        CRON_STYLE_AND_YEARS = new TimeUnitSpec[]{k_minuteSpec, k_hourSpec, k_dateSpec, k_monthSpec, k_yearSpec, k_daySpec};
        CRON_STYLE_WITH_SECONDS_AND_YEARS = new TimeUnitSpec[]{k_secondSpec, k_minuteSpec, k_hourSpec, k_dateSpec, k_monthSpec, k_yearSpec, k_daySpec};
    }

    public static class TimeUnitSpec {
        public String name;
        String description;
        public int size;
        public int arrayBase;
        public String[] shortNames;
        String[] names;

        TimeUnitSpec(String name, String description, int size, int arrayBase, String[] shortNames, String[] names) {
            this.name = name;
            this.description = description;
            this.size = size;
            this.arrayBase = arrayBase;
            this.shortNames = shortNames;
            this.names = names;
        }
    }
}

