/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.container.timer.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ias.container.logging.ContainerServiceTraceLogger;
import oracle.ias.container.timer.TimerEmptyException;
import oracle.ias.container.timer.TimerEntry;
import oracle.ias.container.timer.TimerParseException;
import oracle.ias.container.timer.TimerService;
import oracle.ias.container.timer.internal.DateUtil;

public class CronEntry
extends TimerEntry {
    private static Logger m_logger = ContainerServiceTraceLogger.getTraceLogger(CronEntry.class);
    boolean[] secondBooleanArray = new boolean[]{true};
    boolean[] minuteBooleanArray;
    boolean[] hourBooleanArray;
    boolean[] dateBooleanArray;
    boolean[] monthBooleanArray;
    boolean[] yearBooleanArray;
    boolean[] dayBooleanArray;
    int _rotate;
    Calendar from = Calendar.getInstance();
    Calendar calendarDate = Calendar.getInstance();
    Calendar calendarDay = Calendar.getInstance();
    Date date = new Date(0L);
    private DateUtil.TimeUnitSpec[] _style = DateUtil.CRON_STYLE;

    public CronEntry(String line, DateUtil.TimeUnitSpec[] style) throws TimerParseException, TimerEmptyException {
        this._style = style;
        this.parse(line, style);
    }

    public CronEntry(String line) throws TimerParseException, TimerEmptyException {
        this.parse(line, DateUtil.CRON_STYLE);
    }

    public static String entryToString(boolean[] array, DateUtil.TimeUnitSpec spec) {
        if (array == null) {
            return "*";
        }
        String rtn = "";
        int num = 0;
        int first = -1;
        int step = -1;
        int prev = -1;
        for (int i = 0; i < spec.size; ++i) {
            if (i < array.length && array[i] && first == -1) {
                first = i;
            } else if (i < array.length && array[i] && step == -1) {
                step = i - first;
            } else if (i < array.length && array[i] && i != prev + step) {
                if (first + step == i - 1) {
                    rtn = rtn + CronEntry.makeEntry(num++, first, first, 1, spec);
                    first = prev;
                    i = prev;
                    step = -1;
                } else {
                    rtn = rtn + CronEntry.makeEntry(num++, first, i - 1, step, spec);
                    first = i;
                    step = -1;
                }
            } else if (!(array.length > i && array[i] || i != prev + step)) {
                rtn = rtn + CronEntry.makeEntry(num++, first, i - 1, step, spec);
                step = -1;
                first = -1;
            }
            if (i >= array.length || !array[i]) continue;
            prev = i;
        }
        if (first != -1) {
            rtn = rtn + CronEntry.makeEntry(num++, first, spec.size - 1, step, spec);
        }
        return rtn;
    }

    static String makeOne(int num, DateUtil.TimeUnitSpec spec) {
        if (spec.shortNames == null || num < 0 || num >= spec.shortNames.length) {
            return Integer.toString(num + spec.arrayBase);
        }
        return spec.shortNames[num];
    }

    static String makeEntry(int num, int first, int last, int step, DateUtil.TimeUnitSpec spec) {
        String rtn = "";
        if (num != 0) {
            rtn = rtn + ",";
        }
        if (first == last || step == -1) {
            rtn = rtn + CronEntry.makeOne(first, spec);
        } else if (last - step < first + step) {
            rtn = rtn + CronEntry.makeOne(first, spec) + "," + CronEntry.makeOne(first + step, spec);
        } else {
            if (first == 0 && spec.size - 1 <= last) {
                rtn = rtn + "*";
            } else {
                last -= (last - first) % step;
                rtn = rtn + CronEntry.makeOne(first, spec) + "-" + CronEntry.makeOne(last, spec);
            }
            if (1 < step) {
                rtn = rtn + "/" + step;
            }
        }
        return rtn;
    }

    static boolean[] parseEntry(String entry, int arraySize, int arrayBase, String[] names) throws TimerParseException {
        if (entry == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(entry, ",");
        boolean[] array = new boolean[arraySize];
        while (tokenizer.hasMoreTokens()) {
            CronEntry.parseRange(tokenizer.nextToken(), array, arrayBase, names);
        }
        return array;
    }

    static boolean[] parseTokenSimplify(String token, int arraySize, int arrayBase, String[] names) throws TimerParseException, TimerEmptyException {
        boolean[] array = CronEntry.parseEntry(token, arraySize, arrayBase, names);
        return CronEntry.simplifyArray(array, arraySize);
    }

    static boolean[] expandArray(boolean[] array, int arraySize) {
        boolean[] rtn = new boolean[arraySize];
        if (array == null) {
            for (int i = 0; i < arraySize; ++i) {
                rtn[i] = true;
            }
        } else {
            for (int i = 0; i < array.length; ++i) {
                rtn[i] = array[i];
            }
        }
        return rtn;
    }

    static boolean[] simplifyArray(boolean[] array, int arraySize) throws TimerEmptyException {
        int last = -1;
        int count = 0;
        for (int i = 0; i < arraySize; ++i) {
            if (!array[i]) continue;
            ++count;
            last = i;
        }
        if (last < 0) {
            m_logger.finest("Illegal CronEntry has no valid times");
            throw new TimerEmptyException("Illegal CronEntry has no valid times");
        }
        if (count == arraySize) {
            return null;
        }
        boolean[] rtn = new boolean[last + 1];
        System.arraycopy(array, 0, rtn, 0, last + 1);
        return rtn;
    }

    static int entryToIndex(String[] names, String tok, int arrayBase) throws TimerParseException {
        char first = tok.charAt(0);
        if (Character.isLetter(first) && names != null) {
            tok = tok.toUpperCase();
            for (int i = 0; i < names.length; ++i) {
                if (!tok.equals(names[i])) continue;
                return i + arrayBase;
            }
        } else {
            try {
                return Integer.parseInt(tok);
            }
            catch (NumberFormatException e) {
                m_logger.finest("Can't parse number: " + tok);
                throw new TimerParseException("Can't parse number: " + tok);
            }
        }
        throw new TimerParseException("Name: " + tok + " not understood");
    }

    static void parseRange(String token, boolean[] array, int arrayBase, String[] names) throws TimerParseException {
        int end = token.length();
        int step = 1;
        int index = token.indexOf(47);
        if (0 < index) {
            try {
                step = Integer.parseInt(token.substring(index + 1));
            }
            catch (NumberFormatException e) {
                throw new TimerParseException("Can't parse number: " + token.substring(index + 1));
            }
            end = index;
        }
        String range = token.substring(0, end);
        int rangeBegin = 0;
        int rangeEnd = 0;
        if (range.equals("*")) {
            rangeBegin = 0;
            rangeEnd = array.length - 1;
        } else {
            index = token.indexOf("-");
            if (index > 0) {
                rangeBegin = CronEntry.entryToIndex(names, range.substring(0, index), arrayBase);
                rangeEnd = CronEntry.entryToIndex(names, range.substring(index + 1), arrayBase);
            } else {
                if (step != 1) {
                    throw new TimerParseException("Must combine step syntax '/' with a range");
                }
                rangeBegin = rangeEnd = CronEntry.entryToIndex(names, range, arrayBase);
            }
            rangeBegin -= arrayBase;
            rangeEnd -= arrayBase;
        }
        if (rangeBegin < 0 || array.length <= rangeEnd) {
            m_logger.finest("Number out of range");
            throw new TimerParseException("Number out of range");
        }
        for (int i = rangeBegin; i <= rangeEnd; i += step) {
            array[i] = true;
        }
    }

    public void set(String v, DateUtil.TimeUnitSpec spec) throws TimerParseException, TimerEmptyException {
        Class cls = CronEntry.class;
        boolean[] set = CronEntry.parseTokenSimplify(v, spec.size, spec.arrayBase, spec.shortNames);
        try {
            Field fld = cls.getDeclaredField(spec.name + "BooleanArray");
            fld.set(this, set);
        }
        catch (NoSuchFieldException e) {
            m_logger.finest("CronEntry -- NoSuchFieldException: Can't happen");
        }
        catch (IllegalAccessException e) {
            m_logger.finest("CronEntry -- IllegalAccessException: Can't happen");
        }
    }

    public void set(boolean[] array, DateUtil.TimeUnitSpec spec) throws TimerEmptyException {
        Class cls = CronEntry.class;
        boolean[] set = CronEntry.simplifyArray(array, spec.size);
        try {
            Field fld = cls.getDeclaredField(spec.name + "BooleanArray");
            fld.set(this, set);
        }
        catch (NoSuchFieldException e) {
            m_logger.finest("CronEntry -- NoSuchFieldException: Can't happen");
        }
        catch (IllegalAccessException e) {
            TimerService.instance().error("CronEntry", "IllegalAccessException: Can't happen");
        }
    }

    public String getString(DateUtil.TimeUnitSpec spec) {
        Class cls = CronEntry.class;
        try {
            Field fld = cls.getDeclaredField(spec.name + "BooleanArray");
            boolean[] set = (boolean[])fld.get(this);
            return CronEntry.entryToString(set, spec);
        }
        catch (NoSuchFieldException e) {
            m_logger.finest("CronEntry -- NoSuchFieldException: Can't happen");
        }
        catch (IllegalAccessException e) {
            m_logger.finest("CronEntry -- IllegalAccessException: Can't happen");
        }
        return null;
    }

    public boolean[] getArray(DateUtil.TimeUnitSpec spec) {
        Class cls = CronEntry.class;
        try {
            Field fld = cls.getDeclaredField(spec.name + "BooleanArray");
            boolean[] set = (boolean[])fld.get(this);
            return CronEntry.expandArray(set, spec.size);
        }
        catch (NoSuchFieldException e) {
            m_logger.finest("CronEntry -- NoSuchFieldException: Can't happen");
        }
        catch (IllegalAccessException e) {
            m_logger.finest("CronEntry -- IllegalAccessException: Can't happen");
        }
        return null;
    }

    public long nextEvent(long fromTime) {
        long rtn;
        long retest = this.calcNextEvent(fromTime);
        long elapsed = retest - fromTime;
        while ((rtn = retest) != (retest = this.calcNextEvent(rtn))) {
        }
        long elapsed2 = rtn - fromTime;
        return rtn;
    }

    public void parse(String str, DateUtil.TimeUnitSpec[] style) throws TimerParseException, TimerEmptyException {
        StringTokenizer tokenizer = new StringTokenizer(str, " ");
        int i = 0;
        i = 0;
        while (tokenizer.hasMoreElements()) {
            String token = tokenizer.nextToken();
            if (i < style.length) {
                this.set(token, style[i]);
            } else if (i == style.length) {
                super.setClass(token);
            }
            ++i;
        }
        if (i < style.length) {
            m_logger.finest("At least " + style.length + 1 + " terms required");
            throw new TimerParseException("At least " + style.length + 1 + " terms required");
        }
    }

    int findNext(int tm, boolean[] array) throws TimerEmptyException {
        int c;
        this._rotate = 0;
        for (c = 0; !(array == null || array.length > tm && array[tm] || c > array.length); ++c) {
            if (array.length > ++tm) continue;
            this._rotate = 1;
            tm = 0;
        }
        if (array != null && array.length < c) {
            m_logger.finest("Illegal CronEntry has no valid times");
            throw new TimerEmptyException("Illegal CronEntry has no valid times");
        }
        return tm;
    }

    long calcNextEvent(long fromTime) {
        this.date.setTime(fromTime);
        this.from.setTime(this.date);
        long diff = fromTime - this.from.getTimeInMillis();
        int sec1 = this.from.get(13);
        int min1 = this.from.get(12);
        int hour1 = this.from.get(11);
        int date1 = this.from.get(5) - 1;
        int day1 = this.from.get(7) - 1;
        int month1 = this.from.get(2);
        int year1 = this.from.get(1) - DateUtil.k_startBaseYear;
        try {
            int sec2 = this.findNext(sec1 + this._rotate, this.secondBooleanArray);
            int min2 = this.findNext(min1 + this._rotate, this.minuteBooleanArray);
            int hour2 = this.findNext(hour1 + this._rotate, this.hourBooleanArray);
            int rotateday = this._rotate;
            int day2 = this.findNext(day1 + rotateday, this.dayBooleanArray);
            int dayDiff = day2 + this._rotate * 7 - day1;
            int date2 = this.findNext(date1 + rotateday, this.dateBooleanArray);
            if (this._rotate == 0 && !DateUtil.isValidDate(date2 + 1, month1, year1 + DateUtil.k_startBaseYear)) {
                date2 = this.findNext(0, this.dateBooleanArray);
                this._rotate = 1;
            }
            int month2 = this.findNext(month1 + this._rotate, this.monthBooleanArray);
            int year2 = this.findNext(year1 + this._rotate, this.yearBooleanArray);
            if (this._rotate != 0) {
                return Long.MAX_VALUE;
            }
            this.calendarDate.set(year2 + DateUtil.k_startBaseYear, month2, date2 + 1, hour2, min2, sec2);
            this.calendarDay.set(year2 + DateUtil.k_startBaseYear, month2, date1 + 1 + dayDiff, hour2, min2, sec2);
            Calendar cal = null;
            cal = this.dayBooleanArray == null ? this.calendarDate : (this.dateBooleanArray == null ? this.calendarDay : (this.calendarDay.before(this.calendarDate) ? this.calendarDay : this.calendarDate));
            if (100 <= year2) {
                return Long.MAX_VALUE;
            }
            return cal.getTime().getTime();
        }
        catch (TimerEmptyException e) {
            return Long.MAX_VALUE;
        }
    }

    public String toString() {
        return "@: " + this.getString() + " nextTimeout " + this.getNextTimeout(this.lastScheduled) + " lastScheduled " + new Date(this.lastScheduled) + " timer " + this.timer;
    }

    public String getString() {
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < this._style.length; ++i) {
            if (i > 0) {
                str.append(" ");
            }
            str.append(this.getString(this._style[i]));
        }
        return str.toString();
    }

    public boolean repeats() {
        return true;
    }

    public long getTimeRemaining() throws IllegalStateException {
        return this.calcNextEvent(System.currentTimeMillis());
    }

    public Date getNextTimeout() throws IllegalStateException {
        long nextTime = this.nextEvent(System.currentTimeMillis());
        return new Date(nextTime);
    }

    public Date getNextTimeout(long fromTime) {
        long nextTime = this.nextEvent(fromTime);
        return new Date(nextTime);
    }

    public CronEntry() {
    }

    public void readEntry(ObjectInputStream in) throws ClassNotFoundException, IOException {
        block4: {
            this._rotate = in.readInt();
            String style = in.readUTF();
            this._style = this.getStyle(style);
            String cronStr = in.readUTF();
            try {
                this.parse(cronStr, this._style);
            }
            catch (TimerParseException e) {
                m_logger.finest("TimerParseException " + e);
                if (m_logger.isLoggable(Level.FINEST)) {
                    m_logger.log(Level.FINEST, e.getMessage(), e);
                }
            }
            catch (TimerEmptyException e) {
                m_logger.finest("TimerEmptyException " + e);
                if (!m_logger.isLoggable(Level.FINEST)) break block4;
                m_logger.log(Level.FINEST, e.getMessage(), e);
            }
        }
        this.read(in);
    }

    public void writeEntry(ObjectOutputStream out) throws IOException {
        out.writeInt(this._rotate);
        out.writeUTF(this.getStyleString());
        out.writeUTF(this.getString());
        this.write(out);
    }

    public String getStyleString() {
        if (this._style == DateUtil.CRON_STYLE) {
            return "CRON_STYLE";
        }
        if (this._style == DateUtil.CRON_STYLE_AND_YEARS) {
            return "CRON_STYLE_AND_YEARS";
        }
        if (this._style == DateUtil.CRON_STYLE_WITH_SECONDS_AND_YEARS) {
            return "CRON_STYLE_WITH_SECONDS_AND_YEARS";
        }
        return "UNKNOWN_STYLE";
    }

    public DateUtil.TimeUnitSpec[] getStyle(String style) {
        if (style.equals("CRON_STYLE")) {
            return DateUtil.CRON_STYLE;
        }
        if (style.equals("CRON_STYLE_AND_YEARS")) {
            return DateUtil.CRON_STYLE_AND_YEARS;
        }
        if (style.equals("CRON_STYLE_WITH_SECONDS_AND_YEARS")) {
            return DateUtil.CRON_STYLE_WITH_SECONDS_AND_YEARS;
        }
        return null;
    }
}

