/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.container.scheduler;

import EDU.oswego.cs.dl.util.concurrent.LinkedQueue;
import com.evermind.util.ServicesProperties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ias.container.ContainerService;
import oracle.ias.container.ContainerServiceManager;
import oracle.ias.container.event.Event;
import oracle.ias.container.event.EventService;
import oracle.ias.container.event.InvalidEventTypeException;
import oracle.ias.container.event.PushSubscriber;
import oracle.ias.container.logging.ContainerServiceMessages;
import oracle.ias.container.logging.ContainerServiceTraceLogger;
import oracle.ias.container.scheduler.ExecutorEvent;
import oracle.ias.container.scheduler.JobEvent;
import oracle.ias.container.scheduler.Task;
import oracle.ias.container.scheduler.TimerTask;
import oracle.ias.container.timer.TimerEvent;

public final class ExecutorService
extends ContainerService
implements PushSubscriber {
    public static int k_schedulerServiceId = 1403;
    private final LinkedQueue _queue = new LinkedQueue();
    private volatile int _runningTasks = 0;
    private int _maxConcurrentTasks = ServicesProperties.getExecutorConcurrentTasks();
    private static Logger m_logger = ContainerServiceTraceLogger.getTraceLogger(ExecutorService.class);
    private static ExecutorService _instance = null;

    private ExecutorService() {
        super("Scheduler Service");
        _instance = this;
        this.m_threaded = true;
        this.m_serviceId = k_schedulerServiceId;
    }

    public static ExecutorService instance() {
        if (_instance == null) {
            _instance = new ExecutorService();
        }
        return _instance;
    }

    protected boolean execute(Task command) {
        ContainerServiceManager.instance().launch(command);
        return true;
    }

    public void doRun() throws InterruptedException {
        if (!this.isThreaded()) {
            this.m_status = 1;
        }
        if (!this._queue.isEmpty()) {
            this.tryExecute();
            this.sleep(this._defaultInterval);
        } else {
            this.sleep(this._defaultInterval * 300L);
        }
    }

    public void doStop() throws InterruptedException {
        if (!this.isThreaded()) {
            this.m_status = 0;
        }
    }

    public void doPause() throws InterruptedException {
        if (!this.isThreaded()) {
            this.m_status = 2;
        }
    }

    public boolean start() {
        try {
            EventService.instance().subscribe(TimerEvent.class, null, this);
            EventService.instance().subscribe(JobEvent.class, null, this);
        }
        catch (InvalidEventTypeException e) {
            ContainerServiceMessages.warningException(e);
        }
        this._running = true;
        this.m_status = 1;
        if (this.isThreaded()) {
            super.start();
        } else {
            m_logger.finest("Executor service : " + this + " has been started.");
        }
        return true;
    }

    public boolean stop() {
        if (this.isThreaded()) {
            return super.stop();
        }
        m_logger.finest("Executor service : " + this + " has been stopped.");
        this.m_status = 0;
        return true;
    }

    public boolean pause() {
        if (this.isThreaded()) {
            return super.pause();
        }
        m_logger.finest("Executor service : " + this + " is paused.");
        this.m_status = 2;
        return true;
    }

    public boolean resume() {
        if (this.isThreaded()) {
            return super.resume();
        }
        m_logger.finest("Executor service : " + this + " has resumed.");
        this.m_status = 1;
        return true;
    }

    public void inform(Event event) {
        m_logger.finest("Executor service inform: " + event);
        int state = ((ExecutorEvent)event).getState();
        switch (state) {
            case 1: {
                this.scheduleForExecution((ExecutorEvent)event);
                this.wake();
                break;
            }
            case 2: {
                this.wake();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incRunningTasks() {
        ExecutorService executorService = this;
        synchronized (executorService) {
            ++this._runningTasks;
        }
        m_logger.finest("Executor service has running tasks of " + this._runningTasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decRunningTasks() {
        ExecutorService executorService = this;
        synchronized (executorService) {
            --this._runningTasks;
        }
        this.wake();
        m_logger.finest("Executor service has running tasks of " + this._runningTasks);
    }

    private boolean scheduleForExecution(ExecutorEvent event) {
        m_logger.finest("Executor Service schedule execution for: " + event);
        try {
            int state;
            if (this._runningTasks >= this._maxConcurrentTasks) {
                RuntimeException e = new RuntimeException("Maximum Number Concurency for the Timer has been reached");
                ContainerServiceMessages.warningMaximumConccurentTimer(e);
            }
            if ((state = event.getState()) < 2) {
                if (event instanceof TimerEvent) {
                    TimerEvent t = (TimerEvent)event;
                    t.setState(2, false);
                    this._queue.put(t);
                    t.setState(2, true);
                } else if (event instanceof JobEvent) {
                    JobEvent j = (JobEvent)event;
                    j.setState(2, false);
                    this._queue.put(j);
                    j.setState(2, true);
                }
            }
        }
        catch (InterruptedException e) {
            ContainerServiceMessages.warningException(e);
            m_logger.log(Level.FINEST, e.getMessage(), e);
            return false;
        }
        return true;
    }

    private boolean tryExecute() {
        boolean retCode = false;
        try {
            if (this._runningTasks < this._maxConcurrentTasks) {
                Object tobj = this._queue.poll(300L);
                if (tobj != null) {
                    if (tobj instanceof TimerEvent) {
                        TimerTask task = new TimerTask((TimerEvent)tobj);
                        task.init();
                        retCode = this.execute(task);
                    } else if (tobj instanceof JobEvent) {
                        Task task = new Task((JobEvent)tobj);
                        retCode = this.execute(task);
                    }
                }
            } else {
                RuntimeException anException = new RuntimeException("Maximum Number Concurency for the Timer has been reached");
                ContainerServiceMessages.warningMaximumConccurentTimer(anException);
            }
        }
        catch (InterruptedException e) {
            ContainerServiceMessages.warningException(e);
            m_logger.log(Level.FINEST, e.getMessage(), e);
        }
        return retCode;
    }

    public EventService getEventService() {
        return EventService.instance();
    }

    public boolean isPush() {
        return true;
    }
}

