/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.container.persistence;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import oracle.ias.container.persistence.InternalPM;
import oracle.ias.container.persistence.InternalPMFactory;

public class InternalPMManager {
    private static InternalPMManager managerInstance;
    private Map transactionalPM = new HashMap();
    private Map nonTransactionalPM = new HashMap();

    private InternalPMManager() {
        managerInstance = this;
    }

    public static InternalPMManager getInstance() {
        if (managerInstance == null) {
            return new InternalPMManager();
        }
        return managerInstance;
    }

    public InternalPM getTransactionalPM(String applicationName, String key, ClassLoader classloader) {
        InternalPM aPM = this.getInternalTransactionalPM(key);
        if (aPM == null) {
            aPM = InternalPMFactory.getInstance().createTransactionalInternalPM(applicationName, classloader);
            this.addToTransactionalPM(key, aPM);
        }
        return aPM;
    }

    public InternalPM getNonTransactionalPM(String applicationName, String key, ClassLoader classloader) {
        InternalPM aPM = this.getInternalNonTransactionalPM(key);
        if (aPM == null) {
            aPM = InternalPMFactory.getInstance().createNonTransactionalInternalPM(applicationName, classloader);
            this.addToNonTransactionalPM(key, aPM);
        }
        return aPM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String applicationName) {
        String key;
        Map map = this.nonTransactionalPM;
        synchronized (map) {
            Set nonTransactionalKeySet = this.nonTransactionalPM.keySet();
            Iterator nonTransactionalKeyIterator = nonTransactionalKeySet.iterator();
            while (nonTransactionalKeyIterator.hasNext()) {
                key = (String)nonTransactionalKeyIterator.next();
                InternalPM aNonTxPM = this.getInternalNonTransactionalPM(key);
                if (aNonTxPM == null || !applicationName.equals(aNonTxPM.getApplicationName())) continue;
                aNonTxPM.destroy();
                nonTransactionalKeyIterator.remove();
            }
        }
        map = this.transactionalPM;
        synchronized (map) {
            Set transactionalKeySet = this.transactionalPM.keySet();
            Iterator transactionalKeyIterator = transactionalKeySet.iterator();
            while (transactionalKeyIterator.hasNext()) {
                key = (String)transactionalKeyIterator.next();
                InternalPM aTxPM = this.getInternalTransactionalPM(key);
                if (aTxPM == null || !applicationName.equals(aTxPM.getApplicationName())) continue;
                aTxPM.destroy();
                transactionalKeyIterator.remove();
            }
        }
    }

    private InternalPM getInternalTransactionalPM(Object key) {
        return (InternalPM)this.transactionalPM.get(key);
    }

    private InternalPM getInternalNonTransactionalPM(Object key) {
        return (InternalPM)this.nonTransactionalPM.get(key);
    }

    private void addToTransactionalPM(Object key, InternalPM persistenceManager) {
        this.transactionalPM.put(key, persistenceManager);
    }

    private void addToNonTransactionalPM(Object key, InternalPM persistenceManager) {
        this.nonTransactionalPM.put(key, persistenceManager);
    }
}

