/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.container.event;

import java.util.ArrayList;
import oracle.ias.container.event.Event;
import oracle.ias.container.event.Filter;
import oracle.ias.container.event.PushSubscriber;
import oracle.ias.container.event.Subscriber;

public class Subscription {
    static final int k_priority_immediate = 0;
    static final int k_priority_afterDelivery = 1;
    static final int k_priority_queued = 2;
    static final int k_priority_queuedOverlap = 3;
    public Class eventType;
    public Filter filter;
    public Subscriber subscriber;
    public int priority = 2;
    public byte debug = 0;
    public boolean isPush = false;
    private boolean _active;
    private ArrayList _queue = null;

    public Subscription(Class anEventType, Filter aFilter, Subscriber aSubscriber) {
        this.eventType = anEventType;
        this.filter = aFilter;
        this.subscriber = aSubscriber;
        if (this.subscriber instanceof PushSubscriber) {
            this.isPush = true;
        } else {
            this.isPush = false;
            this._queue = new ArrayList();
        }
        this._active = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queue(Event event) {
        ArrayList arrayList = this._queue;
        synchronized (arrayList) {
            this._queue.add(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Event deQueue() {
        ArrayList arrayList = this._queue;
        synchronized (arrayList) {
            Event event = null;
            if (!this._queue.isEmpty()) {
                event = (Event)this._queue.remove(1);
            }
            return event;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList deQueueAll() {
        ArrayList arrayList = this._queue;
        synchronized (arrayList) {
            ArrayList events = null;
            if (!this._queue.isEmpty()) {
                events = (ArrayList)this._queue.clone();
                this._queue.clear();
            }
            return events;
        }
    }

    public boolean isActive() {
        return this._active;
    }

    public void deactivate() {
        this._active = false;
        if (this._queue != null) {
            this._queue.clear();
        }
    }

    public boolean equals(Subscription obj) {
        boolean equal = false;
        Subscription subscription = obj;
        if (this.subscriber == subscription.subscriber && this.filter == subscription.filter && this.eventType == subscription.eventType) {
            equal = true;
        }
        return equal;
    }
}

