/*
 * Decompiled with CFR 0.152.
 */
package oracle.hooks;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import java.security.SecureClassLoader;
import java.util.Hashtable;
import oracle.hooks.Hook;

public class TrampolineGenerator {
    private static Object[] CLASS_TEMPLATE = new Object[]{new int[]{202, 254, 186, 190}, new int[]{0, 0}, new int[]{0, 46}, new int[]{0, 25}, new int[]{10, 0, 3, 0, 8}, new int[]{7, 0, 9}, new int[]{7, 0, 10}, TrampolineGenerator.makeUTFConstant("<init>"), TrampolineGenerator.makeUTFConstant("()V"), TrampolineGenerator.makeUTFConstant("Code"), TrampolineGenerator.makeUTFConstant("this"), new int[]{12, 0, 4, 0, 5}, new UTFPatch("CLASS_NAME"), TrampolineGenerator.makeUTFConstant("java/lang/Object"), new int[]{7, 0, 12}, new UTFPatch("INTERFACE_NAME"), TrampolineGenerator.makeUTFConstant("execute"), new UTFPatch("EXECUTE_SIGNATURE"), TrampolineGenerator.makeUTFConstant("target"), new UTFPatch("TARGET_SIGNATURE"), new int[]{9, 0, 2, 0, 18}, new int[]{12, 0, 15, 0, 16}, TrampolineGenerator.makeUTFConstant("InnerClasses"), new int[]{7, 0, 21}, TrampolineGenerator.makeUTFConstant("oracle/hooks/Hook"), new UTFPatch("INTERFACE_INNER_CLASS_SHORT_NAME"), new int[]{11, 0, 11, 0, 24}, new int[]{12, 0, 13, 0, 14}, new int[]{0, 33}, new int[]{0, 2}, new int[]{0, 3}, new int[]{0, 1}, new int[]{0, 11}, new int[]{0, 1}, new int[]{0, 1}, new int[]{0, 15}, new int[]{0, 16}, new int[]{0, 0}, new int[]{0, 2}, new int[]{0, 1}, new int[]{0, 4}, new int[]{0, 5}, new int[]{0, 1}, new int[]{0, 6}, new int[]{0, 0, 0, 17}, new int[]{0, 1}, new int[]{0, 1}, new int[]{0, 0, 0, 5}, new int[]{42}, new int[]{183, 0, 1}, new int[]{177}, new int[]{0, 0}, new int[]{0, 0}, new int[]{0, 1}, new int[]{0, 13}, new int[]{0, 14}, new int[]{0, 1}, new int[]{0, 6}, new int[]{0, 0, 0, 25}, new int[]{0, 4}, new int[]{0, 4}, new int[]{0, 0, 0, 13}, new int[]{42}, new int[]{180, 0, 17}, new Patch(){

        public int[] getBytes(Hashtable props) {
            int numParams = (Integer)props.get("NUM_EXECUTE_ARGS");
            int[] ops = new int[]{0, 0, 0};
            switch (numParams) {
                case 0: {
                    break;
                }
                case 1: {
                    ops[0] = 43;
                    break;
                }
                case 2: {
                    ops[0] = 43;
                    ops[1] = 44;
                    break;
                }
                case 3: {
                    ops[0] = 43;
                    ops[1] = 44;
                    ops[2] = 45;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Delegate Generator does not currently support 'execute' methods with greater than three arguments; found " + numParams + " arguments.");
                }
            }
            return ops;
        }
    }, new Patch(){

        public int[] getBytes(Hashtable props) {
            int numParams = (Integer)props.get("NUM_EXECUTE_ARGS");
            return new int[]{185, 0, 23, 1 + numParams, 0};
        }
    }, new Patch(){

        public int[] getBytes(Hashtable props) {
            if (((Method)props.get("EXECUTE_METHOD_OBJECT")).getReturnType() == Void.TYPE) {
                return new int[]{177};
            }
            return new int[]{176};
        }
    }, new int[]{0, 0}, new int[]{0, 0}, new int[]{0, 1}, new int[]{0, 19}, new int[]{0, 0, 0, 10}, new int[]{0, 1}, new int[]{0, 11}, new int[]{0, 20}, new int[]{0, 22}, new int[]{6, 9}};

    public static Hook create(String fullClassName, String hookInterfaceName, Hook orig) {
        Class c = new TrampolineClassLoader().makeTrampoline(fullClassName, TrampolineGenerator.generate(fullClassName, hookInterfaceName), orig.getClass().getProtectionDomain());
        try {
            Hook h = (Hook)c.newInstance();
            c.getField("target").set(h, orig);
            return h;
        }
        catch (Exception e) {
            throw (RuntimeException)new RuntimeException("Unable to create trampoline for hook: " + orig).initCause(e);
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static byte[] generate(String fullClassName, String hookInterfaceName) {
        Class<?> hookInterface = null;
        try {
            hookInterface = Class.forName(hookInterfaceName, true, Thread.currentThread().getContextClassLoader());
        }
        catch (Exception e) {
            throw (RuntimeException)new RuntimeException("Error loading hook interface class: " + hookInterfaceName).initCause(e);
        }
        Method executeMethod = TrampolineGenerator.getExecuteMethodOrComplain(hookInterface.getDeclaredMethods());
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        props.put("CLASS_NAME", fullClassName.replace('.', '/'));
        props.put("INTERFACE_NAME", hookInterfaceName.replace('.', '/'));
        props.put("INTERFACE_INNER_CLASS_SHORT_NAME", hookInterfaceName.substring(hookInterfaceName.lastIndexOf("$")));
        props.put("EXECUTE_SIGNATURE", TrampolineGenerator.makeMethodSignature(executeMethod));
        props.put("NUM_EXECUTE_ARGS", new Integer(executeMethod.getParameterTypes().length));
        props.put("EXECUTE_METHOD_OBJECT", executeMethod);
        props.put("TARGET_SIGNATURE", TrampolineGenerator.makeJVMInternalTypeSig(hookInterface));
        ByteArrayOutputStream bArray = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bArray);
        for (int i = 0; i < CLASS_TEMPLATE.length; ++i) {
            int[] data = null;
            if (CLASS_TEMPLATE[i] instanceof int[]) {
                data = (int[])CLASS_TEMPLATE[i];
            } else {
                if (!(CLASS_TEMPLATE[i] instanceof Patch)) throw new IllegalArgumentException("Unknown data type in CLASS_TEMPLATE; " + CLASS_TEMPLATE[i]);
                data = ((Patch)CLASS_TEMPLATE[i]).getBytes(props);
            }
            for (int j = 0; j < data.length; ++j) {
                out.writeByte((byte)data[j]);
            }
        }
        out.flush();
        Object var11_12 = null;
        if (null == out) return bArray.toByteArray();
        try {
            out.close();
            return bArray.toByteArray();
        }
        catch (Exception e) {
            System.err.println("Error closing stream: " + e);
        }
        return bArray.toByteArray();
        {
            catch (IOException e) {
                throw (RuntimeException)new RuntimeException("Error generating named class: " + fullClassName).initCause(e);
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            if (null == out) throw throwable;
            try {
                out.close();
                throw throwable;
            }
            catch (Exception e) {
                System.err.println("Error closing stream: " + e);
            }
            throw throwable;
        }
    }

    private static int[] makeUTFConstant(String s) {
        int len = s.length();
        int[] bytes = new int[3 + len];
        bytes[0] = 1;
        bytes[1] = len & 0xFF00;
        bytes[2] = len & 0xFF;
        char[] chars = s.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            bytes[3 + i] = chars[i];
        }
        return bytes;
    }

    private static String makeMethodSignature(Method m) {
        StringBuffer sig = new StringBuffer();
        sig.append("(");
        Class<?>[] params = m.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            sig.append(TrampolineGenerator.makeJVMInternalTypeSig(params[i]));
        }
        sig.append(")");
        sig.append(TrampolineGenerator.makeJVMInternalTypeSig(m.getReturnType()));
        return sig.toString();
    }

    private static String makeJVMInternalTypeSig(Class c) {
        if (c == Void.TYPE) {
            return "V";
        }
        return Array.newInstance(c, 0).getClass().getName().substring(1).replace('.', '/');
    }

    private static Method getExecuteMethodOrComplain(Method[] methods) {
        String errorString = null;
        if (methods.length == 0) {
            errorString = "; no methods";
        } else if (methods.length > 1) {
            StringBuffer methodString = new StringBuffer();
            for (int i = 0; i < methods.length; ++i) {
                methodString.append(methods[i].toString());
                if (i + 1 >= methods.length) continue;
                methodString.append(", ");
            }
            errorString = methods.length + " methods; they are: [" + methodString.toString() + "]";
        } else if (!methods[0].getName().equals("execute")) {
            errorString = methods[0].getName();
        }
        if (null != errorString) {
            throw new IllegalArgumentException("Hook.* interfaces are intended to contain only one 'execute' method;  the given interface declares: " + errorString);
        }
        return methods[0];
    }

    public static void main(String[] args) throws Exception {
        byte[] bytes = TrampolineGenerator.generate(args[0], args[1]);
        DataOutputStream out = new DataOutputStream(System.out);
        for (int i = 0; i < bytes.length; ++i) {
            out.writeByte(bytes[i]);
        }
        out.flush();
        out.close();
    }

    private static class TrampolineClassLoader
    extends SecureClassLoader {
        public TrampolineClassLoader() {
            super(Thread.currentThread().getContextClassLoader());
        }

        public Class makeTrampoline(String name, byte[] bytes, ProtectionDomain pd) {
            return super.defineClass(name, bytes, 0, bytes.length, pd);
        }
    }

    private static class UTFPatch
    extends Patch {
        protected String m_property;

        public UTFPatch(String prop) {
            this.m_property = prop;
        }

        public int[] getBytes(Hashtable properties) {
            String newValue = (String)properties.get(this.m_property);
            if (null == newValue) {
                throw new RuntimeException("Missing: " + this.m_property + " from generation properties.");
            }
            return TrampolineGenerator.makeUTFConstant(newValue);
        }
    }

    private static abstract class Patch {
        private Patch() {
        }

        public abstract int[] getBytes(Hashtable var1);
    }
}

