/*
 * Decompiled with CFR 0.152.
 */
package oracle.hooks;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import oracle.hooks.Extension;
import oracle.hooks.Interrupt;

public abstract class InterruptProtocol {
    public static final String EXTENSION_PROP = "oracle.hooks";
    private static final boolean DEBUG = null != System.getProperty("DEBUG", "");
    private static boolean s_extensionsLoaded = false;
    private static HashSet s_alreadyInitializedProtocols = new HashSet();
    private static Hashtable s_pendingExtensions = new Hashtable();
    static /* synthetic */ Class class$oracle$hooks$Interrupt;

    protected InterruptProtocol() {
    }

    public static void loadStaticExtensions() {
        String[] exts;
        if (s_extensionsLoaded) {
            return;
        }
        s_extensionsLoaded = true;
        String pValue = System.getProperty(EXTENSION_PROP, null);
        if (null == pValue) {
            exts = new String[]{};
        } else {
            InterruptProtocol.log("Loading extensions");
            exts = pValue.split(" *; *");
        }
        for (int i = 0; i < exts.length; ++i) {
            String ext = exts[i].trim();
            if (ext == null || "".equals(ext)) continue;
            String klass = null;
            String args = null;
            int openParen = ext.indexOf("(");
            if (-1 != openParen) {
                if (!ext.endsWith(")")) {
                    throw new RuntimeException("Extension argument syntax error; syntax is: '[extensionPackage.]*extensionClass *( [arg1]? *[, argN]* ) *;'; received: '" + ext + "'; missing closing parenthesis.");
                }
                klass = ext.substring(0, openParen);
                args = ext.substring(openParen + 1, ext.length() - 1).trim();
            } else {
                klass = ext;
                args = "";
            }
            InterruptProtocol.log("Loading extension class: " + klass + (args == "" ? "" : " with arguments: " + args));
            InterruptProtocol.registerExtensionClass(klass, args.split(","), Thread.currentThread().getContextClassLoader());
        }
    }

    public static void loadDynamicExtension(String extensionClassName, String[] args) {
        InterruptProtocol.registerExtensionClass(extensionClassName, args == null ? args : new String[]{}, Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void initializeProtocol(Class protocolClass) {
        if (s_alreadyInitializedProtocols.contains(protocolClass)) {
            return;
        }
        HashSet hashSet = s_alreadyInitializedProtocols;
        synchronized (hashSet) {
            if (s_alreadyInitializedProtocols.contains(protocolClass)) {
                return;
            }
            Field[] fields = protocolClass.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                int flags = 9;
                Field f = fields[i];
                if (flags != (flags & f.getModifiers()) || !(class$oracle$hooks$Interrupt == null ? InterruptProtocol.class$("oracle.hooks.Interrupt") : class$oracle$hooks$Interrupt).isAssignableFrom(f.getType())) continue;
                try {
                    Interrupt interrupt = InterruptProtocol.makeInterrupt(f);
                    f.set(null, interrupt);
                    continue;
                }
                catch (IllegalAccessException e) {
                    throw (RuntimeException)new RuntimeException("Unexpected access exception initializing field: " + f + " of class: " + f.getClass()).initCause(e);
                }
                catch (InstantiationException e) {
                    throw (RuntimeException)new RuntimeException("Unable to instantiate instance of field: " + f + " of class: " + f.getClass()).initCause(e);
                }
            }
            Method afterInitialized = null;
            try {
                afterInitialized = protocolClass.getMethod("afterInitialized", null);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            if (null != afterInitialized) {
                int flags = 9;
                if (flags != (flags & afterInitialized.getModifiers())) {
                    throw new RuntimeException("afterInitialized() method exists on class: " + protocolClass + " but it is declared incorrectly; It must be both public and static.");
                }
                try {
                    afterInitialized.invoke(null, null);
                }
                catch (IllegalAccessException e) {
                    throw (RuntimeException)new RuntimeException("Unexpected access exception invoking afterInitialized method of class: " + protocolClass).initCause(e);
                }
                catch (InvocationTargetException e) {
                    throw (RuntimeException)new RuntimeException("Unexpected exception invoking afterInitialized method of class: " + protocolClass).initCause(e);
                }
            }
            s_alreadyInitializedProtocols.add(protocolClass);
        }
        HashMap extensions = (HashMap)s_pendingExtensions.get(protocolClass);
        if (null != extensions) {
            Iterator exts = extensions.keySet().iterator();
            while (exts.hasNext()) {
                Extension e = (Extension)exts.next();
                InterruptProtocol.activate(e, (String[])extensions.get(e));
            }
        }
    }

    private static Interrupt makeInterrupt(Field f) throws InstantiationException, IllegalAccessException {
        Interrupt i = (Interrupt)f.getType().newInstance();
        i.setName(f.getName());
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerExtensionClass(String klass, String[] args, ClassLoader classLoader) {
        Extension ext = null;
        try {
            Class<?> k = Class.forName(klass, true, classLoader);
            if (!Extension.class.isAssignableFrom(k)) {
                throw new IllegalArgumentException("Attempting to register an Extension class: " + k + " that does not implement oracle.hooks.Extension");
            }
            ext = (Extension)k.newInstance();
        }
        catch (Exception e) {
            throw (RuntimeException)new RuntimeException("Unable to initialize Extension class: " + klass).initCause(e);
        }
        Class[] deps = ext.getDependentProtocols();
        boolean readyToActivate = false;
        HashSet hashSet = s_alreadyInitializedProtocols;
        synchronized (hashSet) {
            int i;
            for (i = 0; i < deps.length; ++i) {
                if (!s_alreadyInitializedProtocols.contains(deps[i])) continue;
                readyToActivate = true;
            }
            if (!readyToActivate) {
                for (i = 0; i < deps.length; ++i) {
                    HashMap<Extension, String[]> queue = (HashMap<Extension, String[]>)s_pendingExtensions.get(deps[i]);
                    if (null == queue) {
                        queue = new HashMap<Extension, String[]>();
                    }
                    queue.put(ext, args);
                    s_pendingExtensions.put(deps[i], queue);
                }
            }
        }
        if (readyToActivate) {
            InterruptProtocol.activate(ext, args);
        }
    }

    private static void activate(Extension ext, String[] args) {
        Class[] deps = ext.getDependentProtocols();
        for (int i = 0; i < deps.length; ++i) {
            InterruptProtocol.initializeProtocol(deps[i]);
        }
        ext.activate(args);
    }

    private static void log(String msg) {
        if (DEBUG) {
            System.err.println("oracle.hooks: " + msg);
        }
    }

    static {
        InterruptProtocol.loadStaticExtensions();
    }
}

