/*
 * Decompiled with CFR 0.152.
 */
package oracle.as.j2ee.transaction.tpc.recovery;

import com.evermind.server.ApplicationServer;
import com.evermind.server.ApplicationServerTransactionManager;
import com.evermind.server.ApplicationServerTransactionManagerAdmin;
import com.evermind.server.InvalidConfigurationException;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.transaction.xa.Xid;
import oracle.as.j2ee.transaction.tpc.GlobalTransaction;
import oracle.as.j2ee.transaction.tpc.Store;
import oracle.as.j2ee.transaction.tpc.recovery.RecoveringTransaction;
import oracle.as.j2ee.transaction.tpc.recovery.RecoveryManager;
import oracle.as.j2ee.transaction.tpc.recovery.RecoveryManagerAdmin;
import oracle.j2ee.transaction.TransactionMessages;
import oracle.j2ee.transaction.recovery.RecoveryAbandonmentDetail;

public class RecoveryManagerAdminImpl
implements RecoveryManagerAdmin {
    private RecoveryManager m_recoveryManager;
    private Set m_recoveryAbandonmentDetails;
    private ApplicationServerTransactionManagerAdmin m_tmAdmin;

    RecoveryManagerAdminImpl(RecoveryManager recoveryManager) {
        this.m_recoveryManager = recoveryManager;
        this.m_recoveryAbandonmentDetails = new HashSet();
    }

    private Set getRecoveringTransactions() {
        return this.m_recoveryManager.getRecoveringTransactions();
    }

    private Set getPartiallyReconstructedTransactions() {
        return this.m_recoveryManager.getPartiallyReconstructedTransactions();
    }

    public GlobalTransaction[] getCopyOfTransactions() {
        GlobalTransaction[] globalTxs = new GlobalTransaction[this.getRecoveringTransactions().size() + this.getPartiallyReconstructedTransactions().size()];
        int i = -1;
        Iterator partiallyRecoveringTransactionsIterator = this.getPartiallyReconstructedTransactions().iterator();
        while (partiallyRecoveringTransactionsIterator.hasNext()) {
            globalTxs[++i] = ((RecoveringTransaction)partiallyRecoveringTransactionsIterator.next()).getGlobalTransaction();
        }
        Iterator recoveringTransactionsIterator = this.getRecoveringTransactions().iterator();
        while (recoveringTransactionsIterator.hasNext()) {
            globalTxs[++i] = ((RecoveringTransaction)recoveringTransactionsIterator.next()).getGlobalTransaction();
        }
        return globalTxs;
    }

    public void setrecoveryRetryInterval(int seconds) throws InvalidConfigurationException {
        this.m_recoveryManager.setSleepTime(seconds * 1000);
    }

    public int getrecoveryRetryInterval() throws InvalidConfigurationException {
        return new Long(this.m_recoveryManager.getSleepTime() / 1000L).intValue();
    }

    public void setRecoveryAbandonmentDetails(RecoveryAbandonmentDetail[] recoveryAbandonmentDetails) {
        if (recoveryAbandonmentDetails == null) {
            return;
        }
        for (int i = 0; i < recoveryAbandonmentDetails.length; ++i) {
            this.m_recoveryAbandonmentDetails.add(recoveryAbandonmentDetails[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abandonRecovery(Xid xid) {
        RecoveryManager recoveryManager = this.m_recoveryManager;
        synchronized (recoveryManager) {
            this.abandonRecovery(this.getPartiallyReconstructedTransactions(), xid, null, RecoveryAbandonmentDetail.ALL_TIMES, RecoveryAbandonmentDetail.ALL_COUNTS, null);
            this.abandonRecovery(this.getRecoveringTransactions(), xid, null, RecoveryAbandonmentDetail.ALL_TIMES, RecoveryAbandonmentDetail.ALL_COUNTS, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abandonRecoveryForType(String type) {
        RecoveryManager recoveryManager = this.m_recoveryManager;
        synchronized (recoveryManager) {
            this.abandonRecovery(this.getPartiallyReconstructedTransactions(), null, type, RecoveryAbandonmentDetail.ALL_TIMES, RecoveryAbandonmentDetail.ALL_COUNTS, null);
            this.abandonRecovery(this.getRecoveringTransactions(), null, type, RecoveryAbandonmentDetail.ALL_TIMES, RecoveryAbandonmentDetail.ALL_COUNTS, null);
        }
    }

    private void abandonRecovery(Set set, Xid xid, String type, int time, int count, Set participantSet) {
        LinkedList temp = new LinkedList(set);
        Iterator iter = temp.iterator();
        while (iter.hasNext()) {
            GlobalTransaction tx = null;
            RecoveringTransaction recoveringTx = (RecoveringTransaction)iter.next();
            tx = recoveringTx.getGlobalTransaction();
            try {
                boolean isTypeMatch;
                boolean bl = isTypeMatch = tx.getType() != null && (tx.getType().equals(type) || tx.getType().equals(RecoveryAbandonmentDetail.ALL_TYPES));
                if (!tx.getXid().equals(xid) && !isTypeMatch || time != RecoveryAbandonmentDetail.ALL_TIMES && tx.getTimeActive() < (long)time || count != RecoveryAbandonmentDetail.ALL_COUNTS && tx.getRecoveryReattemptCount() < count) continue;
                if (participantSet != null) {
                    boolean isAnyBranchNotCompleteOrAbandoned = false;
                    for (int i = 1; i < tx.numberOfBranches(); ++i) {
                        if (!tx.getBranch(i).getXAState().isNot(480)) continue;
                        Iterator iterator = participantSet.iterator();
                        boolean isAnyFilterApplicable = false;
                        while (iterator.hasNext()) {
                            String rmFactoryJndiLocation = tx.getBranch(i).getRmId().getRMFactoryJndiLocation().getJndiLocation();
                            String rmFactoryJndiLocationLessAppName = rmFactoryJndiLocation.substring(rmFactoryJndiLocation.indexOf(47) + 1);
                            String participantLocation = ((RecoveryAbandonmentDetail)iterator.next()).getParticipantLocation();
                            if (!participantLocation.equals(rmFactoryJndiLocation) && !participantLocation.equals(rmFactoryJndiLocationLessAppName)) continue;
                            isAnyFilterApplicable = true;
                        }
                        if (isAnyFilterApplicable) continue;
                        isAnyBranchNotCompleteOrAbandoned = true;
                        break;
                    }
                    if (isAnyBranchNotCompleteOrAbandoned) continue;
                }
                set.remove(recoveringTx);
                tx.getStore().noteForget(tx);
                TransactionMessages.finer("Successfully abandoned transaction : " + tx);
                this.fireAbandonmentEvent(tx);
            }
            catch (Store.StoreException e) {
                TransactionMessages.severe("StoreException while attempting to abandon transaction, transaction has been abandoned, however, record may still exist in store (and may therefore be processed during restart) for transaction : " + tx + "\n" + e);
            }
        }
    }

    private void fireAbandonmentEvent(GlobalTransaction tx) {
        ApplicationServer appServer = ApplicationServer.getInstance();
        ApplicationServerTransactionManager transactionManager = null;
        if (this.m_tmAdmin == null && appServer != null && (transactionManager = (ApplicationServerTransactionManager)appServer.getTransactionManager()) != null) {
            this.m_tmAdmin = new ApplicationServerTransactionManagerAdmin(transactionManager);
        }
        if (this.m_tmAdmin == null || transactionManager == null || !transactionManager.isAdminAvailable()) {
            TransactionMessages.severe("Unable to obtain transaction manager administration in order to fire abandon recovery");
        } else {
            try {
                this.m_tmAdmin.fireEvent("jtaAbandonRecoveryEvent", 0L, tx.toString());
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                TransactionMessages.severe("Unable to fire abandon recovery event : " + malformedObjectNameException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecoveryAbandonmentDetail[] setAbandonRecoveryTimeForType(String type, int time) throws InvalidConfigurationException, IOException {
        Set set = this.m_recoveryAbandonmentDetails;
        synchronized (set) {
            this.m_recoveryAbandonmentDetails.add(new RecoveryAbandonmentDetail(type, RecoveryAbandonmentDetail.ALL_PARTICIPANTS, RecoveryAbandonmentDetail.ALL_COUNTS, time));
            return this.getCopyOfRecoveryAbandonmentDetails();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecoveryAbandonmentDetail[] setAbandonRecoveryTimeForResourceManager(String type, String participantLocation, int time) throws InvalidConfigurationException, IOException {
        Set set = this.m_recoveryAbandonmentDetails;
        synchronized (set) {
            this.m_recoveryAbandonmentDetails.add(new RecoveryAbandonmentDetail(type, participantLocation, RecoveryAbandonmentDetail.ALL_COUNTS, time));
            return this.getCopyOfRecoveryAbandonmentDetails();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecoveryAbandonmentDetail[] setAbandonRecoveryCountForType(String type, int count) throws InvalidConfigurationException, IOException {
        Set set = this.m_recoveryAbandonmentDetails;
        synchronized (set) {
            this.m_recoveryAbandonmentDetails.add(new RecoveryAbandonmentDetail(type, RecoveryAbandonmentDetail.ALL_PARTICIPANTS, count, RecoveryAbandonmentDetail.ALL_TIMES));
            return this.getCopyOfRecoveryAbandonmentDetails();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecoveryAbandonmentDetail[] setAbandonRecoveryCountForResourceManager(String type, String participantLocation, int count) throws InvalidConfigurationException, IOException {
        Set set = this.m_recoveryAbandonmentDetails;
        synchronized (set) {
            this.m_recoveryAbandonmentDetails.add(new RecoveryAbandonmentDetail(type, participantLocation, count, RecoveryAbandonmentDetail.ALL_TIMES));
            return this.getCopyOfRecoveryAbandonmentDetails();
        }
    }

    RecoveryAbandonmentDetail[] getCopyOfRecoveryAbandonmentDetails() {
        Object[] recoveryAbandonmentDetail = this.m_recoveryAbandonmentDetails.toArray();
        RecoveryAbandonmentDetail[] recoveryAbandonmentDetailCopy = new RecoveryAbandonmentDetail[recoveryAbandonmentDetail.length];
        System.arraycopy(recoveryAbandonmentDetail, 0, recoveryAbandonmentDetailCopy, 0, recoveryAbandonmentDetail.length);
        return recoveryAbandonmentDetailCopy;
    }

    public void processAbandonments() {
        Iterator iterator = this.m_recoveryAbandonmentDetails.iterator();
        HashSet<RecoveryAbandonmentDetail> participantAbandonmentSet = new HashSet<RecoveryAbandonmentDetail>();
        while (iterator.hasNext()) {
            RecoveryAbandonmentDetail recoveryAbandonmentDetail = (RecoveryAbandonmentDetail)iterator.next();
            if (recoveryAbandonmentDetail.getParticipantLocation().equals(RecoveryAbandonmentDetail.ALL_PARTICIPANTS)) {
                this.abandonRecovery(this.getPartiallyReconstructedTransactions(), null, recoveryAbandonmentDetail.getType(), recoveryAbandonmentDetail.getTime(), recoveryAbandonmentDetail.getCount(), null);
                this.abandonRecovery(this.getRecoveringTransactions(), null, recoveryAbandonmentDetail.getType(), recoveryAbandonmentDetail.getTime(), recoveryAbandonmentDetail.getCount(), null);
                continue;
            }
            participantAbandonmentSet.add(recoveryAbandonmentDetail);
        }
        if (!participantAbandonmentSet.isEmpty()) {
            this.abandonRecovery(this.getPartiallyReconstructedTransactions(), null, RecoveryAbandonmentDetail.ALL_TYPES, RecoveryAbandonmentDetail.ALL_TIMES, RecoveryAbandonmentDetail.ALL_COUNTS, participantAbandonmentSet);
            this.abandonRecovery(this.getRecoveringTransactions(), null, RecoveryAbandonmentDetail.ALL_TYPES, RecoveryAbandonmentDetail.ALL_TIMES, RecoveryAbandonmentDetail.ALL_COUNTS, participantAbandonmentSet);
        }
    }
}

