/*
 * Decompiled with CFR 0.152.
 */
package oracle.as.j2ee.transaction.tpc.recovery;

import javax.transaction.HeuristicCommitException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.xa.XAResource;
import oracle.as.j2ee.transaction.tpc.Branch;
import oracle.as.j2ee.transaction.tpc.Coordinator;
import oracle.as.j2ee.transaction.tpc.GlobalTransaction;
import oracle.as.j2ee.transaction.tpc.RMId;
import oracle.as.j2ee.transaction.tpc.TPCException;
import oracle.as.j2ee.transaction.tpc.recovery.RecoveryManager;
import oracle.j2ee.transaction.TransactionMessages;

class RecoveringTransaction {
    private GlobalTransaction m_transaction;
    private RecoveryManager m_recoveryManager;

    RecoveringTransaction(GlobalTransaction transaction, RecoveryManager recoveryManager) {
        this.m_transaction = transaction;
        this.m_recoveryManager = recoveryManager;
    }

    GlobalTransaction getGlobalTransaction() {
        return this.m_transaction;
    }

    synchronized boolean resolve() {
        if (!this.m_transaction.isFinished()) {
            return this.attemptToComplete();
        }
        return !this.workForRecoveryManager();
    }

    void resolveBranchStates() {
        for (int i = 0; i < this.m_transaction.numberOfBranches(); ++i) {
            Branch branch = this.m_transaction.getBranch(i);
            if (branch.getXAState().getState() != 0) continue;
            this.resolveState(branch);
        }
    }

    private void resolveState(Branch branch) {
        branch.setStatus(2);
    }

    private XAResource getXAResource(Branch branch) throws TPCException {
        if (branch.xaResource() == null) {
            this.findNewXAResource(branch);
        }
        return branch.xaResource();
    }

    private void findNewXAResource(Branch branch) throws TPCException {
        RMId rmId = branch.getRmId();
        if (rmId == null) {
            return;
        }
        XAResource xa = this.m_recoveryManager.acquireXAResource(rmId, true);
        branch.setXaResource(xa);
    }

    private boolean ensureXAResourceAvailable(Branch branch) throws TPCException {
        XAResource xa = branch.xaResource();
        RMId rmId = branch.getRmId();
        if (!branch.getXAState().is(480)) {
            this.getXAResource(branch);
        }
        boolean result = xa == null && branch.xaResource() != null || xa != null && !xa.equals(branch.xaResource()) || rmId == null && branch.getRmId() != null || rmId != null && !rmId.equals(branch.getRmId());
        return result;
    }

    boolean fillInMissingXAResources() throws TPCException {
        GlobalTransaction t = this.getGlobalTransaction();
        boolean changed = false;
        for (int xBranch = 0; xBranch < t.numberOfBranches(); ++xBranch) {
            Branch branch = t.getBranch(xBranch);
            boolean bChanged = this.ensureXAResourceAvailable(branch);
            changed = changed || bChanged;
        }
        return changed;
    }

    private boolean attemptToComplete() {
        boolean completed = false;
        Coordinator coordinator = new Coordinator(this.getGlobalTransaction(), this.m_recoveryManager);
        coordinator.setRecovering();
        try {
            coordinator.resolve();
            completed = true;
        }
        catch (RollbackException e) {
            completed = true;
        }
        catch (HeuristicMixedException e) {
            completed = true;
        }
        catch (HeuristicRollbackException e) {
            completed = true;
            this.forgetHeuristicCompletion(coordinator);
        }
        catch (HeuristicCommitException e) {
            completed = true;
            this.forgetHeuristicCompletion(coordinator);
        }
        catch (SystemException e) {
            completed = !this.workForRecoveryManager();
        }
        return completed;
    }

    private void forgetHeuristicCompletion(Coordinator coordinator) {
        try {
            coordinator.forget();
        }
        catch (SystemException e1) {
            TransactionMessages.finer("SystemException while forgetting heuristic completed transaction");
        }
    }

    boolean workForRecoveryManager() {
        GlobalTransaction t = this.getGlobalTransaction();
        boolean found = false;
        for (int xBranch = 0; xBranch < t.numberOfBranches() && !found; ++xBranch) {
            Branch branch = t.getBranch(xBranch);
            boolean completed = branch.getXAState().is(480);
            boolean xaPresent = branch.xaResource() != null;
            found = !completed && !xaPresent;
        }
        return found;
    }
}

