/*
 * Decompiled with CFR 0.152.
 */
package oracle.as.j2ee.transaction.tpc;

import java.io.Serializable;
import java.util.Arrays;
import javax.transaction.xa.Xid;

public class NormalXid
implements Xid,
Serializable {
    private int m_hashcode;
    private int m_formatId;
    private byte[] m_transactionId;
    private byte[] m_branchId;
    private String m_toStringValue;

    public NormalXid(byte[] transactionId, int formatId, byte[] branchId) {
        this.m_transactionId = transactionId;
        this.m_formatId = formatId;
        this.m_branchId = branchId != null ? branchId : new byte[0];
        this.createHash();
    }

    public NormalXid(byte[] transactionId, int formatId) {
        this.m_transactionId = transactionId;
        this.m_formatId = formatId;
        this.m_branchId = new byte[0];
        this.createHash();
    }

    public NormalXid(Xid xid) {
        this(xid.getGlobalTransactionId(), xid.getFormatId(), xid.getBranchQualifier());
    }

    public int getFormatId() {
        return this.m_formatId;
    }

    public byte[] getGlobalTransactionId() {
        return this.m_transactionId;
    }

    public byte[] getBranchQualifier() {
        return this.m_branchId;
    }

    private static String toHexString(byte[] bytes) {
        StringBuffer buf = new StringBuffer();
        for (int x = 0; x < bytes.length; ++x) {
            int i;
            if (x > 0) {
                buf.append(".");
            }
            if ((i = bytes[x] & 0xFF) == 0) {
                buf.append("00");
                continue;
            }
            if (i <= 15) {
                buf.append('0').append(Integer.toString(i, 16));
                continue;
            }
            buf.append(Integer.toString(i, 16));
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        NormalXid normalXid = this;
        synchronized (normalXid) {
            if (this.m_toStringValue != null) {
                return this.m_toStringValue;
            }
            this.m_toStringValue = NormalXid.toString(this.m_formatId, this.m_transactionId, this.m_branchId);
            return this.m_toStringValue;
        }
    }

    public static String toString(Xid xid) {
        return NormalXid.toString(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier());
    }

    public static String toString(int formatId, byte[] txId, byte[] branchQual) {
        StringBuffer buf = new StringBuffer();
        buf.append("Xid( Global Id ").append(NormalXid.toHexString(txId));
        buf.append(", Format Id ").append(formatId);
        if (branchQual != null && branchQual.length != 0) {
            buf.append(", Branch Id ").append(NormalXid.toHexString(branchQual));
        }
        buf.append(")");
        return buf.toString();
    }

    private int hash(byte[] bytes) {
        if (bytes == null) {
            return 0;
        }
        int hash = 1;
        for (int x = 0; x < bytes.length; ++x) {
            hash = 31 * hash + bytes[x];
        }
        return hash;
    }

    private void createHash() {
        this.m_hashcode = this.hash(this.m_transactionId) + this.m_formatId + this.hash(this.m_branchId);
    }

    public int hashCode() {
        return this.m_hashcode;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        return other instanceof Xid && NormalXid.equals(this, (Xid)other);
    }

    public static boolean equals(Xid xid0, Xid xid1) {
        return xid0.getFormatId() == xid1.getFormatId() && Arrays.equals(xid0.getGlobalTransactionId(), xid1.getGlobalTransactionId()) && Arrays.equals(xid0.getBranchQualifier(), xid1.getBranchQualifier());
    }
}

