/*
 * Decompiled with CFR 0.152.
 */
package opmn.jgroups.protocols;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import opmn.jgroups.stack.OPMNGossipClient;
import oracle.ons.Notification;
import oracle.ons.Subscriber;
import oracle.ons.SubscriptionException;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.protocols.PingHeader;
import org.jgroups.protocols.PingRsp;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;

public class OPMNTCPGOSSIP
extends Protocol
implements Runnable {
    private static String ONS_OC4J_COMPONENT_NAME = "IAS/OC4J";
    private static long ONS_SUB_TIMEOUT = 3000L;
    private static long ONS_REC_TIMEOUT = 60000L;
    Vector members = new Vector();
    Vector initial_members = new Vector();
    Address local_addr = null;
    String group_addr = null;
    String groupname = null;
    long timeout = 3000L;
    long num_initial_members = 2L;
    boolean is_server = false;
    private static Map clusterGrpMbrsMap = new HashMap();
    private static long lastGossipQueryTime = System.currentTimeMillis();
    private static final long GOSSIP_CLIENT_QUERY_INTERVAL = 60000L;
    private boolean initQueryDone = false;
    private static Object syncObject = new Object();

    public String getName() {
        return "OPMNTCPGOSSIP";
    }

    public Vector providedUpServices() {
        Vector<Integer> ret = new Vector<Integer>();
        ret.addElement(new Integer(12));
        return ret;
    }

    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("timeout");
        if (str != null) {
            this.timeout = new Long(str);
            props.remove("timeout");
        }
        if (props.size() > 0) {
            System.err.println("OPMNTCPGOSSIP.setProperties(): the following properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    public void init() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Notification in_n;
        Subscriber sub = null;
        String myuid = System.getProperty("oracle.ons.uid");
        if (myuid == null) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)"Merge thread: OPMN UID is not defined.");
            }
            return;
        }
        String Interest = "((\"generatingComponent=IAS/OC4J\")&(\"OPMN_UID=" + myuid + "\")&" + "(\"eventType=IAS/PM/PROC_READY\"))";
        do {
            in_n = null;
            if (sub == null) {
                try {
                    sub = new Subscriber(Interest, ONS_OC4J_COMPONENT_NAME, ONS_SUB_TIMEOUT);
                }
                catch (SubscriptionException e) {
                    sub = null;
                }
            }
            if (sub == null) continue;
            in_n = sub.receive(ONS_REC_TIMEOUT);
        } while (in_n != null && !myuid.equals(in_n.getProperty("OPMN_UID")));
        if (in_n != null && this.group_addr != null) {
            Vector tmp_mbrs;
            Vector coords = null;
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"fetching members from GossipServer(s)");
            }
            if ((tmp_mbrs = this.getInitialMembers(this.group_addr, true)) == null || tmp_mbrs.size() == 0) {
                return;
            }
            this.getMembers(tmp_mbrs);
            Vector vector = this.initial_members;
            synchronized (vector) {
                coords = this.findMultipleCoordinators(this.initial_members);
                if (coords != null && coords.size() > 1) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("found multiple coordinators: " + coords + "; sending up MERGE event"));
                    }
                    Event evt = new Event(14, (Object)coords);
                    this.passUp(evt);
                }
            }
        }
        if (sub != null) {
            sub.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                Header obj = msg.getHeader(this.getName());
                if (obj == null || !(obj instanceof PingHeader)) {
                    this.passUp(evt);
                    return;
                }
                PingHeader hdr = (PingHeader)msg.removeHeader(this.getName());
                switch (hdr.type) {
                    case 1: {
                        Address coord;
                        if (!this.is_server) {
                            return;
                        }
                        Vector vector = this.members;
                        synchronized (vector) {
                            coord = this.members.size() > 0 ? (Address)this.members.firstElement() : this.local_addr;
                        }
                        Message rsp_msg = new Message(msg.getSrc(), null, null);
                        PingHeader rsp_hdr = new PingHeader(2, new PingRsp(this.local_addr, coord, this.is_server));
                        rsp_msg.putHeader(this.getName(), (Header)rsp_hdr);
                        this.passDown(new Event(1, (Object)rsp_msg));
                        return;
                    }
                    case 2: {
                        PingRsp rsp = hdr.arg;
                        Vector vector = this.initial_members;
                        synchronized (vector) {
                            this.initial_members.addElement(rsp);
                            this.initial_members.notify();
                        }
                        return;
                    }
                }
                if (this.log.isWarnEnabled()) {
                    this.log.warn((Object)("got TCPGOSSIP header with unknown type (" + hdr.type + ")"));
                }
                return;
            }
            case 3: {
                break;
            }
            case 8: {
                this.passUp(evt);
                this.local_addr = (Address)evt.getArg();
                break;
            }
            default: {
                this.passUp(evt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getInitialMembers(String groupName, boolean isNotif) {
        boolean needRefresh = false;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Getting initial members for group: " + groupName + " at time: " + System.currentTimeMillis()));
        }
        Map map = clusterGrpMbrsMap;
        synchronized (map) {
            Vector groupMembers = null;
            if (isNotif) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("The notification thread has triggered an OPMN  request for initial members for group: " + groupName));
                }
                needRefresh = true;
            } else if (!this.initQueryDone) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)"OPMN request initiated during stack init.");
                }
                this.initQueryDone = true;
                needRefresh = true;
            } else {
                long currentTime = System.currentTimeMillis();
                long numMSElapsed = currentTime - lastGossipQueryTime;
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)"MERGE2 has initiated an OPMN request.");
                    this.log.trace((Object)("number of ms elapsed since the last OPMN request: " + numMSElapsed));
                }
                if (numMSElapsed >= 60000L) {
                    needRefresh = true;
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)"OPMN will be contacted for cluster membership because 60000ms has been exceeded.");
                    }
                } else if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Cached value of cluster membership will be used for group: " + groupName));
                }
            }
            if (needRefresh) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Making a new request to OPMN for cluster membership  for group: " + groupName + " at time: " + System.currentTimeMillis()));
                }
                clusterGrpMbrsMap.clear();
                OPMNGossipClient.getMembers(clusterGrpMbrsMap);
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Finished new request to OPMN for cluster membership for group: " + groupName + " at time: " + System.currentTimeMillis()));
                }
                lastGossipQueryTime = System.currentTimeMillis();
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("lastGossipQueryTime is updated to: " + lastGossipQueryTime));
                }
            }
            groupMembers = (Vector)clusterGrpMbrsMap.get(groupName);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Printing cluster membership info obtained from OPMN: ");
                if (groupMembers != null) {
                    for (int i = 0; i < groupMembers.size(); ++i) {
                        IpAddress mbr_addr = (IpAddress)groupMembers.elementAt(i);
                        this.log.debug((Object)mbr_addr.toString());
                    }
                }
                this.log.debug((Object)("Returning groupMembers for group: " + groupName + " at time: " + System.currentTimeMillis()));
            }
            return groupMembers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void down(Event evt) {
        switch (evt.getType()) {
            case 12: {
                Vector tmp_mbrs;
                this.initial_members.removeAllElements();
                if (this.group_addr == null) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error((Object)"[FIND_INITIAL_MBRS]: group_addr is null, cannot get mbrship");
                    }
                    this.passUp(new Event(13, (Object)this.initial_members));
                    break;
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)"fetching members from GossipServer(s)");
                }
                if ((tmp_mbrs = this.getInitialMembers(this.group_addr, false)) == null || tmp_mbrs.size() == 0) {
                    if (this.log.isWarnEnabled()) {
                        this.log.warn((Object)"[FIND_INITIAL_MBRS]: gossip client found no members");
                    }
                    Thread merge = new Thread(this);
                    merge.setDaemon(true);
                    merge.start();
                    this.passUp(new Event(13, (Object)this.initial_members));
                    break;
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("consolidated mbrs from GossipServer(s) are " + tmp_mbrs));
                }
                this.getMembers(tmp_mbrs);
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("[FIND_INITIAL_MBRS] initial members are " + this.initial_members));
                }
                this.passUp(new Event(13, (Object)this.initial_members));
                break;
            }
            case 6: 
            case 15: {
                Vector tmp = ((View)evt.getArg()).getMembers();
                if (tmp != null) {
                    Vector vector = this.members;
                    synchronized (vector) {
                        this.members.removeAllElements();
                        for (int i = 0; i < tmp.size(); ++i) {
                            this.members.addElement(tmp.elementAt(i));
                        }
                    }
                }
                this.passDown(evt);
                break;
            }
            case 16: {
                this.passDown(evt);
                this.is_server = true;
                break;
            }
            case 2: {
                this.group_addr = (String)evt.getArg();
                this.passDown(evt);
                break;
            }
            case 4: {
                this.passDown(evt);
                break;
            }
            default: {
                this.passDown(evt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getMembers(Vector members) {
        PingHeader hdr = new PingHeader(1, null);
        Message msg = new Message(null, null, null);
        msg.putHeader(this.getName(), (Header)hdr);
        for (int i = 0; i < members.size(); ++i) {
            IpAddress mbr_addr = (IpAddress)members.elementAt(i);
            Message copy = msg.copy();
            copy.setDest((Address)mbr_addr);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Sending PING request to " + copy.getDest()));
            }
            this.passDown(new Event(1, (Object)copy));
        }
        Vector vector = this.initial_members;
        synchronized (vector) {
            long start_time = System.currentTimeMillis();
            long time_to_wait = this.timeout;
            this.num_initial_members = members.size();
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("num_initial_members value used is " + this.num_initial_members));
            }
            while ((long)this.initial_members.size() < this.num_initial_members && time_to_wait > 0L) {
                try {
                    this.initial_members.wait(time_to_wait);
                }
                catch (Exception e) {
                    // empty catch block
                }
                time_to_wait -= System.currentTimeMillis() - start_time;
            }
        }
    }

    private Vector findMultipleCoordinators(Vector initial_mbrs) {
        Vector<Address> ret = new Vector<Address>(11);
        if (initial_mbrs == null) {
            return null;
        }
        for (int i = 0; i < initial_mbrs.size(); ++i) {
            PingRsp rsp = (PingRsp)initial_mbrs.elementAt(i);
            Address coord = rsp.getCoordAddress();
            if (ret.contains(coord)) continue;
            ret.addElement(coord);
        }
        return ret;
    }
}

