/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import com.sun.enterprise.util.LocalStringManager;
import java.text.MessageFormat;
import java.util.Date;
import java.util.ResourceBundle;

public class LocalStringManagerImpl
implements LocalStringManager {
    private Class defaultClass;

    public LocalStringManagerImpl(Class defaultClass) {
        this.defaultClass = defaultClass;
    }

    public String getLocalString(Class callerClass, String key, String defaultValue) {
        Class stopClass = this.defaultClass.getSuperclass();
        Class startClass = callerClass != null ? callerClass : this.defaultClass;
        ResourceBundle resources = null;
        boolean globalDone = false;
        Class c = startClass;
        while (c != stopClass && c != null) {
            globalDone = c == this.defaultClass;
            try {
                String value;
                StringBuffer resFileName = new StringBuffer(c.getName().substring(0, c.getName().lastIndexOf(".")));
                resFileName.append(".LocalStrings");
                resources = ResourceBundle.getBundle(resFileName.toString());
                if (resources != null && (value = resources.getString(key)) != null) {
                    return value;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            c = c.getSuperclass();
        }
        if (!globalDone) {
            return this.getLocalString(null, key, defaultValue);
        }
        System.err.println("No local string for " + key);
        return defaultValue;
    }

    public String getLocalString(String key, String defaultValue) {
        return this.getLocalString(null, key, defaultValue);
    }

    public String getLocalString(Class callerClass, String key, String defaultFormat, Object[] arguments) {
        MessageFormat f = new MessageFormat(this.getLocalString(callerClass, key, defaultFormat));
        int i = 0;
        while (i < arguments.length) {
            if (arguments[i] == null) {
                arguments[i] = "null";
            } else if (!(arguments[i] instanceof String || arguments[i] instanceof Number || arguments[i] instanceof Date)) {
                arguments[i] = arguments[i].toString();
            }
            ++i;
        }
        return f.format(arguments);
    }

    public String getLocalString(String key, String defaultFormat, Object[] arguments) {
        return this.getLocalString(null, key, defaultFormat, arguments);
    }
}

