/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.sqlgen;

import com.evermind.server.ejb.EJBUtils;
import com.evermind.server.ejb.deployment.ContainerManagedField;
import com.evermind.server.ejb.deployment.EntityBeanDescriptor;
import com.evermind.server.ejb.logging.EJBDeploymentMessages;
import com.evermind.util.EJBProperties;
import com.sun.ejb.PMDeployer;
import com.sun.ejb.PersistenceUtils;
import com.sun.ejb.ejbql.EjbQLDriver;
import com.sun.ejb.ejbql.EjbQLParseException;
import com.sun.ejb.ejbql.EjbQLQuery;
import com.sun.ejb.sqlgen.DBInfo;
import com.sun.ejb.sqlgen.DBMetaData;
import com.sun.ejb.sqlgen.SQLTypeMapper;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.JoinObjectDescriptor;
import com.sun.enterprise.deployment.PersistenceDescriptor;
import com.sun.enterprise.deployment.PersistentFieldInfo;
import com.sun.enterprise.deployment.QueryDescriptor;
import com.sun.enterprise.deployment.RelationRoleDescriptor;
import com.sun.enterprise.deployment.RelationshipDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.resource.ResourcePrincipal;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import javax.ejb.EJBException;
import oracle.oc4j.corba.util.LocalStringManagerImpl;

public final class SQLGenerator {
    private PersistenceDescriptor pers;
    private String tableName;
    private String[] pkeyFieldNames;
    private String[] contMgFieldNames;
    private String[] contMgNoPkeyFieldNames;
    private String whereClause;
    private String createTableQuery;
    private String deleteTableQuery;
    private String loadRowQuery;
    private String storeRowQuery;
    private String createRowQuery;
    private String deleteRowQuery;
    private String findByPrimaryKeyQuery;
    private String findBySourceKeyQuery;
    private String findBySinkKeyQuery;
    private String nonPrimaryKeyFinderQuery;
    private Hashtable findQueryTable = new Hashtable();
    private SQLTypeMapper typeMapper;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(SQLGenerator.class);
    private boolean isMSSqlServer = false;
    private boolean NEED_NON_EJBQL_SQL = false;

    private static boolean alreadyDelimitedByQuotes(String name) {
        return name.indexOf(34) == 0 && name.lastIndexOf(34) == name.length() - 1;
    }

    private static boolean needsQuotes(String name) {
        return !SQLGenerator.alreadyDelimitedByQuotes(name) && (name.indexOf(95) == 0 || name.indexOf(38) > -1 || name.indexOf(37) > -1 || name.indexOf(34) > -1 || name.indexOf(46) > -1);
    }

    public static String surroundWithQuotes(String name) {
        return SQLGenerator.needsQuotes(name) ? "\"" + name + "\"" : name;
    }

    private String truncateAndSurroundWithQuotes(String name, int columnNameMax) {
        if (name == null) {
            return name;
        }
        if (name.length() > columnNameMax) {
            name = name.substring(0, columnNameMax);
        }
        name = SQLGenerator.surroundWithQuotes(name);
        return name;
    }

    private String getColumnName(PersistentFieldInfo pInfo, Map map) {
        Object inhash;
        String dbName = pInfo.name;
        if (pInfo.columnName != null) {
            return pInfo.columnName;
        }
        String pInfoName = pInfo.name;
        if (EJBProperties.getEJBQLDebugSQLGenerator()) {
            System.out.println("-- pInfoName: " + pInfoName);
        }
        if ((inhash = map.get(pInfoName)) != null) {
            ContainerManagedField cmf = (ContainerManagedField)inhash;
            dbName = cmf.getDatabaseName();
            if (EJBProperties.getEJBQLDebugSQLGenerator()) {
                System.out.println("-- dbName: " + dbName);
            }
        }
        return dbName;
    }

    private void updateColumnName(PersistentFieldInfo pInfo, Map map) {
        pInfo.columnName = this.getColumnName(pInfo, map);
    }

    private void mapField(ContainerManagedField f, Map map) {
        Set fSubFields;
        if (f == null) {
            return;
        }
        String fName = f.getCanonicalName();
        if (EJBProperties.getEJBQLDebugSQLGenerator()) {
            System.out.println("-- fName: " + fName);
        }
        if (fName != null) {
            map.put(fName, f);
        }
        if ((fSubFields = f.getPropertyFields()) != null) {
            Iterator i = fSubFields.iterator();
            while (i.hasNext()) {
                Object val = i.next();
                if (!(val instanceof ContainerManagedField)) continue;
                ContainerManagedField subField = (ContainerManagedField)val;
                String subFieldName = subField.getCanonicalName();
                if (EJBProperties.getEJBQLDebugSQLGenerator()) {
                    System.out.println("-- subFieldName: " + subFieldName);
                }
                if (subFieldName == null) continue;
                map.put(subFieldName, subField);
            }
        }
        ContainerManagedField nestedField = f.getEJBReferenceField();
        if (EJBProperties.getEJBQLDebugSQLGenerator()) {
            System.out.println("-- nestedField: " + nestedField);
        }
        this.mapField(nestedField, map);
    }

    private void mapNamesToFields(EntityBeanDescriptor oc4jEntity, Map map) {
        if (oc4jEntity != null) {
            ContainerManagedField pk = oc4jEntity.getPrimaryKey();
            if (EJBProperties.getEJBQLDebugSQLGenerator()) {
                System.out.println("-- pk: " + pk);
            }
            this.mapField(pk, map);
            Iterator iterator = oc4jEntity.getContainerManagedFields().iterator();
            while (iterator.hasNext()) {
                ContainerManagedField field = (ContainerManagedField)iterator.next();
                String name = field.getCanonicalName();
                this.mapField(field, map);
            }
        }
    }

    private SQLGenerator(PersistenceDescriptor pers, String persClassName, SQLTypeMapper typeMapper, DBMetaData metadata) {
        int i;
        EntityBeanDescriptor oc4jEntity;
        this.pers = pers;
        this.typeMapper = typeMapper;
        PersistentFieldInfo[] persFields = pers.getPersistentFieldInfo();
        PersistentFieldInfo[] noPkeyPersFields = pers.getNonPkeyPersFieldInfo();
        PersistentFieldInfo[] pkeyFields = pers.getPkeyFieldInfo();
        int tableNameMax = metadata.maxTableNameLength;
        int columnNameMax = metadata.maxColumnNameLength;
        if (metadata.dbName.toLowerCase().indexOf("microsoft") != -1) {
            this.isMSSqlServer = true;
        }
        if ((oc4jEntity = pers.getOc4jEntity()) != null) {
            String ejbTableName;
            this.tableName = ejbTableName = oc4jEntity.getTableName();
        }
        if (this.tableName != null) {
            pers.setTableName(this.tableName);
        } else {
            this.tableName = persClassName;
        }
        HashMap map = new HashMap();
        this.mapNamesToFields(oc4jEntity, map);
        String[] colmNames = new String[persFields.length];
        for (i = 0; i < persFields.length; ++i) {
            this.updateColumnName(persFields[i], map);
            colmNames[i] = persFields[i].columnName;
        }
        this.contMgFieldNames = colmNames;
        colmNames = new String[noPkeyPersFields.length];
        for (i = 0; i < noPkeyPersFields.length && noPkeyPersFields[i] != null; ++i) {
            this.updateColumnName(noPkeyPersFields[i], map);
            colmNames[i] = noPkeyPersFields[i].columnName;
        }
        this.contMgNoPkeyFieldNames = colmNames;
        colmNames = new String[pkeyFields.length];
        for (i = 0; i < pkeyFields.length && pkeyFields[i] != null; ++i) {
            this.updateColumnName(pkeyFields[i], map);
            colmNames[i] = pkeyFields[i].columnName;
        }
        this.pkeyFieldNames = colmNames;
        try {
            this.generateWhereClause();
            this.generateCreateTableQuery();
            this.generateDeleteTableQuery();
            this.generateLoadRowQuery();
            this.generateStoreRowQuery();
            this.generateCreateRowQuery();
            this.generateDeleteRowQuery();
            this.generateFindByPrimaryKeyQuery();
            this.generateNonPrimaryKeyFinderQuery();
            if (pers.getParentDescriptor() instanceof JoinObjectDescriptor) {
                this.generateFindBySourceSinkKeyQuery();
            }
        }
        catch (Exception ex) {
            if (EJBProperties.getEJBQLDebugSQLGenerator()) {
                ex.printStackTrace();
            }
            throw new EJBException(ex);
        }
    }

    public static void generateSQL(EjbBundleDescriptor ejbBundle, ResourceReferenceDescriptor rrd, boolean overWrite, DBInfo dbInfo) throws Exception {
        Object[] ejbs = ejbBundle.getEjbs().toArray();
        boolean foundCMPBeans = false;
        for (int i = 0; i < ejbs.length; ++i) {
            if (!(ejbs[i] instanceof EjbCMPEntityDescriptor)) continue;
            foundCMPBeans = true;
            break;
        }
        if (!foundCMPBeans) {
            return;
        }
        DBMetaData metadata = null;
        if (rrd != null) {
            ResourcePrincipal rp = rrd.getResourcePrincipal();
            metadata = dbInfo.getDBMetaData(rrd.getJndiName(), rp.getName(), rp.getPassword());
        } else {
            metadata = dbInfo.getDBMetaData("", "", "");
        }
        SQLTypeMapper sqlt = new SQLTypeMapper();
        sqlt.initializeMapping(metadata);
        for (int i = 0; i < ejbs.length; ++i) {
            if (!(ejbs[i] instanceof EjbCMPEntityDescriptor)) continue;
            EjbCMPEntityDescriptor ent = (EjbCMPEntityDescriptor)ejbs[i];
            if (ent.isEJB20() && ent.getPersistenceDescriptor().getOc4jEntity().hasNonNativeOC4JPM()) break;
            SQLGenerator.generateSQL(ent, overWrite, metadata, sqlt);
        }
        if (EJBProperties.getEJBQLDebugSQLGenerator()) {
            System.out.println("\tIn Generate SQL for " + ejbBundle.getName() + " with resource " + rrd + " overwriting ? " + overWrite + " with db info " + dbInfo);
        }
        EjbQLDriver ejbqlDriver = new EjbQLDriver(ejbBundle);
        for (int i = 0; i < ejbs.length; ++i) {
            if (!(ejbs[i] instanceof EjbCMPEntityDescriptor)) continue;
            EjbCMPEntityDescriptor ent = (EjbCMPEntityDescriptor)ejbs[i];
            if (ent.isEJB20() && ent.getPersistenceDescriptor().getOc4jEntity().hasNonNativeOC4JPM()) break;
            if (EJBProperties.getEJBQLDebugSQLGenerator()) {
                System.out.println("\tIn Generate SQL for " + ent.getName() + " with resource " + rrd + " overwriting ? " + overWrite + " with db info " + dbInfo);
            }
            SQLGenerator.generateSQLForEjbQLQueries(ent.getPersistenceDescriptor(), ejbqlDriver);
        }
    }

    private static void generateSQL(EjbCMPEntityDescriptor entd, boolean overWrite, DBMetaData metadata, SQLTypeMapper sqlt) throws Exception {
        try {
            PersistenceDescriptor pers = entd.getPersistenceDescriptor();
            String persClassName = entd.getName();
            EjbBundleDescriptor bundleDesc = pers.getEjbBundleDescriptor();
            PersistenceUtils.getPMDeployer(bundleDesc).addForeignKeyFields(pers);
            SQLGenerator sqlgen = new SQLGenerator(pers, persClassName, sqlt, metadata);
            sqlgen.storeIntoDescriptor(overWrite);
            SQLGenerator.generateJoinObjectSQL(pers, sqlt, metadata, overWrite);
            Descriptor desc = pers.getParentDescriptor();
            if (desc instanceof EjbCMPEntityDescriptor) {
                EjbCMPEntityDescriptor cmped = (EjbCMPEntityDescriptor)desc;
            }
        }
        catch (Exception ex) {
            if (EJBProperties.getEJBQLDebugSQLGenerator()) {
                ex.printStackTrace();
            }
            throw ex;
        }
    }

    private static void generateJoinObjectSQL(PersistenceDescriptor pers, SQLTypeMapper sqlt, DBMetaData metadata, boolean overWrite) {
        EjbBundleDescriptor bundleDesc = pers.getEjbBundleDescriptor();
        PMDeployer pmd = PersistenceUtils.getPMDeployer(bundleDesc);
        Vector joinObjs = pmd.addJoinObjectDescriptors(pers);
        for (int i = 0; i < joinObjs.size(); ++i) {
            JoinObjectDescriptor desc = (JoinObjectDescriptor)joinObjs.elementAt(i);
            PersistenceDescriptor joinPers = desc.getPersistenceDescriptor();
            SQLGenerator sqlgen = new SQLGenerator(joinPers, desc.getJoinObjectClass(), sqlt, metadata);
            sqlgen.storeIntoDescriptor(overWrite);
        }
    }

    private void storeIntoDescriptor(boolean overWrite) {
        if (!this.NEED_NON_EJBQL_SQL) {
            return;
        }
        Iterator i = this.pers.getAllSqlStatementedMethods().iterator();
        while (i.hasNext()) {
            String operation = (String)i.next();
            String prevSql = this.pers.getSqlStatementFor(operation);
            if (!overWrite && prevSql != null && !prevSql.equals("")) continue;
            if (operation.equals("createRow")) {
                this.pers.setSqlStatementFor(operation, this.createRowQuery);
                continue;
            }
            if (operation.equals("deleteRow")) {
                this.pers.setSqlStatementFor(operation, this.deleteRowQuery);
                continue;
            }
            if (operation.equals("storeRow")) {
                this.pers.setSqlStatementFor(operation, this.storeRowQuery);
                continue;
            }
            if (operation.equals("loadRow")) {
                this.pers.setSqlStatementFor(operation, this.loadRowQuery);
                continue;
            }
            if (operation.equals("findByPrimaryKey")) {
                this.pers.setSqlStatementFor(operation, this.findByPrimaryKeyQuery);
                continue;
            }
            if (operation.equals("findBySourceKey")) {
                this.pers.setSqlStatementFor(operation, this.findBySourceKeyQuery);
                continue;
            }
            if (operation.equals("findBySinkKey")) {
                this.pers.setSqlStatementFor(operation, this.findBySinkKeyQuery);
                continue;
            }
            if (operation.startsWith("createTable")) {
                this.pers.setSqlStatementFor(operation, this.createTableQuery);
                continue;
            }
            if (!operation.startsWith("deleteTable")) continue;
            this.pers.setSqlStatementFor(operation, this.deleteTableQuery);
        }
        Iterator it = this.pers.getAllPossibleQueriedMethods().iterator();
        while (it.hasNext()) {
            Method method = (Method)it.next();
            QueryDescriptor qd = this.pers.getQueryFor(method);
            if (qd == null) {
                qd = new QueryDescriptor();
                qd.setQueryMethod(method);
                this.pers.setQueryFor(method, qd);
            }
            if (qd.getIsEjbQl() || !overWrite && qd.getSQL() != null && !qd.getSQL().equals("")) continue;
            qd.setSQL(this.nonPrimaryKeyFinderQuery);
        }
        if (EJBProperties.getEJBQLDebugSQLGenerator()) {
            this.printQueries();
        }
    }

    private void printQueries() {
        System.err.println("findByPrimaryKey query: " + this.findByPrimaryKeyQuery);
        System.err.println("loadRowQuery query: " + this.loadRowQuery);
        System.err.println("storeRowQuery query: " + this.storeRowQuery);
        System.err.println("deleteRowQuery query: " + this.deleteRowQuery);
        System.err.println("createRowQuery query: " + this.createRowQuery);
        System.err.println("Table Create query: " + this.createTableQuery);
        System.err.println("Table Remove query: " + this.deleteTableQuery);
        if (this.pers.getParentDescriptor() instanceof JoinObjectDescriptor) {
            System.err.println("findBySourceKey query: " + this.findBySourceKeyQuery);
            System.err.println("findBySinkKey query: " + this.findBySinkKeyQuery);
        }
    }

    private void generateWhereClause() {
        String clause = " WHERE ";
        for (int i = 0; i < this.pkeyFieldNames.length; ++i) {
            if (i > 0) {
                clause = clause + " AND ";
            }
            clause = clause + this.pkeyFieldNames[i] + " = ? ";
        }
        this.whereClause = clause;
    }

    private void generateCreateTableQuery() {
        String query = "CREATE TABLE " + this.tableName + " (";
        for (int i = 0; i < this.contMgFieldNames.length; ++i) {
            int jdbcType;
            if (i > 0) {
                query = query + " , ";
            }
            Class javaObjClass = this.pers.getPersistentFieldInfo()[i].type;
            String sqlType = this.typeMapper.getSQLTypeFor(javaObjClass);
            query = query + this.contMgFieldNames[i] + " " + sqlType;
            if (javaObjClass.isPrimitive()) {
                query = query + " NOT NULL";
                continue;
            }
            if (!this.isMSSqlServer || this.isPkeyField(this.contMgFieldNames[i]) || (jdbcType = this.typeMapper.getJDBCTypeFor(javaObjClass)) == -7) continue;
            query = query + " NULL";
        }
        String constraintName = "\"pk_" + this.tableName + "\"";
        query = query + ", CONSTRAINT " + constraintName + " PRIMARY KEY (";
        for (int i = 0; i < this.pkeyFieldNames.length; ++i) {
            if (i > 0) {
                query = query + " , ";
            }
            query = query + this.pkeyFieldNames[i];
        }
        this.createTableQuery = query = query + ") )";
    }

    private boolean isPkeyField(String fieldname) {
        for (int i = 0; i < this.pkeyFieldNames.length; ++i) {
            if (!this.pkeyFieldNames[i].equals(fieldname)) continue;
            return true;
        }
        return false;
    }

    private void generateDeleteTableQuery() {
        this.deleteTableQuery = "DROP TABLE " + this.tableName;
    }

    private void generateNonPrimaryKeyFinderQuery() {
        this.nonPrimaryKeyFinderQuery = "SELECT ";
        for (int i = 0; i < this.pkeyFieldNames.length; ++i) {
            if (i > 0) {
                this.nonPrimaryKeyFinderQuery = this.nonPrimaryKeyFinderQuery + " , ";
            }
            this.nonPrimaryKeyFinderQuery = this.nonPrimaryKeyFinderQuery + this.pkeyFieldNames[i];
        }
        this.nonPrimaryKeyFinderQuery = this.nonPrimaryKeyFinderQuery + " FROM " + this.tableName;
    }

    private void generateFindByPrimaryKeyQuery() {
        this.findByPrimaryKeyQuery = "SELECT ";
        for (int i = 0; i < this.pkeyFieldNames.length; ++i) {
            if (i > 0) {
                this.findByPrimaryKeyQuery = this.findByPrimaryKeyQuery + " , ";
            }
            this.findByPrimaryKeyQuery = this.findByPrimaryKeyQuery + this.pkeyFieldNames[i];
        }
        this.findByPrimaryKeyQuery = this.findByPrimaryKeyQuery + " FROM " + this.tableName + this.whereClause;
    }

    private void generateFindBySourceSinkKeyQuery() {
        int i;
        JoinObjectDescriptor joinDesc = (JoinObjectDescriptor)this.pers.getParentDescriptor();
        RelationshipDescriptor rd = joinDesc.getRelationshipDesc();
        RelationRoleDescriptor source = rd.getSource();
        RelationRoleDescriptor sink = rd.getSink();
        PersistenceDescriptor sourcePers = source.getPersistenceDescriptor();
        PersistenceDescriptor sinkPers = sink.getPersistenceDescriptor();
        PersistentFieldInfo[] joinFields = this.pers.getPersistentFieldInfo();
        this.findBySourceKeyQuery = "SELECT ";
        this.findBySinkKeyQuery = "SELECT ";
        int sourceCount = 0;
        int sinkCount = 0;
        for (i = 0; i < joinFields.length; ++i) {
            if (joinFields[i].relatedObj == sinkPers) {
                if (sourceCount > 0) {
                    this.findBySourceKeyQuery = this.findBySourceKeyQuery + " , ";
                }
                this.findBySourceKeyQuery = this.findBySourceKeyQuery + joinFields[i].columnName;
                ++sourceCount;
                continue;
            }
            if (sinkCount > 0) {
                this.findBySinkKeyQuery = this.findBySinkKeyQuery + " , ";
            }
            this.findBySinkKeyQuery = this.findBySinkKeyQuery + joinFields[i].columnName;
            ++sinkCount;
        }
        this.findBySourceKeyQuery = this.findBySourceKeyQuery + " FROM " + this.tableName;
        this.findBySinkKeyQuery = this.findBySinkKeyQuery + " FROM " + this.tableName;
        sourceCount = 0;
        sinkCount = 0;
        this.findBySourceKeyQuery = this.findBySourceKeyQuery + " WHERE ";
        this.findBySinkKeyQuery = this.findBySinkKeyQuery + " WHERE ";
        for (i = 0; i < joinFields.length; ++i) {
            if (joinFields[i].relatedObj == sinkPers) {
                if (sinkCount > 0) {
                    this.findBySinkKeyQuery = this.findBySinkKeyQuery + " AND ";
                }
                this.findBySinkKeyQuery = this.findBySinkKeyQuery + joinFields[i].columnName + " = ? ";
                ++sinkCount;
                continue;
            }
            if (sourceCount > 0) {
                this.findBySourceKeyQuery = this.findBySourceKeyQuery + " AND ";
            }
            this.findBySourceKeyQuery = this.findBySourceKeyQuery + joinFields[i].columnName + " = ? ";
            ++sourceCount;
        }
    }

    private void generateLoadRowQuery() {
        this.loadRowQuery = "SELECT ";
        for (int i = 0; i < this.contMgNoPkeyFieldNames.length; ++i) {
            if (i > 0) {
                this.loadRowQuery = this.loadRowQuery + " , ";
            }
            this.loadRowQuery = this.loadRowQuery + this.contMgNoPkeyFieldNames[i];
        }
        if (this.contMgNoPkeyFieldNames.length == 0) {
            this.loadRowQuery = this.loadRowQuery + " * ";
        }
        this.loadRowQuery = this.loadRowQuery + " FROM " + this.tableName + this.whereClause;
    }

    private void generateStoreRowQuery() {
        if (this.contMgNoPkeyFieldNames.length == 0) {
            this.storeRowQuery = " ";
            return;
        }
        this.storeRowQuery = "UPDATE " + this.tableName + " SET ";
        for (int i = 0; i < this.contMgNoPkeyFieldNames.length; ++i) {
            if (i > 0) {
                this.storeRowQuery = this.storeRowQuery + " , ";
            }
            this.storeRowQuery = this.storeRowQuery + this.contMgNoPkeyFieldNames[i] + " = ? ";
        }
        this.storeRowQuery = this.storeRowQuery + this.whereClause;
    }

    private void generateCreateRowQuery() {
        int i;
        String query = "INSERT INTO " + this.tableName + " ( ";
        for (i = 0; i < this.contMgFieldNames.length; ++i) {
            if (i > 0) {
                query = query + " , ";
            }
            query = query + this.contMgFieldNames[i];
        }
        query = query + " ) VALUES ( ";
        for (i = 0; i < this.contMgFieldNames.length; ++i) {
            if (i > 0) {
                query = query + " , ";
            }
            query = query + " ? ";
        }
        this.createRowQuery = query = query + " )";
    }

    private void generateDeleteRowQuery() {
        this.deleteRowQuery = "DELETE FROM " + this.tableName + this.whereClause;
    }

    private static void generateSQLForEjbQLQueries(PersistenceDescriptor pers, EjbQLDriver ejbqlDriver) throws Exception {
        Set allQueriedMethods = pers.getQueriedMethods();
        Iterator iter = allQueriedMethods.iterator();
        while (iter.hasNext()) {
            Method next = (Method)iter.next();
            QueryDescriptor queryDesc = pers.getQueryFor(next);
            if (!queryDesc.getIsEjbQl()) continue;
            if (EJBProperties.getEJBQLDebugSQLGeneratorInOut()) {
                System.out.println("EJBQL = " + queryDesc.getQuery());
            }
            String queryStr = queryDesc.getQuery();
            EjbQLQuery query = null;
            try {
                query = ejbqlDriver.parse(pers, next, queryStr);
            }
            catch (EjbQLParseException e) {
                if (!EJBUtils.isOrionCmpForced()) {
                    throw e;
                }
                EJBDeploymentMessages.warningIgnoringEjbql(queryStr);
                continue;
            }
            String generatedSql = ejbqlDriver.generateSql(query);
            if (EJBProperties.getEJBQLDebugSQLGeneratorInOut()) {
                System.out.println("SQL = " + generatedSql);
            }
            queryDesc.setSQL(generatedSql);
            queryDesc.setEjbQlRuntimeInfo(ejbqlDriver.getRuntimeInfo(query));
        }
    }

    private static Stack chopString(String text, String delimiter, boolean trim) {
        Stack<String> s = new Stack<String>();
        int delimiterIdx = 0;
        while ((delimiterIdx = text.indexOf(delimiter)) > -1) {
            String value = text.substring(0, delimiterIdx);
            if (trim) {
                value = value.trim();
            }
            s.push(value);
            text = text.substring(delimiterIdx + delimiter.length());
        }
        if (trim) {
            text = text.trim();
        }
        s.push(text);
        return s;
    }

    public static boolean isQueryWithObjectToken(String query) {
        return query.indexOf("OBJECT(") > -1;
    }

    public static String addQualifierToList(String selectList, String qualifier) {
        Stack items = SQLGenerator.chopString(selectList, ",", true);
        StringBuffer result = new StringBuffer();
        Enumeration e = items.elements();
        while (e.hasMoreElements()) {
            String item = (String)e.nextElement();
            result.append(qualifier + '.' + item);
            if (!e.hasMoreElements()) continue;
            result.append(", ");
        }
        return result.toString();
    }

    public static String spliceSelectList(String query, String selectList) {
        int tonen_beg_pos = query.indexOf("OBJECT(");
        String result = query.substring(0, tonen_beg_pos);
        query = query.substring(tonen_beg_pos + "OBJECT(".length());
        int tonen_end_pos = query.indexOf(")");
        String alias = query.substring(0, tonen_end_pos);
        query = query.substring(tonen_end_pos + ")".length());
        String qualifiedSelectList = SQLGenerator.addQualifierToList(selectList, alias);
        result = result + qualifiedSelectList + query;
        return result;
    }
}

