/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.persistence;

import com.evermind.util.EJBProperties;
import com.sun.ejb.EJBUtils;
import com.sun.ejb.PMDeployer;
import com.sun.ejb.PersistenceUtils;
import com.sun.ejb.ejbql.EjbQLDriver;
import com.sun.ejb.ejbql.EjbQLQuery;
import com.sun.ejb.ejbql.RuntimeInfoVisitor;
import com.sun.ejb.persistence.ForeignKeyFieldsForRoles;
import com.sun.ejb.persistence.ForeignKeyFieldsForSourceAndSinkRoles;
import com.sun.ejb.persistence.PMDeployerImplGetNames;
import com.sun.ejb.persistence.PMDeployerImplGetNamesFromOc4j;
import com.sun.ejb.persistence.PersistenceManagerImpl;
import com.sun.ejb.sqlgen.DBInfo;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.FieldDescriptor;
import com.sun.enterprise.deployment.JoinObjectDescriptor;
import com.sun.enterprise.deployment.PersistenceDescriptor;
import com.sun.enterprise.deployment.PersistentFieldInfo;
import com.sun.enterprise.deployment.QueryDescriptor;
import com.sun.enterprise.deployment.RelationRoleDescriptor;
import com.sun.enterprise.deployment.RelationshipDescriptor;
import com.sun.enterprise.log.Log;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.ejb.EJBException;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;

public class PMDeployerImpl
implements PMDeployer {
    private EjbBundleDescriptor ebd;
    private ForeignKeyFieldsForRoles roleForeignKeyManager = new ForeignKeyFieldsForSourceAndSinkRoles();
    private static String nameUnknown = "t_______nameUnknown";

    public PMDeployerImpl(EjbBundleDescriptor ebd) {
        this.ebd = ebd;
    }

    public void ejbJarDeployed() {
        try {
            EjbQLDriver ejbqlDriver = null;
            if (this.ebd.getCMPResourceReference() != null) {
                ejbqlDriver = this.createEjbQLDriver();
            }
            HashSet allEjbqlRuntimeInfo = new HashSet();
            HashSet<PersistenceDescriptor> allPersistenceDescs = new HashSet<PersistenceDescriptor>();
            Iterator itr = this.ebd.getEjbs().iterator();
            while (itr.hasNext()) {
                EjbDescriptor ejbd = (EjbDescriptor)itr.next();
                if (!(ejbd instanceof EjbCMPEntityDescriptor)) continue;
                PersistenceDescriptor pers = ((EjbCMPEntityDescriptor)ejbd).getPersistenceDescriptor();
                if (pers.getCreateTableOnDeployment()) {
                    this.createTable(pers);
                }
                this.addForeignKeyFields(pers);
                allPersistenceDescs.add(pers);
            }
            itr = this.ebd.getRelationships().iterator();
            while (itr.hasNext()) {
                RelationshipDescriptor rd = (RelationshipDescriptor)itr.next();
                if (rd.isOneOne()) continue;
                JoinObjectDescriptor joinDesc = rd.getJoinDescriptor();
                PersistenceDescriptor pers = joinDesc.getPersistenceDescriptor();
                if (pers.getCreateTableOnDeployment()) {
                    this.createTable(pers);
                }
                this.addForeignKeyFields(pers);
                allPersistenceDescs.add(pers);
            }
            itr = allPersistenceDescs.iterator();
            while (itr.hasNext()) {
                PersistenceDescriptor pers = (PersistenceDescriptor)itr.next();
                this.populateEjbQlRuntimeInfo(pers, ejbqlDriver, allEjbqlRuntimeInfo);
            }
        }
        catch (Exception ex) {
            EJBUtils.throwEJBException(ex);
        }
    }

    public void ejbJarUnDeployed() {
        block8: {
            try {
                Iterator itr = this.ebd.getEjbs().iterator();
                while (itr.hasNext()) {
                    PersistenceDescriptor pers;
                    EjbDescriptor ejbd = (EjbDescriptor)itr.next();
                    if (!(ejbd instanceof EjbCMPEntityDescriptor) || !(pers = ((EjbCMPEntityDescriptor)ejbd).getPersistenceDescriptor()).getDeleteTableOnUndeployment()) continue;
                    try {
                        this.deleteTable(pers);
                    }
                    catch (SQLException sqlex) {
                        if (!EJBProperties.getEJBQLDebugPMDeployerImpl()) continue;
                        System.out.println("Error deleting " + pers.getSqlStatementFor("deleteTable"));
                        sqlex.printStackTrace();
                    }
                }
                itr = this.ebd.getRelationships().iterator();
                while (itr.hasNext()) {
                    JoinObjectDescriptor joinDesc;
                    PersistenceDescriptor pers;
                    RelationshipDescriptor rd = (RelationshipDescriptor)itr.next();
                    if (rd.isOneOne() || !(pers = (joinDesc = rd.getJoinDescriptor()).getPersistenceDescriptor()).getDeleteTableOnUndeployment()) continue;
                    try {
                        this.deleteTable(pers);
                    }
                    catch (SQLException sqlex) {
                        if (!EJBProperties.getEJBQLDebugPMDeployerImpl()) continue;
                        System.out.println("Error deleting " + pers.getSqlStatementFor("deleteTable"));
                        sqlex.printStackTrace();
                    }
                }
                PersistenceUtils.removePersistenceManager(this.ebd);
                PersistenceUtils.removePMDeployer(this.ebd);
            }
            catch (Exception ex) {
                if (!EJBProperties.getEJBQLDebugPMDeployerImpl()) break block8;
                System.out.println("exception in ejbJarUnDeployed");
                ex.printStackTrace();
            }
        }
    }

    private EjbQLDriver createEjbQLDriver() throws Exception {
        InitialContext context = new InitialContext();
        Object objref = context.lookup("DatabaseInformation");
        DBInfo dbInfo = (DBInfo)PortableRemoteObject.narrow((Object)objref, (Class)DBInfo.class);
        return new EjbQLDriver(this.ebd);
    }

    private void populateEjbQlRuntimeInfo(PersistenceDescriptor pers, EjbQLDriver ejbqlDriver, Set allRuntimeInfo) throws Exception {
        Set allQueriedMethods = pers.getQueriedMethods();
        Iterator iter = allQueriedMethods.iterator();
        while (iter.hasNext()) {
            Method next = (Method)iter.next();
            QueryDescriptor queryDesc = pers.getQueryFor(next);
            if (!queryDesc.getIsEjbQl()) continue;
            String queryStr = queryDesc.getQuery();
            EjbQLQuery query = ejbqlDriver.parse(pers, next, queryStr);
            RuntimeInfoVisitor runtimeInfo = ejbqlDriver.getRuntimeInfo(query);
            allRuntimeInfo.add(runtimeInfo);
            queryDesc.setEjbQlRuntimeInfo(runtimeInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createTable(PersistenceDescriptor pers) throws Exception {
        Connection dbCon;
        block10: {
            String createTableQuery = pers.getSqlStatementFor("createTable");
            if (createTableQuery == null) throw new EJBException("ERROR: SQL statement for creating table is empty. Possible cause: SQL Generator has not been run.");
            if (createTableQuery.equals("")) {
                throw new EJBException("ERROR: SQL statement for creating table is empty. Possible cause: SQL Generator has not been run.");
            }
            dbCon = null;
            Statement stmt = null;
            try {
                try {
                    dbCon = PersistenceManagerImpl.getConnection(pers);
                    stmt = dbCon.createStatement();
                    if (EJBProperties.getEJBQLDebugPMDeployerImpl()) {
                        System.err.println("CreateTable SQL: " + createTableQuery);
                    }
                    stmt.executeUpdate(createTableQuery);
                }
                catch (SQLException ex) {
                    if (EJBProperties.getEJBQLDebugPMDeployerImpl()) {
                        System.err.println("Error creating table: table may already exist");
                        System.err.println("TableCreate SQL: " + createTableQuery);
                    }
                    Log.err.println(ex);
                    Object var7_6 = null;
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (dbCon == null) return;
                    dbCon.close();
                    return;
                }
                Object var7_5 = null;
                if (stmt == null) break block10;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (stmt != null) {
                    stmt.close();
                }
                if (dbCon == null) throw throwable;
                dbCon.close();
                throw throwable;
            }
            stmt.close();
        }
        if (dbCon == null) return;
        dbCon.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteTable(PersistenceDescriptor pers) throws Exception {
        Connection dbCon;
        block5: {
            String deleteTableQuery = pers.getSqlStatementFor("deleteTable");
            dbCon = null;
            Statement stmt = null;
            try {
                dbCon = PersistenceManagerImpl.getConnection(pers);
                stmt = dbCon.createStatement();
                stmt.executeUpdate(deleteTableQuery);
                Object var6_5 = null;
                if (stmt == null) break block5;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (stmt != null) {
                    stmt.close();
                }
                if (dbCon != null) {
                    dbCon.close();
                }
                throw throwable;
            }
            stmt.close();
        }
        if (dbCon != null) {
            dbCon.close();
        }
    }

    public void addForeignKeyFields(PersistenceDescriptor pers) {
        this.roleForeignKeyManager.addForeignKeyFields(pers);
    }

    private static boolean doesNotNeedJoinObjectDescriptors(RelationshipDescriptor rd) {
        return PMDeployerImpl.implementedUsingForeignKeys(rd);
    }

    private static boolean implementedUsingForeignKeys(RelationshipDescriptor rd) {
        if (rd.isManyMany()) {
            return false;
        }
        if (rd.getSource().getIsMany()) {
            return rd.getSource().needsForeignColumnInOwnerTable();
        }
        if (rd.getSink().getIsMany()) {
            return rd.getSink().needsForeignColumnInOwnerTable();
        }
        return true;
    }

    private boolean awaitsProperTableName(JoinObjectDescriptor jo) {
        return jo.getJoinObjectClass() == nameUnknown;
    }

    private void updateTableName(JoinObjectDescriptor jo, PMDeployerImplGetNames nameGetter) {
        String name = PMDeployerImpl.getTableName(nameGetter, jo.getRelationshipDesc());
        jo.setName(name);
        jo.setJoinObjectClass(name);
        jo.getPersistenceDescriptor().setTableName(name);
    }

    private static String getTableName(PMDeployerImplGetNames nameGetter, RelationshipDescriptor rd) {
        String name = nameUnknown;
        String tableName = nameGetter.getTableName(rd);
        if (tableName != null) {
            if (EJBProperties.getEJBQLDebugPMDeployerImpl()) {
                System.out.println("-- will store tableName: " + tableName);
            }
            name = tableName;
        }
        return name;
    }

    public Vector addJoinObjectDescriptors(PersistenceDescriptor pers) {
        Descriptor owner = pers.getParentDescriptor();
        String packagePrefix = PMDeployerImpl.getPackagePrefix(owner);
        Vector<JoinObjectDescriptor> joinObjDescs = new Vector<JoinObjectDescriptor>();
        EjbBundleDescriptor ebd = pers.getEjbBundleDescriptor();
        PMDeployerImplGetNamesFromOc4j nameGetter = new PMDeployerImplGetNamesFromOc4j(pers);
        Iterator it = pers.getRelationships().iterator();
        while (it.hasNext()) {
            RelationshipDescriptor rd = (RelationshipDescriptor)it.next();
            if (EJBProperties.getEJBQLDebugPMDeployerImpl()) {
                System.out.println("-- will map rd: " + rd);
            }
            String sourceName = rd.getSource().getOwner().getName();
            if (EJBProperties.getEJBQLDebugPMDeployerImpl()) {
                System.out.println("-- sourceName: " + sourceName);
            }
            String sinkName = rd.getSink().getOwner().getName();
            if (EJBProperties.getEJBQLDebugPMDeployerImpl()) {
                System.out.println("-- sinkName: " + sinkName);
            }
            String sourceField = rd.getSource().getCMRField();
            if (EJBProperties.getEJBQLDebugPMDeployerImpl()) {
                System.out.println("-- sourceField: " + sourceField);
            }
            String sinkField = rd.getSink().getCMRField();
            if (EJBProperties.getEJBQLDebugPMDeployerImpl()) {
                System.out.println("-- sinkField: " + sinkField);
            }
            if (EJBProperties.getEJBQLDebugPMDeployerImpl()) {
                System.out.println("-- getJoinDescriptor: " + rd.getJoinDescriptor());
            }
            if (PMDeployerImpl.doesNotNeedJoinObjectDescriptors(rd)) continue;
            JoinObjectDescriptor jo = rd.getJoinDescriptor();
            if (jo != null && !this.awaitsProperTableName(jo)) {
                joinObjDescs.add(rd.getJoinDescriptor());
                continue;
            }
            if (jo == null) {
                jo = this.initJoinObjDesc(null, rd, nameGetter);
            } else {
                this.updateTableName(jo, nameGetter);
            }
            PersistentFieldInfo[] ddpers = jo.getPersistenceDescriptor().getPersistentFieldInfo();
            if (ddpers != null) {
                for (int i = 0; i < ddpers.length; ++i) {
                    String oc4j_col_name;
                    String ddpers_name = ddpers[i].name;
                    ddpers[i].columnName = oc4j_col_name = nameGetter.getTableColumnName(rd, ddpers_name);
                }
            }
            joinObjDescs.add(jo);
            if (!EJBProperties.getEJBQLDebugPMDeployerImpl()) continue;
            System.err.println("-- Added JoinObjectDescriptor " + PMDeployerImpl.getTableName(nameGetter, rd) + " rd = " + rd.hashCode());
        }
        return joinObjDescs;
    }

    private JoinObjectDescriptor initJoinObjDesc(JoinObjectDescriptor dd, RelationshipDescriptor rd, PMDeployerImplGetNames nameGetter) {
        String name = PMDeployerImpl.getTableName(nameGetter, rd);
        dd = this.initJoinObjDesc(dd, rd, name);
        return dd;
    }

    private JoinObjectDescriptor initJoinObjDesc(JoinObjectDescriptor dd, RelationshipDescriptor rd, String name) {
        if (dd == null) {
            dd = new JoinObjectDescriptor(name);
        }
        RelationRoleDescriptor source = rd.getSource();
        RelationRoleDescriptor sink = rd.getSink();
        rd.setJoinDescriptor(dd);
        dd.setRelationshipDesc(rd);
        dd.setName(name);
        EjbBundleDescriptor bd = source.getOwner().getEjbBundleDescriptor();
        dd.setEjbBundleDescriptor(bd);
        PersistenceDescriptor ddPers = new PersistenceDescriptor();
        dd.setPersistenceDescriptor(ddPers);
        ddPers.setTableName(name);
        HashSet<FieldDescriptor> persistentFields = new HashSet<FieldDescriptor>();
        HashSet<FieldDescriptor> pkeyFields = new HashSet<FieldDescriptor>();
        PersistenceDescriptor sourcePers = source.getPersistenceDescriptor();
        PersistentFieldInfo[] sourcePkeyFields = sourcePers.getPkeyFieldInfo();
        for (int i = 0; i < sourcePkeyFields.length; ++i) {
            String joinField = PersistenceDescriptor.makeJoinFieldSource(source, sourcePkeyFields[i], i);
            persistentFields.add(new FieldDescriptor(joinField));
            if (!source.getIsMany()) continue;
            pkeyFields.add(new FieldDescriptor(joinField));
        }
        PersistenceDescriptor sinkPers = sink.getPersistenceDescriptor();
        PersistentFieldInfo[] sinkPkeyFields = sinkPers.getPkeyFieldInfo();
        for (int i = 0; i < sinkPkeyFields.length; ++i) {
            String joinField = PersistenceDescriptor.makeJoinFieldSink(sink, sinkPkeyFields[i], i);
            persistentFields.add(new FieldDescriptor(joinField));
            if (!sink.getIsMany()) continue;
            pkeyFields.add(new FieldDescriptor(joinField));
        }
        ddPers.setCMPFields(persistentFields);
        ddPers.setPkeyFields(pkeyFields);
        return dd;
    }

    public JoinObjectDescriptor createJoinObjDesc(String depName, Descriptor sourceDesc, String sourceField, Descriptor sinkDesc, String sinkField) {
        RelationshipDescriptor relnDesc = null;
        PersistenceDescriptor sourcePers = null;
        if (sourceDesc instanceof JoinObjectDescriptor) {
            sourcePers = ((JoinObjectDescriptor)sourceDesc).getPersistenceDescriptor();
        } else if (sourceDesc instanceof EjbCMPEntityDescriptor) {
            sourcePers = ((EjbCMPEntityDescriptor)sourceDesc).getPersistenceDescriptor();
        }
        Iterator it = sourcePers.getRelationships().iterator();
        while (it.hasNext()) {
            RelationshipDescriptor rd = (RelationshipDescriptor)it.next();
            RelationRoleDescriptor source = rd.getSource();
            RelationRoleDescriptor sink = rd.getSink();
            if ((!source.getOwner().getName().equals(sourceDesc.getName()) || source.getCMRField() == null || !source.getCMRField().equals(sourceField)) && (!sink.getOwner().getName().equals(sourceDesc.getName()) || sink.getCMRField() == null || !sink.getCMRField().equals(sourceField))) continue;
            relnDesc = rd;
            break;
        }
        if (relnDesc == null) {
            throw new RuntimeException("Unable to find RelationshipDescriptor for source=" + sourceDesc.getName() + " field=" + sourceField);
        }
        return this.initJoinObjDesc(new JoinObjectDescriptor(depName), relnDesc, depName);
    }

    static String getPackagePrefix(Descriptor owner) {
        String fullName = owner instanceof EjbCMPEntityDescriptor ? ((EjbCMPEntityDescriptor)owner).getEjbClassName() : ((JoinObjectDescriptor)owner).getJoinObjectClass();
        int lastDotIndex = fullName.lastIndexOf(46);
        String packagePrefix = lastDotIndex != -1 ? fullName.substring(0, lastDotIndex) + "." : "";
        return packagePrefix;
    }
}

