/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.server.ejb.container.codegen;

import com.evermind.server.ejb.PrimitiveTypeCache;
import com.evermind.util.ClassUtils;
import com.evermind.util.CompilerProperties;
import com.oracle.server.ejb.container.codegen.Converter;
import com.oracle.server.ejb.container.codegen.ConverterToBooleanBox;
import com.oracle.server.ejb.container.codegen.ConverterToBox;
import com.oracle.server.ejb.container.codegen.ConverterToPrimitive;
import com.oracle.server.ejb.container.codegen.ConverterToPrimitiveCharacter;
import com.oracle.server.ejb.container.codegen.JasperConstants;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Vector;
import oracle.aurora.ncomp.java.AmbiguousClass;
import oracle.aurora.ncomp.java.Environment;
import oracle.aurora.ncomp.java.FieldDefinition;
import oracle.aurora.ncomp.java.Identifier;
import oracle.aurora.ncomp.java.Imports;
import oracle.aurora.ncomp.javac.ExpressionStack;
import oracle.aurora.ncomp.javac.SourceClass;
import oracle.aurora.ncomp.javac.SourceField;
import oracle.aurora.ncomp.javac.SourcePrintStream;
import oracle.aurora.ncomp.javac.StatementStack;
import oracle.aurora.ncomp.tree.ArrayAccessExpression;
import oracle.aurora.ncomp.tree.AssignExpression;
import oracle.aurora.ncomp.tree.BooleanExpression;
import oracle.aurora.ncomp.tree.CompoundStatement;
import oracle.aurora.ncomp.tree.CompoundStatementSplicer;
import oracle.aurora.ncomp.tree.DeclarationStatement;
import oracle.aurora.ncomp.tree.DoubleExpression;
import oracle.aurora.ncomp.tree.Expression;
import oracle.aurora.ncomp.tree.ExpressionStatement;
import oracle.aurora.ncomp.tree.FloatExpression;
import oracle.aurora.ncomp.tree.IdentifierExpression;
import oracle.aurora.ncomp.tree.IntExpression;
import oracle.aurora.ncomp.tree.MethodExpression;
import oracle.aurora.ncomp.tree.NewArrayExpression;
import oracle.aurora.ncomp.tree.NewInstanceExpression;
import oracle.aurora.ncomp.tree.NullExpression;
import oracle.aurora.ncomp.tree.Statement;
import oracle.aurora.ncomp.tree.StringExpression;
import oracle.aurora.ncomp.tree.Syntax;

public class JasperUtils
implements JasperConstants {
    static Environment env = new Environment();
    static int gensymSuffixCounter = 0;
    public static Statement NO_OP_STATEMENT = new CompoundStatement(0, new StatementStack(0).toArray());
    private static Object[][] CONVERTERS = new Object[][]{{Integer.TYPE, new ConverterToPrimitive("Integer", "intValue")}, {Float.TYPE, new ConverterToPrimitive("Float", "floatValue")}, {Long.TYPE, new ConverterToPrimitive("Long", "longValue")}, {Double.TYPE, new ConverterToPrimitive("Double", "doubleValue")}, {Byte.TYPE, new ConverterToPrimitive("Byte", "byteValue")}, {Short.TYPE, new ConverterToPrimitive("Short", "shortValue")}, {Boolean.TYPE, new ConverterToPrimitive("Boolean", "booleanValue")}, {Character.TYPE, new ConverterToPrimitiveCharacter()}, {java_lang_Integer_CLASS, new ConverterToBox("Integer", "int")}, {java_lang_Float_CLASS, new ConverterToBox("Float", "float")}, {java_lang_Long_CLASS, new ConverterToBox("Long", "long")}, {java_lang_Double_CLASS, new ConverterToBox("Double", "double")}, {java_lang_Byte_CLASS, new ConverterToBox("Byte", "byte")}, {java_lang_Short_CLASS, new ConverterToBox("Short", "short")}, {java_lang_Character_CLASS, new ConverterToBox("Character", "char")}, {java_lang_Boolean_CLASS, new ConverterToBooleanBox()}};

    public static String gensym(String var) {
        return var + gensymSuffixCounter++;
    }

    public static Statement makeStringArrayInit(Identifier varName, String[] values) {
        StatementStack bag = new StatementStack(10);
        bag.push((Statement)new DeclarationStatement(0, 0, (Expression)new ArrayAccessExpression(0, (Expression)new IdentifierExpression(0, Identifier.lookup((String)"String")), null), new ExpressionStack(1).push((Expression)new AssignExpression(0, (Expression)new IdentifierExpression(0, varName), (Expression)new NewArrayExpression(0, (Expression)new IdentifierExpression(0, Identifier.lookup((String)"String")), new ExpressionStack(1).push(Syntax.make((int)values.length)).toArray()))).toArray()));
        for (int i = 0; i < values.length; ++i) {
            bag.push((Statement)new ExpressionStatement(0, (Expression)new AssignExpression(0, (Expression)new ArrayAccessExpression(0, (Expression)new IdentifierExpression(0, varName), Syntax.make((int)i)), Syntax.make((String)values[i]))));
        }
        return new CompoundStatementSplicer(0, bag.toArray());
    }

    public static Statement makeObjectArrayInit(Identifier varName, Identifier[] values, Method method) {
        if (values.length == 0) {
            return new DeclarationStatement(0, 0, (Expression)new ArrayAccessExpression(0, (Expression)new IdentifierExpression(0, Identifier.lookup((String)"Object")), null), new ExpressionStack(1).push((Expression)new AssignExpression(0, (Expression)new IdentifierExpression(0, varName), (Expression)new NullExpression(0))).toArray());
        }
        StatementStack bag = new StatementStack(10);
        bag.push((Statement)new DeclarationStatement(0, 0, (Expression)new ArrayAccessExpression(0, (Expression)new IdentifierExpression(0, Identifier.lookup((String)"Object")), null), new ExpressionStack(1).push((Expression)new AssignExpression(0, (Expression)new IdentifierExpression(0, varName), (Expression)new NewArrayExpression(0, (Expression)new IdentifierExpression(0, Identifier.lookup((String)"Object")), new ExpressionStack(1).push(Syntax.make((int)values.length)).toArray()))).toArray()));
        Class<?>[] classes = method.getParameterTypes();
        for (int i = 0; i < values.length; ++i) {
            Identifier temp;
            if (classes[i].isPrimitive()) {
                String temptemp = PrimitiveTypeCache.convertFromPrimitive(values[i].toString());
                temp = Identifier.lookup((String)temptemp);
            } else {
                temp = values[i];
            }
            bag.push((Statement)new ExpressionStatement(0, (Expression)new AssignExpression(0, (Expression)new ArrayAccessExpression(0, (Expression)new IdentifierExpression(0, varName), Syntax.make((int)i)), (Expression)new IdentifierExpression(0, temp))));
        }
        return new CompoundStatementSplicer(0, bag.toArray());
    }

    public static Identifier makeHomeReference(boolean home) {
        return Identifier.lookup((String)(home ? "this" : "this.getMyHome()"));
    }

    public static SourceField extractFields(SourceClass cl) {
        return (SourceField)cl.detachAllFields();
    }

    public static FieldDefinition appendFields(FieldDefinition head, FieldDefinition tail) {
        if (null == tail) {
            return head;
        }
        if (null == head) {
            return tail;
        }
        FieldDefinition last = head;
        while (null != last.getNextField()) {
            last = last.getNextField();
        }
        while (null != tail) {
            last.setNextField(tail);
            last = tail;
            tail = tail.getNextField();
        }
        return head;
    }

    public static SourceClass addImportsToClass(SourceClass cl, String[] classes, String[] packages) {
        int i;
        Imports imports = cl.getImports();
        if (imports == null) {
            imports = new Imports();
        }
        if (classes != null) {
            for (i = 0; i < classes.length; ++i) {
                try {
                    imports.addClass(Identifier.lookup((String)classes[i]));
                    continue;
                }
                catch (AmbiguousClass ac) {
                    throw new RuntimeException("AmbiguousClass: " + classes[i]);
                }
            }
        }
        if (packages != null) {
            for (i = 0; i < packages.length; ++i) {
                String pkg = packages[i];
                if (pkg.endsWith(".*")) {
                    pkg = pkg.substring(0, pkg.length() - 2);
                }
                imports.addPackage(Identifier.lookup((String)pkg));
            }
        }
        cl.setImports(imports);
        return cl;
    }

    public static String removePackageFromDottedClassName(String fullyQualifiedClassName) {
        int lastDot = fullyQualifiedClassName.indexOf(".");
        if (-1 == lastDot) {
            return fullyQualifiedClassName;
        }
        if (lastDot + 1 >= fullyQualifiedClassName.length()) {
            throw new IllegalArgumentException("Bad class name: " + fullyQualifiedClassName + "; ends in a dot");
        }
        return fullyQualifiedClassName.substring(lastDot + 1, fullyQualifiedClassName.length());
    }

    public static Statement removeExtraBrackets(Statement s) {
        if (s instanceof CompoundStatement) {
            s = new CompoundStatementSplicer(0, ((CompoundStatement)s).getStatements());
        }
        return s;
    }

    public static String makeMethodSignatureString(String prefix, Method method) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(null == prefix ? method.getName() : JasperUtils.addMethodPrefix(prefix, method.getName()));
        buffer.append("(");
        Class<?>[] arguments = method.getParameterTypes();
        for (int i = 0; i < arguments.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(JasperUtils.getSourceTypeString(arguments[i]));
        }
        buffer.append(")");
        return buffer.toString();
    }

    public static String addMethodPrefix(String prefix, String method) {
        return prefix + Character.toUpperCase(method.charAt(0)) + method.substring(1);
    }

    public static String getJVMTypeString(Class c) {
        return JasperUtils.getJVMTypeString(c.getName());
    }

    public static String getJVMTypeString(String cn) {
        StringBuffer out = new StringBuffer();
        ClassUtils.appendCodedNotation(out, cn);
        return out.toString().replace('$', '.');
    }

    public static String getSourceTypeString(Class c) {
        return JasperUtils.getSourceTypeString(c.getName());
    }

    public static String getSourceTypeString(String cn) {
        return ClassUtils.getSourceNotation(cn, 0, true);
    }

    public static boolean isPrimitiveOrBoxed(Class type) {
        return ClassUtils.getPrimitiveType(type).isPrimitive();
    }

    public static String getPrimitiveOrBoxedName(Class type) {
        if (type.isPrimitive()) {
            return ClassUtils.getPrimitiveTypeName(type);
        }
        return JasperUtils.getSourceTypeString(type) + ".class";
    }

    public static Expression getDefaultValueExpression(Class type) {
        if (type.isPrimitive() && !type.isArray()) {
            if (type == Boolean.TYPE) {
                return new BooleanExpression(0, false);
            }
            if (type == Float.TYPE) {
                return new FloatExpression(0, 0.0f);
            }
            if (type == Double.TYPE) {
                return new DoubleExpression(0, 0.0);
            }
            return new IntExpression(0);
        }
        return new NullExpression(0);
    }

    public static Expression maybeBoxValue(Class type, Identifier var) {
        if (!type.isPrimitive()) {
            return new IdentifierExpression(0, var);
        }
        return new NewInstanceExpression(0, (Expression)new IdentifierExpression(0, Identifier.lookup((String)ClassUtils.getNonPrimitiveType(type).getName())), new ExpressionStack(1).push((Expression)new IdentifierExpression(0, var)).toArray());
    }

    public static Expression makeConversionExpression(String v, Class toType, Class fromType) {
        if (toType == fromType || toType.isAssignableFrom(fromType)) {
            return new IdentifierExpression(0, Identifier.lookup((String)v));
        }
        for (int i = 0; i < CONVERTERS.length; ++i) {
            if (CONVERTERS[i][0] != toType) continue;
            return ((Converter)CONVERTERS[i][1]).convert(v, fromType);
        }
        throw new IllegalArgumentException("Cannot convert from " + fromType + " to " + toType);
    }

    public static Statement codeGenDebug(String msg) {
        return !CompilerProperties.getBuildDebug() ? null : new ExpressionStatement(0, (Expression)new MethodExpression(0, (Expression)new StringExpression(0, "CODE GEN COMMENT:"), Identifier.lookup((String)"equals"), new ExpressionStack(1).push(Syntax.make((String)msg)).toArray()));
    }

    public static Statement codeGenDebugSection(String msg, Statement section) {
        return !CompilerProperties.getBuildDebug() ? section : JasperUtils.removeExtraBrackets((Statement)new CompoundStatement(0, new StatementStack(6).push(JasperUtils.codeGenDebug("START: " + msg)).push((Statement)new ExpressionStatement(0, null)).push(section).push((Statement)new ExpressionStatement(0, null)).push(JasperUtils.codeGenDebug("END: " + msg)).push((Statement)new ExpressionStatement(0, null)).toArray()));
    }

    public static void print(Vector contents, SourcePrintStream sourceprintstream) {
        Enumeration enumeration = contents.elements();
        while (enumeration.hasMoreElements()) {
            Syntax syntax = (Syntax)enumeration.nextElement();
            if (syntax == null) continue;
            syntax.print(sourceprintstream);
        }
    }
}

