/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.corba.ee.impl.orb.config;

import com.oracle.corba.ee.impl.orb.DefaultPoaPolicyCreationStrategyImpl;
import com.oracle.corba.ee.impl.orb.config.ArgumentType;
import com.oracle.corba.ee.impl.orb.config.ORBConfig;
import com.oracle.corba.ee.impl.orb.config.Orb;
import com.oracle.corba.ee.impl.orb.config.SystemPropertyType;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.corba.ORBConfigurationException;
import oracle.oc4j.corba.POAPolicyCreationStrategy;
import org.xml.sax.InputSource;

public class ORBConfigImpl
implements ORBConfig {
    private Orb m_orbConfig = null;
    private Logger m_log = TraceLogger.getLogger(ORBConfigImpl.class);
    private Properties m_sysProps;
    private String[] m_args;

    public ORBConfigImpl() {
    }

    public ORBConfigImpl(InputSource source) throws ORBConfigurationException {
        try {
            JAXBContext jc = JAXBContext.newInstance((String)"com.oracle.corba.ee.impl.orb.config");
            Unmarshaller u = jc.createUnmarshaller();
            this.m_orbConfig = (Orb)u.unmarshal(source);
        }
        catch (JAXBException e) {
            this.m_log.log(Level.SEVERE, "Error unmarshalling ORB configuration file", e);
            throw new ORBConfigurationException(e);
        }
    }

    public Properties getORBProperties() {
        if (this.m_orbConfig != null && this.m_sysProps == null) {
            this.m_sysProps = new Properties();
            SystemPropertyType prop = null;
            List props = this.m_orbConfig.getSystemProperty();
            if (props != null) {
                Iterator itor = props.iterator();
                while (itor.hasNext()) {
                    prop = (SystemPropertyType)itor.next();
                    this.m_sysProps.put(prop.getName(), prop.getValue());
                }
            }
        }
        return this.m_sysProps == null ? new Properties() : this.m_sysProps;
    }

    public String[] getORBArguments() {
        if (this.m_orbConfig != null && this.m_args == null) {
            ArgumentType arg = null;
            List orbArgs = this.m_orbConfig.getArgument();
            if (orbArgs != null) {
                this.m_args = new String[2 * orbArgs.size()];
                Iterator itor = orbArgs.iterator();
                int i = 0;
                while (itor.hasNext()) {
                    arg = (ArgumentType)itor.next();
                    this.m_args[i++] = arg.getName();
                    this.m_args[i++] = arg.getValue();
                }
            }
        }
        return this.m_args;
    }

    public String getORBProviderClass() {
        return this.m_orbConfig != null ? this.m_orbConfig.getOrbProviderClass() : null;
    }

    public POAPolicyCreationStrategy getPOAPolicyCreationStrategy() {
        return new DefaultPoaPolicyCreationStrategyImpl();
    }

    public boolean debug() {
        return Boolean.TRUE.equals(Boolean.valueOf(this.m_sysProps.getProperty("com.oracle.corba.ee.debug")));
    }
}

