/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.corba.ee.impl.orb;

import com.evermind.server.AbstractServerExtensionProvider;
import com.evermind.util.OC4JProperties;
import com.oracle.corba.ee.impl.orb.ORBManagerImpl;
import com.oracle.corba.ee.impl.orb.config.ORBConfig;
import com.oracle.corba.ee.impl.orb.config.ORBConfigImpl;
import com.oracle.corba.ee.impl.orb.config.SunRIORBConfigImpl;
import com.sun.corba.ee.impl.naming.cosnaming.TransientNameService;
import java.io.File;
import java.net.MalformedURLException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import oracle.oc4j.corba.ORBConfigurationException;
import oracle.oc4j.security.CsiV2SupportImpl;
import oracle.oc4j.transport.TransportManager;
import oracle.oc4j.transport.iiop.IiopTransportManager;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.xml.sax.InputSource;

public class ORBServerExtensionProviderImpl
extends AbstractServerExtensionProvider {
    private Logger m_log = Logger.getLogger("oc4j.orb.logger");
    private ORBManagerImpl m_orbManager;
    private boolean m_nameServiceNotInitialized = true;
    private static final String ORB_CONFIG_FILE_PATH_PROP = "config-file-path";

    public void preInitApplicationServer(File configDir, Map sepProperties) throws InstantiationException {
        this.m_orbManager = ORBManagerImpl.getORBManager();
        this.configureOrb(configDir, sepProperties);
        if (this.m_nameServiceNotInitialized) {
            this.configureNameService(configDir);
            this.m_nameServiceNotInitialized = false;
        } else {
            this.m_log.warning("ORB ignoring configuration changes.  Restart OC4J to apply new ORB configuration.");
        }
    }

    protected void configureOrb(File configDir, Map sepProperties) throws InstantiationException {
        if (this.m_orbManager.getORBConfig() != null) {
            return;
        }
        try {
            SunRIORBConfigImpl orbConfig = new SunRIORBConfigImpl(this.createConfigurationFromFile(configDir, sepProperties));
            this.m_orbManager.setORBConfig(orbConfig);
            ((OC4JProperties)System.getProperties()).putAll(orbConfig.getORBProperties());
        }
        catch (ORBConfigurationException e) {
            this.m_log.warning("Unable to configure ORB with configuration from file. Proceeding with default configuration");
            ((OC4JProperties)System.getProperties()).putAll(new SunRIORBConfigImpl(new ORBConfigImpl()).getORBProperties());
        }
    }

    private ORBConfig createConfigurationFromFile(File configDirectory, Map sepProperties) {
        try {
            String validConfigPath = this.getORBConfigurationPath(configDirectory, sepProperties);
            return validConfigPath == null ? new ORBConfigImpl() : new ORBConfigImpl(new InputSource(validConfigPath));
        }
        catch (MalformedURLException e) {
            throw new ORBConfigurationException(e);
        }
    }

    private String getORBConfigurationPath(File configDir, Map sepProperties) throws MalformedURLException {
        String path = (String)sepProperties.get(ORB_CONFIG_FILE_PATH_PROP);
        File configFile = new File(path);
        if (!configFile.exists()) {
            if (configDir != null) {
                configFile = new File(configDir, path);
            }
            if (!configFile.exists()) {
                throw new ORBConfigurationException("Unable to load configuration file " + path);
            }
        }
        return configFile.toURL().toString();
    }

    protected void configureNameService(File configDir) throws InstantiationException {
        try {
            this.startNameService(this.m_orbManager.getORBReference());
            if (configDir != null) {
                ORBConfig iiopConfig = this.m_orbManager.getORBConfig();
                String host = iiopConfig.getORBProperties().getProperty("org.omg.CORBA.ORBInitialHost");
                int port = Integer.parseInt(iiopConfig.getORBProperties().getProperty("org.omg.CORBA.ORBInitialPort"));
                TransportManager.addManager(new IiopTransportManager(host, port));
                CsiV2SupportImpl.enableImplementation();
            }
        }
        catch (ORBConfigurationException e) {
            throw new InstantiationException(e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void startNameService(ORB orb) {
        try {
            try {
                this.initializeRootNamingContext(orb);
            }
            catch (Exception e) {
                e.printStackTrace();
                java.lang.Object var4_3 = null;
                String ORG_OMG_CORBA_PREFIX = "org.omg.CORBA.";
                Properties props = System.getProperties();
                props.remove("org.omg.CORBA.ORBInitialHost");
                props.remove("org.omg.CORBA.ORBInitialPort");
                props.remove("com.sun.CORBA.POA.ORBPersistentServerPort");
                props.remove("org.omg.CORBA.ORBInitRef");
                System.setProperties(props);
                return;
            }
            java.lang.Object var4_2 = null;
            String ORG_OMG_CORBA_PREFIX = "org.omg.CORBA.";
        }
        catch (Throwable throwable) {
            java.lang.Object var4_4 = null;
            String ORG_OMG_CORBA_PREFIX = "org.omg.CORBA.";
            Properties props = System.getProperties();
            props.remove("org.omg.CORBA.ORBInitialHost");
            props.remove("org.omg.CORBA.ORBInitialPort");
            props.remove("com.sun.CORBA.POA.ORBPersistentServerPort");
            props.remove("org.omg.CORBA.ORBInitRef");
            System.setProperties(props);
            throw throwable;
        }
        Properties props = System.getProperties();
        props.remove("org.omg.CORBA.ORBInitialHost");
        props.remove("org.omg.CORBA.ORBInitialPort");
        props.remove("com.sun.CORBA.POA.ORBPersistentServerPort");
        props.remove("org.omg.CORBA.ORBInitRef");
        System.setProperties(props);
    }

    private Object initializeRootNamingContext(ORB orb) {
        try {
            com.sun.corba.ee.spi.orb.ORB coreORB = (com.sun.corba.ee.spi.orb.ORB)orb;
            TransientNameService tns = new TransientNameService(coreORB);
            return tns.initialNamingContext();
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

