/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bricks.j2ee;

import com.oracle.bricks.Replica;
import com.oracle.bricks.j2ee.AckEJBSessionReplica;
import com.oracle.bricks.j2ee.AckLiveSession;
import com.oracle.bricks.j2ee.EJBLiveSession;
import com.oracle.bricks.j2ee.EJBSessionReplica;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.clustering.ClusteringTraceLogger;
import org.jgroups.Address;
import org.jgroups.util.Promise;

public class AckEJBLiveSession
extends EJBLiveSession {
    protected AckLiveSession.AckObject m_ackObject;
    private static Logger m_logger = ClusteringTraceLogger.getEJBTraceLogger(AckEJBLiveSession.class);

    public AckEJBLiveSession(long id, long creationTime, long ackTimeout) {
        this(new Long(id), creationTime, ackTimeout);
    }

    public AckEJBLiveSession(Serializable id, long creationTime, long ackTimeout) {
        super(id, creationTime);
        this.m_ackObject = new AckLiveSession.AckObject(ackTimeout);
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, "creating AckEJBLiveSession with args");
        }
    }

    protected AckEJBLiveSession(AckEJBSessionReplica replica, long timeout) {
        super(replica);
        this.m_ackObject = new AckLiveSession.AckObject(timeout);
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, "Reifying AckEJBLiveSessio");
        }
    }

    protected Replica getReplica(Address address) throws Exception {
        return new AckEJBSessionReplica(this);
    }

    protected long getAcknowledgementTimeout() {
        return this.m_ackObject.getTimeout();
    }

    protected EJBSessionReplica.BroadcastState createBroadcastState() {
        return new AckEJBSessionReplica.BroadcastStateWithAck(this, this.m_ackObject.getNextAckSeqNo(), this.getOwner());
    }

    protected Replica.Message createApplyDeltaMessage(Serializable id, String name, Serializable value) {
        return new AckEJBSessionReplica.ApplyDeltaWithAck(id, name, value, this.m_ackObject.getNextAckSeqNo(), this.getOwner());
    }

    protected final void send(Replica.Message message) throws InterruptedException {
        int seqNo = ((AckEJBSessionReplica.AckSeqNo)((Object)message)).getAckSeqNo();
        Integer currentAckSeqNo = new Integer(seqNo);
        this.sendRequestWithAck(currentAckSeqNo, message);
    }

    private void sendRequestWithAck(Integer currentAckSeqNo, Replica.Message message) throws InterruptedException {
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, "Sending Ack Request Message: " + message);
        }
        Promise promise = new Promise();
        this.m_ackObject.put(currentAckSeqNo, promise);
        super.send(message);
        Address sender = (Address)promise.getResult(this.m_ackObject.getTimeout());
        if (sender == null) {
            this.m_ackObject.remove(currentAckSeqNo);
            if (m_logger.isLoggable(Level.FINEST)) {
                m_logger.log(Level.FINEST, "No acknowledgement within timout: " + this.m_ackObject.getTimeout() + " for ackSeqNo: " + currentAckSeqNo);
            }
        } else if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, "Received acknowledgement from peer: " + sender);
        }
    }

    protected void acknowledgeUpdate(int ackSeqNo, Address sender) {
        Promise promise = this.m_ackObject.remove(new Integer(ackSeqNo));
        if (promise != null) {
            promise.setResult((Object)sender);
        }
    }
}

