/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class JavaBeautifier {
    static final int INDENT_STEP = 2;
    int ch;
    int lastCh;
    int indent;
    boolean back;
    boolean needNewLineIndent;
    InputStream reader;
    OutputStream writer;

    public JavaBeautifier(InputStream reader, OutputStream writer) throws IOException {
        this.reader = reader;
        this.writer = writer;
        this.doit();
        writer.flush();
    }

    void processSlashSlashComment() throws IOException {
        while ((this.ch = this.read()) != 10 && this.ch != 13 && this.ch >= 0) {
            this.print(this.ch);
        }
        this.needNewLineIndent = true;
    }

    void processSlashStarComment() throws IOException {
        int prevc = 0;
        while ((this.ch = this.read()) != 47 || prevc != 42) {
            prevc = this.ch;
            this.print(prevc);
        }
        this.print(47);
        this.needNewLineIndent = true;
    }

    void processDelimited(int delimiter) throws IOException {
        this.print(delimiter);
        while ((this.ch = this.read()) != delimiter && this.ch >= 0) {
            this.print(this.ch);
            if (this.ch != 92) continue;
            this.print(this.read());
        }
        if (this.ch >= 0) {
            this.print(delimiter);
        }
    }

    void doit() throws IOException {
        block9: while ((this.ch = this.read()) > 0) {
            switch (this.ch) {
                case 10: {
                    this.needNewLineIndent = true;
                    continue block9;
                }
                case 123: {
                    this.print(this.ch);
                    this.indent += 2;
                    this.needNewLineIndent = true;
                    continue block9;
                }
                case 125: {
                    this.indent -= 2;
                    this.print(this.ch);
                    this.needNewLineIndent = true;
                    continue block9;
                }
                case 59: {
                    this.print(this.ch);
                    this.indentWhenNewLine();
                    continue block9;
                }
                case 34: 
                case 39: {
                    this.processDelimited(this.ch);
                    continue block9;
                }
                case 9: 
                case 32: {
                    this.skipBlanks();
                    if (this.needNewLineIndent) continue block9;
                    this.print(this.ch);
                    continue block9;
                }
                case 47: {
                    this.print(this.ch);
                    this.ch = this.read();
                    this.back = true;
                    if (this.ch == 42) {
                        this.processSlashStarComment();
                        continue block9;
                    }
                    if (this.ch != 47) continue block9;
                    this.processSlashSlashComment();
                    continue block9;
                }
            }
            this.print(this.ch);
        }
    }

    int read() throws IOException {
        if (this.back) {
            this.back = false;
            return this.lastCh;
        }
        this.lastCh = this.reader.read();
        return this.lastCh;
    }

    void skipBlanks() throws IOException {
        int c;
        while ((c = this.read()) == 32 || c == 9 || c == 10) {
        }
        this.back = true;
    }

    void print(int ch) throws IOException {
        if (this.needNewLineIndent) {
            this.needNewLineIndent = false;
            this.skipBlanks();
            this.print(10);
            for (int i = 0; i < this.indent; ++i) {
                this.writer.write(32);
            }
        }
        this.writer.write(ch);
    }

    void indentWhenNewLine() throws IOException {
        int c;
        while ((c = this.read()) == 32 || c == 9 || c == 10) {
            if (c != 10) continue;
            this.needNewLineIndent = true;
        }
        this.back = true;
    }

    public static void main(String[] args) {
        try {
            for (int i = 0; i < args.length; ++i) {
                new JavaBeautifier(new FileInputStream(new File(args[i])), System.out);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

