/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.util;

import com.evermind.io.IOUtils;
import com.evermind.util.ArrayUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;

public class ByteString
implements Serializable,
Comparable,
Cloneable {
    private static final int DEFAULT_SIZE = 100;
    public static final String DEFAULT_ENCODING = "UTF-8";
    public byte[] data;
    public int offset;
    public int length;

    public ByteString() {
        this(100);
    }

    public ByteString(int size) {
        this.data = new byte[size];
    }

    public ByteString(char[] data) {
        this(new String(data));
    }

    public void reset() {
        this.data = null;
        this.offset = 0;
        this.length = 0;
    }

    public ByteString(byte b) {
        this.data = new byte[1];
        this.data[0] = b;
        this.length = 1;
    }

    public byte[] getBytes() {
        if (this.offset == 0 && this.length == this.data.length) {
            return this.data;
        }
        return this.getBytes(false);
    }

    public byte[] getBytes(boolean clone) {
        if (this.offset == 0 && this.length == this.data.length && !clone) {
            return this.data;
        }
        byte[] bytes = new byte[this.length];
        System.arraycopy(this.data, this.offset, bytes, 0, this.length);
        return bytes;
    }

    public ByteString(byte[] data) {
        this.data = data;
        this.length = data.length;
    }

    public ByteString(byte[] data, int offset, int length) {
        if (offset < 0 || length < 0 || offset + length > data.length) {
            if (offset < 0) {
                throw new StringIndexOutOfBoundsException("offset was below zero: " + offset);
            }
            if (length < 0) {
                throw new StringIndexOutOfBoundsException("length was below zero: " + length);
            }
            if (offset + length < 0) {
                throw new StringIndexOutOfBoundsException(String.valueOf(offset + length));
            }
        }
        this.data = data;
        this.offset = offset;
        this.length = length;
    }

    public ByteString(String string) {
        this.data = ByteString.string2byte(string);
        this.length = this.data.length;
    }

    private static final byte[] string2byte(String str) {
        try {
            return str.getBytes(DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("UTF-8 is not supported. " + e.getMessage());
            return str.getBytes();
        }
    }

    public int compareTo(ByteString other) {
        int length = other.length > this.length ? this.length : other.length;
        for (int i = 0; i < length; ++i) {
            if (this.data[this.offset + i] == other.data[other.offset + i]) continue;
            return this.data[this.offset + i] - other.data[other.offset + i];
        }
        if (this.length == other.length) {
            return 0;
        }
        return this.length - other.length;
    }

    public int compareTo(Object object) {
        if (object instanceof ByteString) {
            return this.compareTo((ByteString)object);
        }
        return this.compareTo(new ByteString((String)object));
    }

    public ByteString substring(int index) {
        if (index == 0) {
            return this;
        }
        if (index > this.length) {
            throw new StringIndexOutOfBoundsException();
        }
        return new ByteString(this.data, this.offset + index, this.length - index);
    }

    public ByteString substring(int index, int endIndex) {
        if (index == 0 && endIndex == this.length) {
            return this;
        }
        if (index > this.length || endIndex > this.length || index > endIndex) {
            throw new StringIndexOutOfBoundsException();
        }
        return new ByteString(this.data, this.offset + index, endIndex - index);
    }

    public ByteString concat(ByteString other) {
        byte[] newData = new byte[this.length + other.length];
        System.arraycopy(this.data, this.offset, newData, 0, this.length);
        System.arraycopy(other.data, other.offset, newData, this.length, other.length);
        return new ByteString(newData);
    }

    public boolean equals(String other) {
        byte[] otherData = ByteString.string2byte(other);
        if (otherData.length == this.length) {
            for (int i = 0; i < this.length; ++i) {
                if (this.data[this.offset + i] == otherData[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean equals(Object otherGeneric) {
        if (!(otherGeneric instanceof ByteString)) {
            return false;
        }
        ByteString other = (ByteString)otherGeneric;
        int length = this.length;
        if (length != other.length) {
            return false;
        }
        byte[] data = this.data;
        byte[] otherData = other.data;
        int offset = this.offset;
        int otherOffset = other.offset - offset;
        length += offset;
        for (int i = offset; i < length; ++i) {
            if (data[i] == otherData[otherOffset + i]) continue;
            return false;
        }
        return true;
    }

    public boolean equalsIgnoreCase(Object otherGeneric) {
        if (!(otherGeneric instanceof ByteString)) {
            return false;
        }
        ByteString other = (ByteString)otherGeneric;
        if (this.length != other.length) {
            return false;
        }
        for (int i = 0; i < this.length; ++i) {
            if (this.data[this.offset + i] == other.data[other.offset + i]) continue;
            byte a = this.data[this.offset + i];
            byte b = other.data[other.offset + i];
            if (a >= 65 && a <= 90) {
                a = (byte)(a + 32);
            }
            if (b >= 65 && b <= 90) {
                b = (byte)(b + 32);
            }
            if (a == b) continue;
            return false;
        }
        return true;
    }

    public Object clone() {
        byte[] newData = new byte[this.length];
        System.arraycopy(this.data, this.offset, newData, 0, this.length);
        return new ByteString(newData);
    }

    public ByteString trueClone() {
        ByteString duplicate = new ByteString(this.data.length);
        duplicate.length = this.length;
        System.arraycopy(this.data, 0, duplicate.data, 0, this.data.length);
        duplicate.offset = this.offset;
        return duplicate;
    }

    public int hashCode() {
        int hashCode = 17;
        int offset = this.offset;
        byte[] data = this.data;
        int length = this.length;
        length += offset;
        for (int i = offset; i < length; ++i) {
            hashCode = 37 * hashCode + data[i];
        }
        return hashCode;
    }

    public int indexOf(char c) {
        for (int i = 0; i < this.length; ++i) {
            if ((char)this.data[this.offset + i] != c) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(char c, int startIndex) {
        while (startIndex < this.length) {
            if ((char)this.data[this.offset + startIndex] == c) {
                return startIndex;
            }
            ++startIndex;
        }
        return -1;
    }

    public int lastIndexOf(char c) {
        for (int i = this.length - 1; i >= 0; --i) {
            if ((char)this.data[this.offset + i] != c) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(char c, int startIndex) {
        while (startIndex >= 0) {
            if ((char)this.data[this.offset + startIndex] == c) {
                return startIndex;
            }
            --startIndex;
        }
        return -1;
    }

    public int indexOf(ByteString other) {
        int length = this.length - other.length;
        if (length < 0) {
            return -1;
        }
        if (other.length == 0) {
            return 0;
        }
        byte otherFirst = other.data[other.offset];
        for (int i = 0; i <= length; ++i) {
            if (otherFirst != this.data[this.offset + i]) continue;
            int x = 1;
            while (this.data[this.offset + i + x] == other.data[other.offset + x]) {
                if (++x != other.length) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOf(ByteString other, int startIndex) {
        int length = this.length - other.length;
        if (length < 0) {
            return -1;
        }
        if (other.length == 0) {
            return 0;
        }
        while (startIndex < length) {
            for (int x = 0; x < other.length; ++x) {
                if (this.data[this.offset + startIndex + x] != other.data[other.offset + x]) continue;
                return startIndex;
            }
            ++startIndex;
        }
        return -1;
    }

    public int lastIndexOf(ByteString other) {
        int length = this.length - other.length;
        if (length < 0) {
            return -1;
        }
        if (other.length == 0) {
            return this.length - 1;
        }
        for (int i = length; i >= 0; --i) {
            for (int x = 0; x < other.length; ++x) {
                if (this.data[this.offset + i + x] != other.data[other.offset + x]) continue;
                return i;
            }
        }
        return -1;
    }

    public int lastIndexOf(ByteString other, int startIndex) {
        int length = this.length - other.length;
        if (length < 0) {
            return -1;
        }
        if (other.length == 0) {
            return startIndex;
        }
        while (startIndex >= 0) {
            for (int x = 0; x < other.length; ++x) {
                if (this.data[this.offset + startIndex + x] != other.data[other.offset + x]) continue;
                return startIndex;
            }
            --startIndex;
        }
        return -1;
    }

    public ByteString replace(char c, char newC) {
        if (c == newC) {
            return this;
        }
        int length = this.length;
        byte[] data = this.data;
        byte[] newData = new byte[length];
        int offset = this.offset;
        int i = 0;
        while (i < length) {
            newData[i] = (char)data[offset] == c ? (byte)newC : data[offset];
            ++i;
            ++offset;
        }
        return new ByteString(newData);
    }

    public ByteString replaceInInstance(char c, char newC) {
        if (c == newC) {
            return this;
        }
        int length = this.length;
        int offset = this.offset;
        int i = 0;
        while (i < length) {
            if ((char)this.data[offset] == c) {
                this.data[offset] = (byte)newC;
            }
            ++i;
            ++offset;
        }
        return this;
    }

    public int length() {
        return this.length;
    }

    public ByteString toLowerCase() {
        return ((ByteString)this.clone()).makeLowerCase();
    }

    public ByteString makeLowerCase() {
        int end = this.offset + this.length;
        for (int i = this.offset; i < end; ++i) {
            if (this.data[i] < 65 || this.data[i] > 90) continue;
            int n = i;
            this.data[n] = (byte)(this.data[n] + 32);
        }
        return this;
    }

    public ByteString toUpperCase() {
        return ((ByteString)this.clone()).makeUpperCase();
    }

    public ByteString makeUpperCase() {
        int end = this.offset + this.length;
        for (int i = this.offset; i < end; ++i) {
            if (this.data[i] < 97 || this.data[i] > 122) continue;
            int n = i;
            this.data[n] = (byte)(this.data[n] + -32);
        }
        return this;
    }

    public char charAt(int i) {
        if (i < 0 || i >= this.length) {
            throw new StringIndexOutOfBoundsException(i);
        }
        return (char)((char)this.data[this.offset + i] & 0xFF);
    }

    public boolean startsWith(ByteString other) {
        if (other.length > this.length) {
            return false;
        }
        for (int i = 0; i < other.length; ++i) {
            if (this.data[this.offset + i] == other.data[other.offset + i]) continue;
            return false;
        }
        return true;
    }

    public boolean endsWith(ByteString other) {
        if (other.length > this.length) {
            return false;
        }
        int diff = this.length - other.length + this.offset;
        for (int i = 0; i < other.length; ++i) {
            if (this.data[diff + i] == other.data[other.offset + i]) continue;
            return false;
        }
        return true;
    }

    public ByteString concat(char c) {
        return this.concat(new ByteString(Character.toString(c)));
    }

    public ByteString trim() {
        byte b;
        int length;
        int offset = this.offset;
        for (length = this.length; length > 0 && ((b = this.data[offset]) == 32 || b == 13 || b == 10 || b == 9); --length) {
            ++offset;
        }
        while (length > 0 && ((b = this.data[offset + length - 1]) == 32 || b == 13 || b == 10 || b == 9)) {
            --length;
        }
        if (offset == this.offset && length == this.length) {
            return this;
        }
        return new ByteString(this.data, offset, length);
    }

    public String toString() {
        try {
            return new String(this.data, this.offset, this.length, DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("UTF-8 is not supported " + e.getMessage());
            return new String(this.data, this.offset, this.length);
        }
    }

    public String toString(String encoding) throws UnsupportedEncodingException {
        if (encoding == null) {
            return this.toString();
        }
        return new String(this.data, this.offset, this.length, encoding);
    }

    public int getOffset() {
        return this.offset;
    }

    public int getEnd() {
        return this.offset + this.length;
    }

    public void append(ByteString other) {
        this.assureSize(this.offset + this.length + other.length);
        System.arraycopy(other.data, other.offset, this.data, this.offset + this.length, other.length);
        this.length += other.length;
    }

    public void append(String other) {
        byte[] otherdata = ByteString.string2byte(other);
        this.assureSize(this.offset + this.length + otherdata.length);
        System.arraycopy(otherdata, 0, this.data, this.offset + this.length, otherdata.length);
        this.length += otherdata.length;
    }

    public void append(String other, String charset) {
        if (charset == null) {
            this.append(other);
        } else {
            byte[] data = null;
            try {
                data = other.getBytes(charset);
            }
            catch (UnsupportedEncodingException e) {
                data = ByteString.string2byte(other);
            }
            this.append(new ByteString(data));
        }
    }

    public void append(String other, boolean escapeNonAsciiCharacters) {
        if (escapeNonAsciiCharacters) {
            other = this.escapeNonAsciiCharacters(other);
        }
        this.append(other);
    }

    public String escapeNonAsciiCharacters(String name) {
        StringBuffer dst = new StringBuffer(name.length() * 4);
        block5: for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c < '\u007f') {
                dst.append(c);
                continue;
            }
            String code = Long.toHexString(c);
            switch (code.length()) {
                case 1: {
                    dst.append("\\u000" + code);
                    continue block5;
                }
                case 2: {
                    dst.append("\\u00" + code);
                    continue block5;
                }
                case 3: {
                    dst.append("\\u0" + code);
                    continue block5;
                }
                default: {
                    dst.append("\\u" + code);
                }
            }
        }
        return dst.toString();
    }

    public void append(char[] data, int offset, int length) {
        this.append(new String(data, offset, length));
    }

    public void append(byte[] data, int offset, int length) {
        this.assureSize(this.offset + this.length + length);
        int pos = this.offset + this.length;
        System.arraycopy(data, offset, this.data, pos, length);
        this.length += length;
    }

    public void append(char[] data, int offset, int length, String charset) throws UnsupportedEncodingException {
        if (charset == null) {
            this.append(data, offset, length);
        } else {
            byte[] rawData = new String(data, offset, length).getBytes(charset);
            this.append(new ByteString(rawData));
        }
    }

    public void append(char c) {
        this.append(Character.toString(c));
    }

    public void append(int i) {
        this.assureSize(this.offset + this.length + 20);
        this.length = ArrayUtils.writeInt(this.data, this.offset + this.length, i) - this.offset;
    }

    public void assureSize(int size) {
        while (this.data.length < size) {
            byte[] newData = new byte[(int)((double)(size + 1) * 1.1)];
            System.arraycopy(this.data, this.offset, newData, 0, this.length);
            this.data = newData;
            this.offset = 0;
        }
    }

    public void replace(int pos, int end, ByteString newContent) {
        int diff = newContent.length - (end - pos);
        if (diff > 0) {
            this.assureSize(this.offset + this.length + diff);
        }
        System.arraycopy(this.data, this.offset + end, this.data, this.offset + newContent.length, this.length - end);
        System.arraycopy(newContent.data, newContent.offset, this.data, this.offset + pos, newContent.length);
    }

    public void insert(int pos, ByteString value) {
        this.assureSize(this.offset + this.length + value.length);
        System.arraycopy(this.data, this.offset + pos, this.data, this.offset + pos + value.length, this.length - pos);
        System.arraycopy(value.data, value.offset, this.data, this.offset + pos, value.length);
        this.length += value.length;
    }

    public boolean startsWith(char c) {
        return this.length > 0 && this.data[this.offset] == (byte)c;
    }

    public int getInt() {
        byte b;
        int pos = this.offset;
        int end = this.offset + this.length;
        while (pos < end && ((b = this.data[pos]) == 32 || b == 9 || b == 10 || b == 13)) {
        }
        int value = 0;
        while (pos < end && this.data[pos] >= 48 && this.data[pos] <= 57) {
            value *= 10;
            value += this.data[pos] - 48;
            ++pos;
        }
        return value;
    }

    public void write(OutputStream out) throws IOException {
        IOUtils.writeCompressedInt(out, this.length);
        out.write(this.data, this.offset, this.length);
    }

    public static ByteString read(InputStream in) throws IOException {
        int length = IOUtils.readCompressedInt(in);
        ByteString string = new ByteString(length);
        string.length = length;
        IOUtils.readFully(in, string.data, string.offset, string.length);
        return string;
    }

    public static ByteString read(InputStream in, int maxSize) throws IOException {
        int length = IOUtils.readCompressedInt(in);
        if (length > maxSize) {
            throw new IOException("Buffer size too large, Length = " + length + ", Max Size = " + maxSize);
        }
        ByteString string = new ByteString(length);
        string.length = length;
        IOUtils.readFully(in, string.data, string.offset, string.length);
        return string;
    }
}

