/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.util;

import java.util.Arrays;

public class Base64Utils {
    private static final char[] charTable = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final byte[] byteTable = new byte[256];

    public static char[] getCharTable() {
        return (char[])charTable.clone();
    }

    public static byte[] getByteTable() {
        return (byte[])byteTable.clone();
    }

    public static char getCharacter(int value) {
        return charTable[value];
    }

    public static byte[] decode(char[] ascii) {
        byte[] data = new byte[ascii.length * 3 / 4];
        int dataPos = 0;
        int pos = 0;
        try {
            while (pos < ascii.length) {
                while (byteTable[ascii[pos]] == -1) {
                    ++pos;
                }
                data[dataPos] = (byte)(byteTable[ascii[pos++]] << 2);
                while (byteTable[ascii[pos]] == -1 && ascii[pos] != '=') {
                    ++pos;
                }
                if (ascii[pos] != '=') {
                    int n = dataPos++;
                    data[n] = (byte)(data[n] + (byteTable[ascii[pos]] >> 4));
                    data[dataPos] = (byte)(byteTable[ascii[pos++]] << 4);
                    while (byteTable[ascii[pos]] == -1 && ascii[pos] != '=') {
                        ++pos;
                    }
                    if (ascii[pos] != '=') {
                        int n2 = dataPos++;
                        data[n2] = (byte)(data[n2] + (byteTable[ascii[pos]] >> 2));
                        data[dataPos] = (byte)(byteTable[ascii[pos++]] << 6);
                        while (byteTable[ascii[pos]] == -1 && ascii[pos] != '=') {
                            ++pos;
                        }
                        if (ascii[pos] != '=') {
                            int n3 = dataPos++;
                            data[n3] = (byte)(data[n3] + byteTable[ascii[pos++]]);
                            continue;
                        }
                    }
                }
                break;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Improperly formatted base64 string");
        }
        byte[] returnData = new byte[dataPos];
        System.arraycopy(data, 0, returnData, 0, dataPos);
        return returnData;
    }

    public static char[] encode(byte[] data) {
        return Base64Utils.encode(data, 76);
    }

    public static char[] encode(byte[] data, int lineLimit) {
        int pos;
        char[] ascii = new char[data.length * 2];
        int length = data.length - 2;
        int i = 0;
        int lineChars = 0;
        for (pos = 0; pos < length; pos += 3) {
            if (lineChars == lineLimit) {
                ascii[i++] = 13;
                ascii[i++] = 10;
                lineChars = 0;
            }
            ascii[i] = charTable[((char)data[pos] & 0xFF) >> 2];
            ascii[i + 1] = charTable[(((char)data[pos] & 0xFF) << 4) + (((char)data[pos + 1] & 0xFF) >> 4) & 0x3F];
            ascii[i + 2] = charTable[(((char)data[pos + 1] & 0xFF) << 2) + (((char)data[pos + 2] & 0xFF) >> 6) & 0x3F];
            ascii[i + 3] = charTable[(char)data[pos + 2] & 0xFF & 0x3F];
            lineChars += 4;
            i += 4;
        }
        if (lineChars == lineLimit) {
            ascii[i++] = 13;
            ascii[i++] = 10;
        }
        if (pos == data.length - 1) {
            ascii[i++] = charTable[((char)data[pos] & 0xFF) >> 2];
            ascii[i++] = charTable[((char)data[pos] & 0xFF) << 4 & 0x3F];
            ascii[i++] = 61;
            ascii[i++] = 61;
        } else if (pos == data.length - 2) {
            ascii[i++] = charTable[((char)data[pos] & 0xFF) >> 2];
            ascii[i++] = charTable[(((char)data[pos] & 0xFF) << 4) + (((char)data[pos + 1] & 0xFF) >> 4) & 0x3F];
            ascii[i++] = charTable[((char)data[pos + 1] & 0xFF) << 2 & 0x3F];
            ascii[i++] = 61;
        }
        char[] returnAscii = new char[i];
        System.arraycopy(ascii, 0, returnAscii, 0, i);
        return returnAscii;
    }

    static {
        Arrays.fill(byteTable, (byte)-1);
        for (int i = 0; i < 64; ++i) {
            Base64Utils.byteTable[Base64Utils.charTable[i]] = (byte)i;
        }
    }
}

