/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.util;

import EDU.oswego.cs.dl.util.concurrent.BoundedBuffer;

public abstract class BBPool {
    protected int max;
    protected int min;
    protected long maxWaitMilliSecond = 0L;
    volatile int allocated = 0;
    private BBPoolImpl buffer;
    private static final int UNBOUNDBUFFERSZ = 10000;

    protected void startPool() {
        if (this.skipPooling()) {
            return;
        }
        for (int i = 0; i < this.min; ++i) {
            try {
                this.buffer.offer(this.getContextFromBackend(), this.maxWaitMilliSecond);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public BBPool(int min, int max, long maxWaitMilliSecond, long _poolTimeout) {
        this.maxWaitMilliSecond = maxWaitMilliSecond;
        if (max > 0 && max < min) {
            min = max;
        }
        if (min < 0) {
            min = 0;
        }
        this.max = max;
        this.min = min;
        if (this.isUnboundPooling()) {
            this.buffer = new BBPoolImpl(10000);
        } else if (this.boundPooling()) {
            this.buffer = new BBPoolImpl(max);
        }
    }

    public void destroy() {
        if (this.skipPooling()) {
            return;
        }
        try {
            Object obj;
            while ((obj = this.buffer.poll(1L)) != null) {
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public Object getContext() {
        Object _context = null;
        if (this.skipPooling()) {
            _context = this.getContextFromBackend();
        } else {
            try {
                _context = this.buffer.poll(this.maxWaitMilliSecond);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (_context == null) {
                if (this.boundPooling() && this.allocated > this.max) {
                    throw this.getTimeoutException();
                }
                _context = this.getContextFromBackend();
            }
        }
        this.beforePassToClient(_context);
        ++this.allocated;
        return _context;
    }

    public void releaseContext(Object context, boolean toBeDiscarded) {
        --this.allocated;
        this.afterRecvContextFromClient(context, toBeDiscarded);
        if (this.skipPooling() || toBeDiscarded) {
            this.releaseContextToBackend(context, toBeDiscarded);
            return;
        }
        try {
            this.buffer.offer(context, this.maxWaitMilliSecond);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private boolean skipPooling() {
        return this.max < 0;
    }

    private boolean boundPooling() {
        return this.max > 0;
    }

    private boolean isUnboundPooling() {
        return this.max == 0;
    }

    protected RuntimeException getTimeoutException() {
        return new IllegalStateException("timeout expired waiting for an instance");
    }

    protected abstract Object getContextFromBackend();

    protected abstract void releaseContextToBackend(Object var1, boolean var2);

    protected void beforePassToClient(Object context) {
    }

    protected void afterRecvContextFromClient(Object context, boolean toBeDiscarded) {
    }

    class BBPoolImpl
    extends BoundedBuffer {
        public BBPoolImpl(int max) {
            super(max);
        }
    }
}

