/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.util;

import com.evermind.util.ObjectUtils;

public class ArrayUtils {
    public static boolean compare(byte[] a, int aOffset, int aLength, byte[] b, int bOffset, int bLength) {
        if (aLength != bLength) {
            return false;
        }
        for (int i = 0; i < aLength; ++i) {
            if (a[aOffset + i] == b[bOffset + i]) continue;
            return false;
        }
        return true;
    }

    public static int writeInt(byte[] buffer, int offset, int number) {
        if (number < 10) {
            if (number >= 0) {
                buffer[offset] = (byte)(48 + number);
                return offset + 1;
            }
            if (number > -10) {
                buffer[offset] = 45;
                buffer[offset + 1] = (byte)(48 - number);
                return offset + 2;
            }
        }
        if (number == Integer.MIN_VALUE) {
            byte[] bytes = String.valueOf(Integer.MIN_VALUE).getBytes();
            System.arraycopy(bytes, 0, buffer, offset, bytes.length);
            return offset + bytes.length;
        }
        int magnitude = 0;
        int tempLength = number;
        while ((tempLength /= 10) != 0) {
            ++magnitude;
        }
        int counter = magnitude + 1;
        if (number < 0) {
            number = -number;
            buffer[offset++] = 45;
        }
        do {
            buffer[offset + magnitude] = (byte)(number % 10 + 48);
            number /= 10;
        } while (--magnitude >= 0);
        return offset + counter;
    }

    public static int writeInt(char[] buffer, int offset, int number) {
        if (number < 10) {
            if (number >= 0) {
                buffer[offset] = (char)(48 + number);
                return offset + 1;
            }
            if (number > -10) {
                buffer[offset] = 45;
                buffer[offset + 1] = (char)(48 - number);
                return offset + 2;
            }
        }
        if (number == Integer.MIN_VALUE) {
            char[] chars = String.valueOf(Integer.MIN_VALUE).toCharArray();
            System.arraycopy(chars, 0, buffer, offset, chars.length);
            return offset + chars.length;
        }
        int magnitude = 0;
        int tempLength = number;
        while ((tempLength /= 10) != 0) {
            ++magnitude;
        }
        int counter = magnitude + 1;
        if (number < 0) {
            number = -number;
            buffer[offset++] = 45;
        }
        do {
            buffer[offset + magnitude] = (char)(number % 10 + 48);
            number /= 10;
        } while (--magnitude >= 0);
        return offset + counter;
    }

    public static final void copyArray(char[] origin, int offset, byte[] destination, int destOffset, int length) {
        while (length >= 8) {
            destination[destOffset] = ObjectUtils.toByte(origin[offset]);
            destination[destOffset + 1] = ObjectUtils.toByte(origin[offset + 1]);
            destination[destOffset + 2] = ObjectUtils.toByte(origin[offset + 2]);
            destination[destOffset + 3] = ObjectUtils.toByte(origin[offset + 3]);
            destination[destOffset + 4] = ObjectUtils.toByte(origin[offset + 4]);
            destination[destOffset + 5] = ObjectUtils.toByte(origin[offset + 5]);
            destination[destOffset + 6] = ObjectUtils.toByte(origin[offset + 6]);
            destination[destOffset + 7] = ObjectUtils.toByte(origin[offset + 7]);
            destOffset += 8;
            offset += 8;
            length -= 8;
        }
        while (length > 0) {
            destination[destOffset++] = ObjectUtils.toByte(origin[offset++]);
            --length;
        }
    }

    public static boolean ifMatchEtag(byte[] sourceEtags, int sourceOffset, int sourceLength, byte[] targetEtag, int targetOffset, int targetLength) {
        int _beginIdx;
        int _endIdx = _beginIdx = sourceOffset;
        while (_endIdx <= sourceOffset + sourceLength) {
            if (_endIdx == sourceOffset + sourceLength || sourceEtags[_endIdx] == 44 || sourceEtags[_endIdx] == 32 && _beginIdx != _endIdx) {
                int _length = _endIdx - _beginIdx;
                if (_length > 2 && sourceEtags[_beginIdx] == 87 && sourceEtags[_beginIdx + 1] == 47) {
                    _length -= 2;
                    _beginIdx += 2;
                }
                if (_length == 1 && sourceEtags[_beginIdx] == 42) {
                    return true;
                }
                if (ArrayUtils.compare(sourceEtags, _beginIdx, _length, targetEtag, targetOffset, targetLength)) {
                    return true;
                }
                _endIdx = _beginIdx = _endIdx + 1;
                continue;
            }
            if (sourceEtags[_beginIdx] == 32 && _beginIdx == _endIdx) {
                _endIdx = ++_beginIdx;
                continue;
            }
            ++_endIdx;
        }
        return false;
    }
}

