/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.rmi;

import com.evermind.server.cluster.ServerIdentification;
import com.evermind.server.rmi.RMIClient;
import com.evermind.util.OpmnHelper;
import java.io.IOException;
import java.net.InetAddress;

abstract class RmiServerLookupStrategy {
    RmiServerLookupStrategy() {
    }

    abstract ServerIdentification[] getAvailableServers(RMIClient var1, String var2) throws IOException;

    static RmiServerLookupStrategy createPeerLookupStrategy(String hostName, int port, boolean useSsl) {
        return new PeerLookupStrategy(hostName, port, useSsl);
    }

    static RmiServerLookupStrategy createOpmnLookupStrategy(String hostName, int port, String instanceName, boolean useSsl) {
        return new OpmnLookupStrategy(hostName, port, instanceName, useSsl);
    }

    static RmiServerLookupStrategy createDnsLookupStrategy(InetAddress[] addresses, int port) {
        return new DnsLookupStrategy(addresses, port);
    }

    private static class StandardOpmnServerAccess
    implements OpmnServerAccess {
        private StandardOpmnServerAccess() {
        }

        public ServerIdentification[] getOc4jServers(String opmnHost, int opmnPort, String oc4jInstanceName, String connectionType, String applicationName) {
            return OpmnHelper.getOc4jServers(opmnHost, opmnPort, oc4jInstanceName, connectionType, applicationName);
        }
    }

    static interface OpmnServerAccess {
        public ServerIdentification[] getOc4jServers(String var1, int var2, String var3, String var4, String var5);
    }

    static class OpmnLookupStrategy
    extends RmiServerLookupStrategy {
        private String m_hostName;
        private int m_port;
        private String m_instanceName;
        boolean m_useSsl;
        private final OpmnServerAccess m_opmnServerAccess;
        private static final String SECURE_ORMI_CONNECTION_TYPE = "rmis";
        private static final String ORMI_CONNECTION_TYPE = "rmi";

        OpmnLookupStrategy(String hostName, int port, String instanceName, boolean isSsl) {
            this(hostName, port, instanceName, isSsl, new StandardOpmnServerAccess());
        }

        OpmnLookupStrategy(String hostName, int port, String instanceName, boolean isSsl, OpmnServerAccess opmnAccess) {
            this.m_hostName = hostName;
            this.m_port = port;
            this.m_instanceName = instanceName;
            this.m_useSsl = isSsl;
            this.m_opmnServerAccess = opmnAccess;
        }

        ServerIdentification[] getAvailableServers(RMIClient rmiClient, String applicationName) throws IOException {
            String connectionType = this.m_useSsl ? SECURE_ORMI_CONNECTION_TYPE : ORMI_CONNECTION_TYPE;
            return this.m_opmnServerAccess.getOc4jServers(this.m_hostName, this.m_port, this.m_instanceName, connectionType, applicationName);
        }

        public boolean equals(Object obj) {
            if (!this.getClass().equals(obj.getClass())) {
                return false;
            }
            OpmnLookupStrategy other = (OpmnLookupStrategy)obj;
            return this.m_hostName.equals(other.m_hostName) && this.m_port == other.m_port && this.m_instanceName.equals(other.m_instanceName) && this.m_useSsl == other.m_useSsl;
        }

        public int hashCode() {
            return this.m_port + 256 * this.m_hostName.hashCode() + this.m_instanceName.hashCode();
        }

        public String toString() {
            return "OpmnLookupStrategy[ host='" + this.m_hostName + "', port=" + this.m_port + "instance='" + this.m_instanceName + "'" + (this.m_useSsl ? ", secure" : "") + "]";
        }
    }

    static class DnsLookupStrategy
    extends RmiServerLookupStrategy {
        private InetAddress[] m_addresses;
        private int m_port;

        public DnsLookupStrategy(InetAddress[] addresses, int port) {
            this.m_addresses = addresses;
            this.m_port = port;
        }

        ServerIdentification[] getAvailableServers(RMIClient rmiClient, String applicationName) throws IOException {
            ServerIdentification[] result = new ServerIdentification[this.m_addresses.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = new ServerIdentification(this.m_addresses[i].getHostAddress(), this.m_port);
            }
            return result;
        }
    }

    static class PeerLookupStrategy
    extends RmiServerLookupStrategy {
        private String m_hostName;
        private int m_port;
        private boolean m_useSsl;

        PeerLookupStrategy(String hostName, int port, boolean useSsl) {
            this.m_hostName = hostName;
            this.m_port = port;
            this.m_useSsl = useSsl;
        }

        ServerIdentification[] getAvailableServers(RMIClient rmiClient, String applicationName) throws IOException {
            return rmiClient.getServers(this.m_hostName, this.m_port, this.m_useSsl, applicationName);
        }

        public boolean equals(Object obj) {
            if (!this.getClass().equals(obj.getClass())) {
                return false;
            }
            PeerLookupStrategy other = (PeerLookupStrategy)obj;
            return this.m_hostName.equals(other.m_hostName) && this.m_port == other.m_port && this.m_useSsl == other.m_useSsl;
        }

        public int hashCode() {
            return this.m_port + 256 * this.m_hostName.hashCode();
        }

        public String toString() {
            return "PeerLookupStrategy[ host='" + this.m_hostName + "', port=" + this.m_port + (this.m_useSsl ? ", secure" : "") + " ]";
        }
    }
}

