/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.rmi;

import com.evermind.server.rmi.RMICall;
import com.evermind.server.rmi.RMIConnectionException;
import java.io.IOException;

class RmiCallQueue {
    private Object queueLock = new Object();
    private int callQueueLength;
    private RMICall[] callQueue = new RMICall[8];

    RmiCallQueue() {
    }

    boolean isEmpty() {
        return this.callQueueLength == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RMICall createCall(int id) {
        RMICall call;
        Object object = this.queueLock;
        synchronized (object) {
            if (this.callQueueLength >= this.callQueue.length) {
                RMICall[] newQueue = new RMICall[this.callQueue.length * 2];
                System.arraycopy(this.callQueue, 0, newQueue, 0, this.callQueue.length);
                this.callQueue = newQueue;
            }
            call = new RMICall(false, id, this.callQueueLength);
            this.callQueue[this.callQueueLength++] = call;
        }
        return call;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RMICall getQueuedClass(int id) throws IOException {
        Object object = this.queueLock;
        synchronized (object) {
            for (int i = 0; i < this.callQueueLength; ++i) {
                if (this.callQueue[i].id != id) continue;
                RMICall call = this.callQueue[i];
                this.callQueue[i] = this.callQueue[--this.callQueueLength];
                return call;
            }
        }
        throw new IOException("No such queue item: " + id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void abortPendingCalls() {
        Object object = this.queueLock;
        synchronized (object) {
            for (int i = 0; i < this.callQueueLength; ++i) {
                RMICall rMICall = this.callQueue[i];
                synchronized (rMICall) {
                    this.callQueue[i].recordClientException(new RMIConnectionException("Failing over.", 1));
                    this.callQueue[i].notify();
                    continue;
                }
            }
            this.callQueue = new RMICall[8];
            this.callQueueLength = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyQueuedThreads(String message) {
        RMIConnectionException clientException = new RMIConnectionException("Disconnected: " + message, 1);
        Object object = this.queueLock;
        synchronized (object) {
            for (int i = 0; i < this.callQueueLength; ++i) {
                RMICall rMICall = this.callQueue[i];
                synchronized (rMICall) {
                    this.callQueue[i].recordClientException(clientException);
                    this.callQueue[i].responded = true;
                    this.callQueue[i].notify();
                    continue;
                }
            }
            this.callQueue = new RMICall[8];
            this.callQueueLength = 0;
        }
    }
}

