/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.rmi;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import com.evermind.io.ClassLoaderObjectInputStream;
import com.evermind.io.IOUtils;
import com.evermind.net.AccessRegionSet;
import com.evermind.net.NetworkConnection;
import com.evermind.net.SocketNetworkConnection;
import com.evermind.server.rmi.Credentials;
import com.evermind.server.rmi.RMIConnection;
import com.evermind.server.rmi.RMIContext;
import com.evermind.server.rmi.RMILoginFailedException;
import com.evermind.server.rmi.RMIServer;
import com.evermind.server.rmi.RMIServerContext;
import com.evermind.server.rmi.RMIServerOutputStream;
import com.evermind.server.rmi.ServerRmiMessageHandler;
import com.evermind.server.rmi.administration.RMIConnectionInfo;
import com.evermind.util.OC4JRuntimeProperties;
import com.evermind.util.ThreadPoolThread;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.rmi.RMIMessages;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.common.CommonThreadState;
import oracle.oc4j.rmi.Authenticatable;
import oracle.oc4j.rmi.RmiCommandSource;
import oracle.oc4j.rmi.RmiTransport;
import oracle.oc4j.rmi.ServerRmiTransport;
import oracle.oc4j.util.ActiveResource;
import oracle.oc4j.util.Closeable;
import oracle.ons.ONS;

public class RMIServerConnection
extends RMIConnection
implements Authenticatable,
Closeable,
ActiveResource {
    private static final Logger m_logger = TraceLogger.getLogger(RMIServerConnection.class);
    private RMIServer m_server;
    private ClassLoader m_overridingLoader;
    private ServerRmiMessageHandler m_handler;
    private ServerRmiTransport m_transport;
    private WeakReference m_memberOfLRUMap;
    private SynchronizedInt activeThreads = new SynchronizedInt(0);

    RMIServerConnection(RMIServer server, NetworkConnection connection) throws IOException {
        super(server);
        this.m_server = server;
        this.setTimeout(server, connection);
        if (this.isServletThread()) {
            this.m_overridingLoader = Thread.currentThread().getContextClassLoader();
        }
        this.m_transport = ServerRmiTransport.createRmiTransport(connection);
        this.m_transport.openConnection(connection, this.getProtocol());
    }

    void setLRUMapMembership(Map memberOf) throws IOException {
        this.m_memberOfLRUMap = new WeakReference<Map>(memberOf);
    }

    boolean isMemberOfLRUMap() {
        return null != this.m_memberOfLRUMap;
    }

    void notifyIsActive() {
        Map lruMap;
        Map map = lruMap = this.isMemberOfLRUMap() ? (Map)this.m_memberOfLRUMap.get() : null;
        if (null != lruMap) {
            lruMap.get(this);
        }
    }

    private boolean isServletThread() {
        return CommonThreadState.getCurrent().isServletRequestThread();
    }

    private void setTimeout(RMIServer server, NetworkConnection connection) throws IOException {
        if (server.getConfig() != null && server.getConfig().getServerConnectionTimeout() > 0) {
            connection.setTimeout(server.getConfig().getServerConnectionTimeout() * 1000);
        }
    }

    public RMIConnectionInfo getConnectionInfo() {
        return this.m_handler.getConnectionInfo(this.m_transport);
    }

    public void authenticateConnection(String domainName, Credentials credentials) throws RMILoginFailedException {
        this.m_handler = ServerRmiMessageHandler.createMessageHandler(this.m_server, domainName, this.getProtocol(), this.m_server.getRequestThreadPool(), null);
        this.m_handler.setOverridingClassLoader(this.m_overridingLoader);
        if (this.isOpmnLocalAdminConnection(credentials.getUsername(), credentials.getPassword())) {
            this.m_handler.setUser(this.m_server.getUserManager().getAdminUser());
        } else {
            this.m_handler.login(credentials);
        }
    }

    void closeContext(RMIContext context, String reason) {
        if (context.equals(this.m_handler.getContext())) {
            this.disconnect(reason, false);
        }
    }

    protected void createMessageHandler() throws InstantiationException {
        this.m_handler = new ServerRmiMessageHandler(this.getProtocol(), this.m_server.getThreadMediator(), (RMIServerContext)this.m_server.getDefaultContext(), null, null, this.getSubjectPropagationAccessRegionSet());
    }

    private AccessRegionSet getSubjectPropagationAccessRegionSet() {
        if (null == this.m_server.getConfig()) {
            return null;
        }
        return this.m_server.getConfig().getSubjectPropagationAccessRegionSet();
    }

    void startConnection() {
        this.m_server.getConnectionThreadPool().launch(this);
    }

    protected boolean mayStartConnectionThread() throws IOException {
        boolean protocolValid = this.makeProtocolChecks();
        if (protocolValid) {
            this.m_server.addHandler(this);
        }
        return protocolValid;
    }

    protected String getConnectionThreadName(Thread thread) {
        return "RMIServerConnectionThread-" + ((ThreadPoolThread)thread).getInternalId();
    }

    protected void initializeConnectionThread() {
    }

    public ServerRmiMessageHandler getHandler() {
        return this.m_handler;
    }

    public void processReceivedCommand(int command, ClassLoaderObjectInputStream in) throws IOException {
        this.notifyIsActive();
        if (this.isCommand(command)) {
            this.handleOrmiCommand(command, in);
        } else {
            this.m_handler.dispatchRequest(in, (RMIServerOutputStream)this.m_transport.getObjectOutputStream(), this, command, this.m_transport.getAddressContainer());
        }
    }

    protected void receiveDomainSetting(String domain) {
        RMIServerContext context = this.m_server.getServerContext(domain, false);
        this.m_handler.setContext(context);
    }

    private boolean makeProtocolChecks() throws IOException, EOFException {
        try {
            if (this.m_transport.getProtocolType(this.getProtocol()) == 228) {
                this.m_server.writePeerServerIdentifications(this.m_transport.getOutputStream(), this.m_transport.getClusteredApplicationName());
                this.disconnect("Done", false);
                return false;
            }
            this.m_transport.acceptClientHandshake(this.getProtocol(), this, this);
            return true;
        }
        catch (RMILoginFailedException e) {
            IOUtils.writeCompressedInt(this.m_transport.getOutputStream(), 11);
            IOUtils.writeUTF(this.m_transport.getOutputStream(), e.getMessage());
            this.m_transport.getOutputStream().flush();
            this.disconnect(e.getMessage(), false);
            return false;
        }
    }

    protected boolean isOpmnLocalAdminConnection(String username, String password) {
        boolean specialConnection = false;
        if (username == null || password == null) {
            return specialConnection;
        }
        boolean localhostIsAdmin = this.m_server.isLocalhostAdmin();
        if (localhostIsAdmin) {
            try {
                String home;
                InetAddress remoteEndOfThisConnection;
                InetAddress thisServer;
                try {
                    SocketNetworkConnection con = (SocketNetworkConnection)this.m_transport.getAddressContainer();
                    thisServer = con.getLocalAddress();
                    remoteEndOfThisConnection = con.getInetAddress();
                }
                catch (ClassCastException e) {
                    remoteEndOfThisConnection = this.m_transport.getAddressContainer().getInetAddress();
                    thisServer = InetAddress.getLocalHost();
                }
                if (thisServer.equals(remoteEndOfThisConnection) && (home = RMIServerConnection.getFormFactorHome()) != null && thisServer.equals(RMIServer.LOCAL_ADDRESS) && username.equals("admin") && password.equals(RMIServerConnection.readFormFactor(home))) {
                    specialConnection = true;
                }
            }
            catch (Exception e) {
                RMIMessages.finerThrowable(e);
            }
        }
        return specialConnection;
    }

    static String getFormFactorHome() {
        String home = OC4JRuntimeProperties.getOracleOc4jLocalhome();
        if (home == null) {
            home = OC4JRuntimeProperties.getOracleOnsOraclehome();
        }
        return home;
    }

    /*
     * WARNING - void declaration
     */
    private static String readFormFactor(String oraclehome) throws IOException {
        try {
            return ONS.readFormFactor((String)oraclehome);
        }
        catch (NoClassDefFoundError err) {
            void var6_10;
            FileInputStream fis;
            String formfactor = null;
            String fname = RMIServerConnection.getFormFactorFileName(oraclehome);
            try {
                fis = new FileInputStream(fname);
            }
            catch (Exception e) {
                throw new IOException("Unable to open formfactor file " + fname);
            }
            try {
                byte[] buffer = new byte[48];
                int len = fis.read(buffer);
                if (len > 0) {
                    formfactor = new String(buffer, 0, len);
                }
                fis.close();
            }
            catch (IOException e) {
                if (e.getMessage().equals("End of stream encountered")) {
                    throw new IOException("No entry found in formfactor file " + fname);
                }
                throw new IOException("I/O error encountered reading formfactor file " + fname);
            }
            finally {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
            if (var6_10 <= 0) {
                throw new IOException("No entry found in formfactor file " + fname);
            }
            return formfactor;
        }
        catch (RuntimeException ex) {
            if (ex.getClass().getName().equals("oracle.ons.ONSException")) {
                throw new IOException("ONS reports: " + ex.getMessage());
            }
            throw ex;
        }
    }

    static String getFormFactorFileName(String oraclehome) {
        String fname = oraclehome + File.separator + "opmn" + File.separator + "conf" + File.separator + ".formfactor";
        return fname;
    }

    protected void resetState(String disconnectMessage) {
        this.m_transport.reclaimResources();
        super.resetState(disconnectMessage);
        if (this.m_handler != null) {
            this.m_handler.reset();
        }
    }

    protected boolean isDisconnectOnInterrupt() {
        return true;
    }

    protected RmiTransport getTransport() {
        return this.m_transport;
    }

    protected RmiCommandSource.MessageIn receiveInputMessage() throws IOException {
        return this.getProtocol().getMessageIn(this, this.getTransport());
    }

    protected void listenForOrmiCommands() {
        super.listenForOrmiCommands();
        this.m_server.removeHandler(this);
    }

    protected void incrementActiveThreadCount() {
        int val = this.activeThreads.increment();
        m_logger.log(Level.FINEST, this + " : activeThreadCount is incremented : " + val);
    }

    protected void decrementActiveThreadCount() {
        int val = this.activeThreads.decrement();
        m_logger.log(Level.FINEST, this + " : activeThreadCount is decremented : " + val);
    }

    public void close() throws IOException {
        this.disconnect("LRU connection", false);
        m_logger.log(Level.FINEST, this + " : RMI connection is forcefully closed by LRU.");
    }

    public boolean isActive() {
        return this.activeThreads.get() > 0;
    }
}

