/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.rmi;

import java.security.BasicPermission;
import java.security.Permission;
import java.util.HashSet;
import java.util.StringTokenizer;

public class RMIPermission
extends BasicPermission {
    private String m_actions;
    private HashSet m_actionSet;
    private boolean m_allActions;

    public RMIPermission(String name) {
        super(name);
        this.init(name, null);
    }

    public RMIPermission(String name, String actions) {
        super(name, actions);
        this.init(name, actions);
    }

    private void init(String name, String actions) {
        if (name == null) {
            throw new NullPointerException("name was null");
        }
        if (null != actions && actions.length() > 0) {
            StringTokenizer t = new StringTokenizer(actions, ", ");
            if (t.hasMoreTokens()) {
                this.m_actions = actions;
                this.m_actionSet = new HashSet();
                while (t.hasMoreTokens()) {
                    this.m_actionSet.add(t.nextToken());
                }
            }
            this.m_allActions = "*".equals(this.m_actions);
        }
    }

    public boolean hasAction(String action) {
        if (this.m_allActions || null == this.m_actionSet) {
            return true;
        }
        if (action.equals(this.m_actions)) {
            return true;
        }
        return this.m_actionSet.contains(action);
    }

    public String getActions() {
        return this.m_actions;
    }

    public boolean implies(Permission permission) {
        if (!super.implies(permission)) {
            return false;
        }
        if (null != permission.getActions()) {
            return this.hasAction(permission.getActions());
        }
        return true;
    }
}

