/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.rmi;

import com.evermind.naming.FlatNameParser;
import com.evermind.naming.MapNamingEnumeration;
import com.evermind.naming.SubContext;
import com.evermind.net.AddressContainer;
import com.evermind.security.User;
import com.evermind.server.rmi.ClusterOnly;
import com.evermind.server.rmi.EvermindRemote;
import com.evermind.server.rmi.RMIBinding;
import com.evermind.server.rmi.RMIClient;
import com.evermind.server.rmi.RMIConnection;
import java.io.IOException;
import java.rmi.AlreadyBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.ContextNotEmptyException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import oracle.j2ee.naming.SecurityContextHelper;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.naming.ContextCredentialProvider;
import oracle.oc4j.naming.EntryAction;

public abstract class RMIContext
implements Context,
ContextCredentialProvider {
    public static final String CONTEXT_STRING = "<context>";
    private static final String LBLProperty = "LoadBalanceOnLookup";
    public static final String LOCAL_PROVIDER_URL_SCHEME = "local://";
    private static boolean GLOBAL_LOOKUP_ENABLED = false;
    protected String domain;
    protected Map environment;
    protected final SecurityContextHelper m_securityContextHelper;
    private RMIClient server;
    private Map bindings = new HashMap();
    private boolean shuffle = false;
    private Hashtable m_bindingEnvironment;
    private static Logger m_logger = TraceLogger.getLogger(RMIContext.class);
    private static List listOfImmutablePropertyNames = new LinkedList();

    public static void setGlobalJNDILookupEnabled(boolean lookupEnabled) {
        GLOBAL_LOOKUP_ENABLED = lookupEnabled;
    }

    public static boolean isGlobalJNDILookupEnabled() {
        return GLOBAL_LOOKUP_ENABLED;
    }

    RMIContext(RMIClient server, String domain, Map environment) {
        this(server, domain, environment, SecurityContextHelper.getInstance());
    }

    RMIContext(RMIClient server, String domain, Map environment, SecurityContextHelper securityContextHelper) {
        listOfImmutablePropertyNames.add("java.naming.security.principal");
        listOfImmutablePropertyNames.add("java.naming.security.credentials");
        if (server == null) {
            throw new IllegalArgumentException("No RMIClient supplied in RMIContext constructor");
        }
        this.m_bindingEnvironment = new Hashtable();
        this.m_bindingEnvironment.put("server", server);
        this.server = server;
        this.domain = domain;
        this.environment = environment;
        this.setNeedToShuffle();
        this.m_securityContextHelper = securityContextHelper;
    }

    public Object lookup(Name name) throws NamingException {
        if (name.size() == 0) {
            return this;
        }
        return this.lookup(name.toString());
    }

    public void bind(String name, Object object) throws NamingException {
        this.bind(name, object, 3);
    }

    public void bind(String name, Object object, int replicate) throws NamingException {
        this.checkServer();
        if (this.hasBinding(name)) {
            throw new NameAlreadyBoundException("Use rebind to override binding of " + name);
        }
        try {
            RMIBinding binding = new RMIBinding(object, replicate);
            this.server.bind(this, name, binding);
            this.putBinding(name, binding);
        }
        catch (AlreadyBoundException e) {
            throw new NameAlreadyBoundException("Use rebind to override");
        }
        catch (RemoteException e) {
            NamingException ne = new NamingException(e.getMessage());
            if (e.detail != null) {
                ne.setRootCause(e.detail);
            }
            throw ne;
        }
    }

    public void bind(Name name, Object obj) throws NamingException {
        this.bind(name.toString(), obj);
    }

    public void rebind(String name, Object object) throws NamingException {
        this.rebind(name, object, 3);
    }

    public void rebind(String name, Object object, int replicate) throws NamingException {
        if (name == null) {
            throw new NullPointerException("name was null");
        }
        this.checkServer();
        m_logger.log(Level.FINE, "Binding {0} to {1}", new Object[]{name, object});
        try {
            RMIBinding binding = new RMIBinding(object, replicate);
            this.server.rebind(this, name, binding);
            this.putBinding(name, binding);
        }
        catch (RemoteException e) {
            NamingException ne = new NamingException(e.getMessage());
            if (e.detail != null) {
                ne.setRootCause(e.detail);
            }
            throw ne;
        }
    }

    public void rebind(Name name, Object object) throws NamingException {
        this.rebind(name.toString(), object);
    }

    public void unbind(String name) throws NamingException {
        this.unbind(name, 3);
    }

    void unbind(String name, int distribution) throws NamingException {
        this.checkServer();
        try {
            this.server.unbind(this, name, distribution);
        }
        catch (IOException e) {
            NamingException ne = new NamingException(e.getMessage());
            ne.setRootCause(e);
            throw ne;
        }
        this.removeBinding(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBinding(String name) {
        Map map = this.bindings;
        synchronized (map) {
            this.bindings.remove(name);
        }
    }

    public void unbind(Name name) throws NamingException {
        this.unbind(name.toString());
    }

    public void rename(String oldname, String newname) throws NamingException {
        this.rename(oldname, newname, false);
    }

    void rename(String oldname, String newname, boolean remoteOnly) throws NamingException {
        this.checkServer();
        this.lookup(oldname);
        try {
            this.lookup(newname);
            throw new NameAlreadyBoundException(newname + " is already bound");
        }
        catch (NameNotFoundException e) {
            RMIBinding binding = (RMIBinding)this.bindings.get(oldname);
            try {
                this.server.rename(this, oldname, newname, binding, remoteOnly);
                this.putBinding(newname, binding);
                this.removeBinding(oldname);
            }
            catch (IOException e2) {
                NamingException ne = new NamingException("Error renaming " + oldname + " to " + newname);
                ne.setRootCause(e2);
                throw ne;
            }
            return;
        }
    }

    protected void checkServer() throws NamingException {
        if (this.server == null) {
            throw new NamingException("Context is closed");
        }
    }

    public void rename(Name oldname, Name newname) throws NamingException {
        this.rename(oldname.toString(), newname.toString());
    }

    public NamingEnumeration list(String name) throws NamingException {
        this.checkServer();
        try {
            Map values = this.getListValues(name, null, false);
            Iterator iterator = values.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!CONTEXT_STRING.equals(entry.getValue())) continue;
                entry.setValue("javax.naming.Context");
            }
            return new MapNamingEnumeration(values, false);
        }
        catch (IOException e) {
            NamingException ne = new NamingException(e.getMessage());
            ne.setRootCause(e);
            throw ne;
        }
    }

    protected final int attributesHash() {
        return this.getHashCode(this.domain) + this.getHashCode(this.environment.get("java.naming.security.principal")) + this.getHashCode(this.environment.get("java.naming.provider.url"));
    }

    private int getHashCode(Object object) {
        return object == null ? 0 : object.hashCode();
    }

    protected final boolean equalAttributes(RMIContext other) {
        return this.server == other.server && this.isEqual(this.domain, other.domain) && this.isEqual(this.environment.get("java.naming.provider.url"), other.environment.get("java.naming.provider.url")) && this.isEqual(this.environment.get("java.naming.security.principal"), other.environment.get("java.naming.security.principal"));
    }

    private boolean isEqual(Object object1, Object object2) {
        return object1 == null ? object2 == null : object1.equals(object2);
    }

    protected abstract Map getListValues(String var1, AddressContainer var2, boolean var3) throws IOException, NamingException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map listLocalContext(String name, boolean listBindings, User user, AddressContainer addressContainer, boolean remoteableOnly) {
        boolean rootName = name.equals("");
        HashMap<String, Object[]> values = this.getParentContext() == null ? new HashMap<String, Object[]>() : this.getParentContext().listLocalContext(name, listBindings, user, addressContainer, remoteableOnly);
        Map map = this.bindings;
        synchronized (map) {
            Iterator iterator = this.bindings.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String entryName = (String)entry.getKey();
                if ((!rootName || entryName.indexOf(47) >= 0) && (entryName.lastIndexOf(47) != name.length() || !entryName.startsWith(name)) || rootName && entryName.indexOf(58) > 0) continue;
                try {
                    Object[] objectArray;
                    RMIBinding rmiBinding = (RMIBinding)entry.getValue();
                    if (remoteableOnly && !rmiBinding.isRemoteableValue()) continue;
                    Object value = rmiBinding.getValue(name, (Context)this, this.m_bindingEnvironment);
                    String bindingName = rootName ? entryName : entryName.substring(name.length() + 1);
                    if (!this.isListable(bindingName, user, addressContainer)) continue;
                    if (listBindings) {
                        Object[] objectArray2 = new Object[2];
                        objectArray2[0] = this.getListingClassName(value);
                        objectArray = objectArray2;
                        objectArray2[1] = value;
                    } else {
                        objectArray = this.getListingClassName(value);
                    }
                    values.put(bindingName, objectArray);
                }
                catch (NamingException e) {}
            }
        }
        return values;
    }

    protected boolean isListable(String bindingName, User user, AddressContainer addressContainer) {
        return true;
    }

    protected RMIContext getParentContext() {
        return null;
    }

    protected Object lookupInFederatedContexts(String name) throws NamingException {
        Object objToReturn = null;
        String nameToParse = name;
        int indexOfSlash = nameToParse.lastIndexOf("/");
        String bindingName = "";
        while (indexOfSlash != -1) {
            String contextName = nameToParse.substring(0, indexOfSlash);
            String restOfName = nameToParse.substring(indexOfSlash + 1);
            bindingName = bindingName.length() == 0 ? restOfName : restOfName + "/" + bindingName;
            Object result = this.lookupLocalObject(contextName);
            if (result instanceof Context) {
                Context federatedContext = (Context)result;
                objToReturn = federatedContext.lookup(bindingName);
                break;
            }
            nameToParse = contextName;
            indexOfSlash = nameToParse.lastIndexOf("/");
        }
        return objToReturn;
    }

    private String getListingClassName(Object value) {
        if (CONTEXT_STRING.equals(value)) {
            return Context.class.getName();
        }
        if (!(value instanceof Remote)) {
            return value.getClass().getName();
        }
        Class<?>[] interfaces = value.getClass().getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (this.isMixinInterface(interfaces[i])) continue;
            return interfaces[i].getName();
        }
        return value.getClass().getName();
    }

    private boolean isMixinInterface(Class anInterface) {
        return Remote.class.isAssignableFrom(anInterface) || ClusterOnly.class.isAssignableFrom(anInterface);
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        this.checkServer();
        try {
            Map values = this.getListValues(name, null, true);
            Iterator iterator = values.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object[] array = (Object[])entry.getValue();
                if (!CONTEXT_STRING.equals(array[1])) continue;
                String compositeName = (name.equals("") ? "" : name + "/") + entry.getKey();
                array[1] = new SubContext(this, compositeName);
                array[0] = array[1].getClass().getName();
            }
            return new MapNamingEnumeration(values, true);
        }
        catch (IOException e) {
            NamingException ne = new NamingException(e.getMessage());
            ne.setRootCause(e);
            throw ne;
        }
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    public void destroySubcontext(String name) throws NamingException {
        NamingEnumeration ne = this.list(name);
        if (ne.hasMore()) {
            throw new ContextNotEmptyException();
        }
        this.unbind(name);
    }

    public void destroySubcontext(Name name) throws NamingException {
        this.destroySubcontext(name.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Context createSubcontext(String name) throws NamingException {
        Map map = this.bindings;
        synchronized (map) {
            this.bind(name, (Object)CONTEXT_STRING);
            return (Context)this.lookup(name);
        }
    }

    public Context createSubcontext(Name name) throws NamingException {
        return this.createSubcontext(name.toString());
    }

    public Object lookupLink(String name) throws NamingException {
        return this.lookup(name);
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.lookupLink(name.toString());
    }

    public NameParser getNameParser(String name) throws NamingException {
        return FlatNameParser.getInstance();
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return this.getNameParser(name.toString());
    }

    public String composeName(String name, String prefix) throws NamingException {
        Name result = this.composeName(new CompositeName(name), new CompositeName(prefix));
        return result.toString();
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        Name result = (Name)prefix.clone();
        result.addAll(name);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object addToEnvironment(String name, Object value) throws NamingException {
        if (RMIContext.isMutableProperty(name)) {
            if (this.environment == null) {
                this.environment = new HashMap(5, 0.75f);
            }
            Map map = this.environment;
            synchronized (map) {
                return this.environment.put(name, value);
            }
        }
        throw new OperationNotSupportedException("Context properties are immutable after creation");
    }

    private static boolean isMutableProperty(String name) {
        return !listOfImmutablePropertyNames.contains(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object removeFromEnvironment(String name) throws NamingException {
        if (this.environment == null) {
            return null;
        }
        Map map = this.environment;
        synchronized (map) {
            return this.environment.remove(name);
        }
    }

    public Hashtable getEnvironment() throws NamingException {
        if (this.environment == null) {
            this.environment = new Hashtable();
        }
        return new Hashtable(this.environment);
    }

    public boolean getOpmnFlag() {
        if (this.environment == null) {
            return false;
        }
        String flag = (String)this.environment.get("OPMN");
        return "true".equalsIgnoreCase(flag);
    }

    public String getNameInNamespace() throws NamingException {
        return "";
    }

    public void close() throws NamingException {
        this.m_securityContextHelper.disassociateUserFromThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdownAssociatedServer() {
        if (this.server == null) {
            return;
        }
        this.server.destroy("Context closed");
        RMIContext rMIContext = this;
        synchronized (rMIContext) {
            this.environment = null;
            this.server = null;
            this.domain = null;
            this.bindings = null;
        }
    }

    RMIClient getManager() throws NamingException {
        this.checkServer();
        return this.server;
    }

    public Object lookupLocalObject(String name) throws NamingException {
        RMIBinding binding = this.getBinding(name);
        return binding == null ? null : binding.getValue(name, (Context)this, this.m_bindingEnvironment);
    }

    Object lookupRemoteableObject(String name) throws NamingException {
        RMIBinding binding = this.getBinding(name);
        return binding == null ? null : binding.getRemoteableValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RMIBinding getBinding(String name) {
        m_logger.log(Level.FINE, "Looking up binding for {0}", name);
        RMIClient rMIClient = this.server;
        synchronized (rMIClient) {
            Map map = this.bindings;
            synchronized (map) {
                return (RMIBinding)this.bindings.get(name);
            }
        }
    }

    protected void putBinding(String name, Object value, int mode) {
        RMIBinding binding = new RMIBinding(value, mode);
        this.putBinding(name, binding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putBinding(String name, RMIBinding binding) {
        String contextName;
        if (name.indexOf(47) >= 0 && !this.hasBinding(contextName = name.substring(0, name.lastIndexOf(47)))) {
            this.putBinding(contextName, CONTEXT_STRING, binding.getDistributionMode());
        }
        Map map = this.bindings;
        synchronized (map) {
            this.bindings.put(name, binding);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getBoundNames() {
        Map map = this.bindings;
        synchronized (map) {
            return new HashSet(this.bindings.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasBinding(String name) {
        Map map = this.bindings;
        synchronized (map) {
            return this.bindings.containsKey(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasLocalBindingInParentHierarchy(String name) {
        RMIClient rMIClient = this.server;
        synchronized (rMIClient) {
            Map map = this.bindings;
            synchronized (map) {
                if (this.getParentContext() == null) {
                    return this.bindings.containsKey(name);
                }
                return this.bindings.containsKey(name) || this.getParentContext().hasLocalBindingInParentHierarchy(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasRemoteableBindingInParentHierarchy(String name) {
        RMIClient rMIClient = this.server;
        synchronized (rMIClient) {
            Map map = this.bindings;
            synchronized (map) {
                if (this.getParentContext() == null) {
                    RMIBinding binding = this.getBinding(name);
                    return this.hasBinding(name) && binding.isRemoteableValue();
                }
                RMIBinding binding = this.getBinding(name);
                return this.hasBinding(name) && binding.isRemoteableValue() || this.getParentContext().hasRemoteableBindingInParentHierarchy(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forEachEntry(EntryAction action) throws IOException {
        HashMap bindings;
        Map map = this.bindings;
        synchronized (map) {
            bindings = new HashMap(this.bindings);
        }
        Iterator iterator = bindings.entrySet().iterator();
        while (iterator.hasNext()) {
            try {
                Map.Entry entry = iterator.next();
                action.processEntry(entry.getKey(), entry.getValue());
            }
            catch (NamingException e) {
                this.server.log(action.getLogMessage(e), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void unbindAll(RMIConnection connection) {
        Map bindings = this.bindings;
        if (bindings == null) {
            return;
        }
        Map map = bindings;
        synchronized (map) {
            Iterator iterator = bindings.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                try {
                    RMIBinding bind = (RMIBinding)entry.getValue();
                    Object value = bind.getValue();
                    if (!(value instanceof EvermindRemote)) continue;
                    EvermindRemote remote = (EvermindRemote)value;
                    if (remote.getInvocationHandler().connection != connection) continue;
                    iterator.remove();
                }
                catch (Throwable t) {
                    iterator.remove();
                    m_logger.log(Level.FINE, "unbindAll failure", t);
                }
            }
        }
    }

    public String toString() {
        return "[RMI context@" + this.hashCode() + " " + (this.domain == null ? "<global>" : this.domain) + "]";
    }

    public String getName() {
        return this.domain;
    }

    boolean needToShuffle() {
        return this.shuffle;
    }

    void setNeedToShuffle() {
        try {
            String lbl = null;
            if (this.environment != null) {
                lbl = (String)this.environment.get(LBLProperty);
            }
            if (lbl == null) {
                this.shuffle = Boolean.getBoolean(LBLProperty);
            } else if (lbl.equalsIgnoreCase("true")) {
                this.shuffle = true;
            }
        }
        catch (Throwable t) {
            m_logger.warning("Error trying to read property LoadBalanceOnLookup lookup: " + t);
        }
    }

    public String getPassword() {
        return this.environment == null ? null : this.environment.get("java.naming.security.credentials");
    }

    public String getUserName() {
        return this.environment == null ? null : this.environment.get("java.naming.security.principal");
    }

    class FlatBindings
    implements NamingEnumeration {
        Enumeration names;

        FlatBindings(Enumeration names) {
            this.names = names;
        }

        public boolean hasMoreElements() {
            return this.names.hasMoreElements();
        }

        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        public Object nextElement() {
            try {
                return this.next();
            }
            catch (NamingException e) {
                throw new RuntimeException("RemoteException: " + e.getMessage());
            }
        }

        public Object next() throws NamingException {
            String name = (String)this.names.nextElement();
            return new Binding(name, RMIContext.this.lookup(name));
        }

        public void close() {
        }
    }

    class FlatNames
    implements NamingEnumeration {
        Enumeration names;

        FlatNames(Enumeration names) {
            this.names = names;
        }

        public boolean hasMoreElements() {
            return this.names.hasMoreElements();
        }

        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        public Object nextElement() {
            try {
                return this.next();
            }
            catch (NamingException e) {
                throw new RuntimeException("RemoteException: " + e.getMessage());
            }
        }

        public Object next() throws NamingException {
            String name = (String)this.names.nextElement();
            String className = RMIContext.this.lookup(name).getClass().getName();
            return new NameClassPair(name, className);
        }

        public void close() {
        }
    }
}

