/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.rmi;

import com.evermind.naming.SubContext;
import com.evermind.net.AddressContainer;
import com.evermind.server.cluster.ServerIdentification;
import com.evermind.server.rmi.RMIBinding;
import com.evermind.server.rmi.RMIClient;
import com.evermind.server.rmi.RMIClientConnection;
import com.evermind.server.rmi.RMIContext;
import com.evermind.server.rmi.RMIInitialContext;
import com.evermind.server.rmi.RMILocation;
import com.evermind.server.rmi.RmiServerLookupStrategy;
import com.evermind.util.RMIProperties;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.CommunicationException;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import oracle.j2ee.jndi.JndiMessages;
import oracle.j2ee.naming.SecurityContextHelper;
import oracle.j2ee.util.TraceLogger;

public class RMIClientContext
extends RMIContext {
    private static Logger m_logger = TraceLogger.getLogger(RMIClientContext.class);
    private static final int MIN_RECOVERY_RETRY_COUNT = RMIProperties.getRmiMinRecoveryRetryCount();
    private RMIClient m_client;
    private volatile boolean m_removedContext;
    private long m_referenceCount;
    private final Object m_referenceLock = new Object();
    private int m_recoveryRetryCount;

    public RMIClientContext(RMIClient client, String domain, Map environment) {
        this(client, domain, environment, SecurityContextHelper.getInstance());
    }

    RMIClientContext(RMIClient client, String domain, Map environment, SecurityContextHelper securityContextHelper) {
        super(client, domain, environment, securityContextHelper);
        this.m_client = client;
        this.m_referenceCount = 1L;
        this.m_removedContext = false;
        this.initMinRecoveryRetryCount(environment, MIN_RECOVERY_RETRY_COUNT);
    }

    public Object lookup(String name) throws NamingException {
        try {
            if (name.length() == 0) {
                return new SubContext(this, name);
            }
            Object object = this.getManager().lookup(this, name);
            if (object == null) {
                throw new NameNotFoundException(name + " not found");
            }
            if ("<context>".equals(object)) {
                return new SubContext(this, name);
            }
            RMIBinding binding = new RMIBinding(object, 3);
            this.putBinding(name, binding);
            return RMIClientContext.isBoundNullValue(object) ? null : binding.getValue(name, (Context)this, this.getEnvironment());
        }
        catch (NamingException e) {
            m_logger.log(Level.FINER, "RMIContext remote lookup failed", e);
            throw e;
        }
        catch (RemoteException e) {
            m_logger.log(Level.FINER, "RMIContext remote lookup failed", e);
            NamingException ne = new NamingException(e.getMessage());
            if (e.detail != null) {
                ne.setRootCause(e.detail);
            }
            throw ne;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws NamingException {
        super.close();
        boolean removeContext = false;
        Object object = this.m_referenceLock;
        synchronized (object) {
            --this.m_referenceCount;
            removeContext = this.m_referenceCount <= 0L;
        }
        if (removeContext) {
            this.m_client.removeContext(this);
            this.m_removedContext = true;
        }
    }

    protected void finalize() throws Throwable {
        if (!this.m_removedContext) {
            try {
                this.m_client.removeContext(this);
            }
            catch (Throwable t) {
                m_logger.log(Level.FINER, "RMIContext finalize failed", t);
            }
        }
        super.finalize();
    }

    public boolean isMatchingContext(Object other) {
        return other instanceof RMIClientContext && this.equalAttributes((RMIClientContext)other);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean useIfActiveContext() {
        Object object = this.m_referenceLock;
        synchronized (object) {
            if (this.m_referenceCount > 0L) {
                ++this.m_referenceCount;
                return true;
            }
            return false;
        }
    }

    private static boolean isBoundNullValue(Object object) {
        return object == RMIClientConnection.RMI_NULL_BINDING;
    }

    protected Map getListValues(String startContextName, AddressContainer addressContainer, boolean bindings) throws IOException, NamingException {
        return this.getManager().list(this, startContextName, bindings);
    }

    void establishLookupConnections(RMILocation location, RMIClient rmiClient, String userName, String password) throws IOException {
        RmiServerLookupStrategy lookupStrategy = location.createLookupStrategy();
        ServerIdentification[] servers = lookupStrategy.getAvailableServers(rmiClient, location.getApplication());
        boolean lookupURLServerFound = false;
        for (int i = 0; i < servers.length; ++i) {
            if (null == rmiClient.getConnection(location.getTransportForServer(servers[i]), userName, password, this)) continue;
            lookupURLServerFound = true;
        }
        if (!lookupURLServerFound) {
            throw new IOException("No servers found using " + lookupStrategy);
        }
        if (0 < this.m_recoveryRetryCount && this.m_recoveryRetryCount < servers.length) {
            this.m_recoveryRetryCount = servers.length;
        }
    }

    void establishRemoteConnections() throws NamingException {
        Hashtable environment = this.getEnvironment();
        boolean foundAtLeastOneServer = false;
        RMILocation[] locations = RMIClient.getLocations(RMIClientContext.getProviderUrl(environment));
        RMILocation location = null;
        for (int i = 0; i < locations.length; ++i) {
            String currentPrincipal = this.m_securityContextHelper.getCurrentPrincipal(this);
            String currentCredential = this.m_securityContextHelper.getCurrentCredential(this);
            try {
                if (locations[i].isLookupURL()) {
                    this.establishLookupConnections(locations[i], this.m_client, currentPrincipal, currentCredential);
                } else {
                    this.m_client.getConnection(locations[i].getTransport(), currentPrincipal, currentCredential, this);
                }
                foundAtLeastOneServer = true;
                if (null != location) continue;
                location = locations[i];
                continue;
            }
            catch (IOException e) {
                JndiMessages.logException(e);
                if (foundAtLeastOneServer || i + 1 <= locations.length) continue;
                throw new CommunicationException(e.toString());
            }
        }
        if (null != location && RMIInitialContext.isImmediateAuth(environment)) {
            try {
                this.getManager().authenticate(this, location);
            }
            catch (RemoteException e) {
                throw new NamingException(e.getMessage());
            }
            catch (IOException e) {
                throw new NamingException(e.getMessage());
            }
        }
    }

    boolean isRemovedContext() {
        return this.m_removedContext;
    }

    long getReferenceCount() {
        return this.m_referenceCount;
    }

    static String getProviderUrl(Map environment) throws NamingException {
        String comboURLString;
        String string = comboURLString = environment == null ? null : (String)environment.get("java.naming.provider.url");
        if (comboURLString == null || comboURLString.trim().length() == 0) {
            throw new NamingException("Environment is missing a java.naming.provider.url attribute - nowhere to connect");
        }
        return comboURLString;
    }

    int getRecoveryRetryCount() {
        return this.m_recoveryRetryCount;
    }

    private void initMinRecoveryRetryCount(Map env, int defaultValue) {
        try {
            String value = env != null ? (String)env.get("rmi.min.recovery.retry.count") : null;
            this.m_recoveryRetryCount = value != null ? Integer.parseInt(value) : defaultValue;
        }
        catch (NumberFormatException e) {
            this.m_recoveryRetryCount = defaultValue;
        }
    }
}

