/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.multicastjms.deployment;

import com.evermind.server.multicastjms.deployment.ConnectionFactoryConfig;
import com.evermind.xml.XMLUtils;
import java.io.IOException;
import java.io.PrintWriter;
import org.w3c.dom.Node;

public class TopicConnectionFactoryConfig
extends ConnectionFactoryConfig {
    private long id;

    public TopicConnectionFactoryConfig(Node parent, boolean transactional) throws InstantiationException {
        super(parent, transactional);
        String idString = XMLUtils.getNodeAttribute(parent, "id");
        if (idString != null) {
            try {
                this.id = Integer.parseInt(idString);
            }
            catch (NumberFormatException e) {
                throw new InstantiationException("Illegal 'id' attribute value in topic-connection-factory tag (must be numerical): " + idString);
            }
        } else {
            this.id = (int)(Math.random() * 2.147483647E9);
        }
    }

    public void writeXML(PrintWriter out, String indention) throws IOException {
        out.print(indention + "<" + (this.transactional ? "xa-topic-connection-factory" : "topic-connection-factory"));
        if (this.host != null) {
            out.print(" address=\"" + XMLUtils.encode(this.host) + "\"");
        }
        out.print(" port=\"" + this.port + "\"");
        if (this.cmtLocation != null) {
            out.print(" cmt-location=\"" + this.cmtLocation + "\"");
        }
        out.println(" />");
    }

    public long getId() {
        return this.id;
    }
}

