/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.multicastjms;

import com.evermind.io.IOUtils;
import com.evermind.server.multicastjms.BooleanProperty;
import com.evermind.server.multicastjms.ByteArrayProperty;
import com.evermind.server.multicastjms.ByteProperty;
import com.evermind.server.multicastjms.ByteStringProperty;
import com.evermind.server.multicastjms.CharProperty;
import com.evermind.server.multicastjms.DoubleProperty;
import com.evermind.server.multicastjms.FloatProperty;
import com.evermind.server.multicastjms.IntProperty;
import com.evermind.server.multicastjms.LongProperty;
import com.evermind.server.multicastjms.Property;
import com.evermind.server.multicastjms.PropertyNameEnumeration;
import com.evermind.server.multicastjms.ShortProperty;
import com.evermind.server.multicastjms.StringProperty;
import com.evermind.util.ByteString;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;

public class PropertyMap {
    protected Property[] properties = new Property[4];
    protected int propertyCount;

    public void read(InputStream in, DataInputStream dataIn) throws IOException {
        int count = dataIn.readInt();
        block11: for (int i = 0; i < count; ++i) {
            String propertyName = dataIn.readUTF();
            int type = in.read();
            switch (type) {
                case 33: {
                    this.addProperty(new ByteProperty(propertyName, (byte)in.read()));
                    continue block11;
                }
                case 39: {
                    this.addProperty(new ShortProperty(propertyName, dataIn.readShort()));
                    continue block11;
                }
                case 40: {
                    this.addProperty(new LongProperty(propertyName, dataIn.readLong()));
                    continue block11;
                }
                case 35: {
                    this.addProperty(new FloatProperty(propertyName, dataIn.readFloat()));
                    continue block11;
                }
                case 36: {
                    this.addProperty(new DoubleProperty(propertyName, dataIn.readDouble()));
                    continue block11;
                }
                case 32: {
                    this.addProperty(new IntProperty(propertyName, IOUtils.readCompressedInt(dataIn)));
                    continue block11;
                }
                case 37: {
                    this.addProperty(new StringProperty(propertyName, IOUtils.readLongUTF(in, true)));
                    continue block11;
                }
                case 42: {
                    ByteString string;
                    int length = IOUtils.readCompressedInt(in);
                    if (length >= 0) {
                        string = new ByteString(length);
                        IOUtils.readFully(in, string.data, 0, length);
                        string.length = length;
                    } else {
                        string = null;
                    }
                    this.addProperty(new ByteStringProperty(propertyName, string));
                    continue block11;
                }
                case 38: {
                    this.addProperty(new BooleanProperty(propertyName, dataIn.readBoolean()));
                }
            }
        }
    }

    public void write(OutputStream out, DataOutputStream dataOut) throws IOException {
        dataOut.writeInt(this.propertyCount);
        for (int i = 0; i < this.propertyCount; ++i) {
            dataOut.writeUTF(this.properties[i].name);
            if (this.properties[i] instanceof IntProperty) {
                out.write(32);
                IOUtils.writeCompressedInt(dataOut, ((IntProperty)this.properties[i]).value);
                continue;
            }
            if (this.properties[i] instanceof FloatProperty) {
                out.write(35);
                dataOut.writeFloat(((FloatProperty)this.properties[i]).value);
                continue;
            }
            if (this.properties[i] instanceof ByteProperty) {
                out.write(33);
                dataOut.writeByte(((ByteProperty)this.properties[i]).value);
                continue;
            }
            if (this.properties[i] instanceof ShortProperty) {
                out.write(39);
                dataOut.writeShort(((ShortProperty)this.properties[i]).value);
                continue;
            }
            if (this.properties[i] instanceof LongProperty) {
                out.write(40);
                dataOut.writeLong(((LongProperty)this.properties[i]).value);
                continue;
            }
            if (this.properties[i] instanceof DoubleProperty) {
                out.write(36);
                dataOut.writeDouble(((DoubleProperty)this.properties[i]).value);
                continue;
            }
            if (this.properties[i] instanceof StringProperty) {
                out.write(37);
                IOUtils.writeLongUTF(out, ((StringProperty)this.properties[i]).value, true);
                continue;
            }
            if (this.properties[i] instanceof ByteStringProperty) {
                out.write(42);
                ByteString string = ((ByteStringProperty)this.properties[i]).value;
                if (string == null) {
                    IOUtils.writeCompressedInt(out, -1);
                    continue;
                }
                IOUtils.writeCompressedInt(dataOut, string.length);
                dataOut.write(string.data, string.offset, string.length);
                continue;
            }
            if (!(this.properties[i] instanceof BooleanProperty)) continue;
            out.write(38);
            dataOut.writeBoolean(((BooleanProperty)this.properties[i]).value);
        }
    }

    public Enumeration getPropertyNames() {
        return new PropertyNameEnumeration(this.properties);
    }

    public boolean propertyExists(String name) {
        for (int i = 0; i < this.propertyCount; ++i) {
            if (!this.properties[i].name.equals(name)) continue;
            return true;
        }
        return false;
    }

    public Object getObjectProperty(String name) {
        for (int i = 0; i < this.propertyCount; ++i) {
            if (!this.properties[i].name.equals(name)) continue;
            return this.properties[i].getObjectValue();
        }
        return null;
    }

    public String getStringProperty(String name) {
        for (int i = 0; i < this.propertyCount; ++i) {
            if (!this.properties[i].name.equals(name)) continue;
            return this.properties[i].getStringValue();
        }
        return null;
    }

    public long getLongProperty(String name) throws JMSException {
        for (int i = 0; i < this.propertyCount; ++i) {
            if (!this.properties[i].name.equals(name)) continue;
            if (this.properties[i] instanceof LongProperty) {
                return ((LongProperty)this.properties[i]).value;
            }
            if (this.properties[i] instanceof StringProperty) {
                return Long.parseLong(((StringProperty)this.properties[i]).value);
            }
            throw new JMSException("Unsupported type-conversion");
        }
        throw new NullPointerException();
    }

    public boolean getBooleanProperty(String name) throws JMSException {
        for (int i = 0; i < this.propertyCount; ++i) {
            if (!this.properties[i].name.equals(name)) continue;
            if (this.properties[i] instanceof BooleanProperty) {
                return ((BooleanProperty)this.properties[i]).value;
            }
            if (this.properties[i] instanceof StringProperty) {
                return Boolean.getBoolean(((StringProperty)this.properties[i]).value);
            }
            throw new JMSException("Unsupported type-conversion");
        }
        throw new NullPointerException();
    }

    public byte getByteProperty(String name) throws JMSException {
        for (int i = 0; i < this.propertyCount; ++i) {
            if (!this.properties[i].name.equals(name)) continue;
            if (this.properties[i] instanceof ByteProperty) {
                return ((ByteProperty)this.properties[i]).value;
            }
            if (this.properties[i] instanceof StringProperty) {
                return Byte.parseByte(((StringProperty)this.properties[i]).value);
            }
            throw new JMSException("Unsupported type-conversion");
        }
        throw new NullPointerException();
    }

    public int getIntProperty(String name) throws JMSException {
        for (int i = 0; i < this.propertyCount; ++i) {
            if (!this.properties[i].name.equals(name)) continue;
            if (this.properties[i] instanceof IntProperty) {
                return ((IntProperty)this.properties[i]).value;
            }
            if (this.properties[i] instanceof StringProperty) {
                return Integer.parseInt(((StringProperty)this.properties[i]).value);
            }
            throw new JMSException("Unsupported type-conversion");
        }
        throw new NullPointerException();
    }

    public char getCharProperty(String name) throws JMSException {
        for (int i = 0; i < this.propertyCount; ++i) {
            if (!this.properties[i].name.equals(name)) continue;
            if (this.properties[i] instanceof CharProperty) {
                return ((CharProperty)this.properties[i]).value;
            }
            if (this.properties[i] instanceof StringProperty) {
                return ((StringProperty)this.properties[i]).value.charAt(0);
            }
            throw new JMSException("Unsupported type-conversion");
        }
        throw new NullPointerException();
    }

    public float getFloatProperty(String name) throws JMSException {
        for (int i = 0; i < this.propertyCount; ++i) {
            if (!this.properties[i].name.equals(name)) continue;
            if (this.properties[i] instanceof FloatProperty) {
                return ((FloatProperty)this.properties[i]).value;
            }
            if (this.properties[i] instanceof StringProperty) {
                return Float.parseFloat(((StringProperty)this.properties[i]).value);
            }
            throw new JMSException("Unsupported type-conversion");
        }
        throw new NullPointerException();
    }

    public double getDoubleProperty(String name) throws JMSException {
        for (int i = 0; i < this.propertyCount; ++i) {
            if (!this.properties[i].name.equals(name)) continue;
            if (this.properties[i] instanceof DoubleProperty) {
                return ((DoubleProperty)this.properties[i]).value;
            }
            if (this.properties[i] instanceof StringProperty) {
                return Double.parseDouble(((StringProperty)this.properties[i]).value);
            }
            throw new JMSException("Unsupported type-conversion");
        }
        throw new NullPointerException();
    }

    public short getShortProperty(String name) throws JMSException {
        for (int i = 0; i < this.propertyCount; ++i) {
            if (!this.properties[i].name.equals(name)) continue;
            if (this.properties[i] instanceof ShortProperty) {
                return ((ShortProperty)this.properties[i]).value;
            }
            if (this.properties[i] instanceof StringProperty) {
                return Short.parseShort(((StringProperty)this.properties[i]).value);
            }
            throw new JMSException("Unsupported type-conversion");
        }
        throw new NullPointerException();
    }

    private void ensureCapacity() {
        if (this.properties == null) {
            this.properties = new Property[4];
        }
        if (this.propertyCount >= this.properties.length) {
            Property[] newProperties = new Property[this.properties.length * 2];
            System.arraycopy(this.properties, 0, newProperties, 0, this.properties.length);
            this.properties = newProperties;
        }
    }

    public synchronized void setObjectProperty(String name, Object value) throws MessageFormatException {
        int index = this.getInsertIndex(name);
        if (value instanceof String) {
            this.properties[index] = new StringProperty(name, (String)value);
        } else if (value instanceof Integer) {
            this.properties[index] = new IntProperty(name, (Integer)value);
        } else if (value instanceof Long) {
            this.properties[index] = new LongProperty(name, (Long)value);
        } else if (value instanceof Double) {
            this.properties[index] = new DoubleProperty(name, (Double)value);
        } else if (value instanceof Float) {
            this.properties[index] = new FloatProperty(name, ((Float)value).floatValue());
        } else if (value instanceof Byte) {
            this.properties[index] = new ByteProperty(name, (Byte)value);
        } else if (value instanceof Short) {
            this.properties[index] = new ShortProperty(name, (Short)value);
        } else if (value instanceof Boolean) {
            this.properties[index] = new BooleanProperty(name, (Boolean)value);
        } else {
            if (value == null) {
                throw new NullPointerException("Property value was null, must be a Boolean, Byte, Short, Integer, Long, Float, Double or String");
            }
            throw new MessageFormatException("Property value type must be a Boolean, Byte, Short, Integer, Long, Float, Double or String, not a " + value.getClass().getName());
        }
    }

    public void addProperty(Property property) {
        this.ensureCapacity();
        this.properties[this.propertyCount++] = property;
    }

    public int getPropertyCount() {
        return this.propertyCount;
    }

    public Property[] getProperties() {
        return this.properties;
    }

    public synchronized void setBooleanProperty(String name, boolean value) {
        int index = this.getInsertIndex(name);
        this.properties[index] = new BooleanProperty(name, value);
    }

    public synchronized void setCharProperty(String name, char value) {
        int index = this.getInsertIndex(name);
        this.properties[index] = new CharProperty(name, value);
    }

    public synchronized void setShortProperty(String name, short value) {
        int index = this.getInsertIndex(name);
        this.properties[index] = new ShortProperty(name, value);
    }

    public synchronized void setByteProperty(String name, byte value) {
        int index = this.getInsertIndex(name);
        this.properties[index] = new ByteProperty(name, value);
    }

    public synchronized void setIntProperty(String name, int value) {
        int index = this.getInsertIndex(name);
        this.properties[index] = new IntProperty(name, value);
    }

    public synchronized void setLongProperty(String name, long value) {
        int index = this.getInsertIndex(name);
        this.properties[index] = new LongProperty(name, value);
    }

    public synchronized void setStringProperty(String name, String value) {
        if (value == null) {
            throw new NullPointerException("property value was null");
        }
        int index = this.getInsertIndex(name);
        this.properties[index] = new StringProperty(name, value);
    }

    public synchronized void setDoubleProperty(String name, double value) {
        int index = this.getInsertIndex(name);
        this.properties[index] = new DoubleProperty(name, value);
    }

    public synchronized void setFloatProperty(String name, float value) {
        int index = this.getInsertIndex(name);
        this.properties[index] = new FloatProperty(name, value);
    }

    public synchronized void setBytesProperty(String name, byte[] value, int start, int end) {
        int index = this.getInsertIndex(name);
        this.properties[index] = new ByteArrayProperty(name, value, start, end);
    }

    public synchronized void setByteStringProperty(String name, ByteString value) {
        int index = this.getInsertIndex(name);
        this.properties[index] = new ByteStringProperty(name, value);
    }

    public synchronized void setBytesProperty(String name, byte[] value) {
        int index = this.getInsertIndex(name);
        this.properties[index] = new ByteArrayProperty(name, value, 0, value.length);
    }

    public byte[] getBytesProperty(String name) throws JMSException {
        for (int i = 0; i < this.propertyCount; ++i) {
            if (!this.properties[i].name.equals(name)) continue;
            if (this.properties[i] instanceof ByteArrayProperty) {
                return ((ByteArrayProperty)this.properties[i]).value;
            }
            if (this.properties[i] instanceof StringProperty) {
                return ((StringProperty)this.properties[i]).value.getBytes();
            }
            throw new JMSException("Unsupported type-conversion");
        }
        throw new NullPointerException();
    }

    public ByteString getByteStringProperty(String name) throws JMSException {
        for (int i = 0; i < this.propertyCount; ++i) {
            if (!this.properties[i].name.equals(name)) continue;
            if (this.properties[i] instanceof ByteStringProperty) {
                return ((ByteStringProperty)this.properties[i]).value;
            }
            if (this.properties[i] instanceof StringProperty) {
                return new ByteString(((StringProperty)this.properties[i]).value);
            }
            throw new JMSException("Unsupported type-conversion");
        }
        throw new NullPointerException();
    }

    private int getInsertIndex(String name) {
        if (this.properties != null) {
            for (int i = 0; i < this.propertyCount; ++i) {
                if (!this.properties[i].name.equals(name)) continue;
                return i;
            }
        }
        this.ensureCapacity();
        return this.propertyCount++;
    }

    public synchronized void clearProperties() {
        this.propertyCount = 0;
    }

    public String toString() {
        StringBuffer reply = new StringBuffer();
        reply.append('[');
        for (int i = 0; i < this.propertyCount; ++i) {
            if (i > 0) {
                reply.append(", ");
            }
            try {
                reply.append(this.properties[i].name + "=" + this.properties[i].getStringValue());
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        reply.append(']');
        return reply.toString();
    }

    public PropertyMap cloneProperties(PropertyMap other) {
        other.properties = this.properties;
        other.propertyCount = this.propertyCount;
        return other;
    }
}

