/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.multicastjms;

import com.evermind.io.SingleReadBufferInputStream;
import com.evermind.net.NetworkConnection;
import com.evermind.server.multicastjms.EvermindMessage;
import com.evermind.server.multicastjms.EvermindQueueBrowser;
import com.evermind.server.multicastjms.EvermindQueueBrowserEnumeration;
import com.evermind.server.multicastjms.JMSCommands;
import com.evermind.server.multicastjms.JMSConnection;
import com.evermind.util.JMSProperties;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.jms.JMSException;

public class JMSServerConnection
extends JMSConnection
implements JMSCommands {
    protected NetworkConnection connection;
    protected List queueNames = new ArrayList();
    protected List selectorNames = new ArrayList();
    protected List listeners = new ArrayList();
    protected int currentBrowserEnumerationID;
    protected boolean listening = false;
    protected int listenID = 0;
    protected String disconnectedMessage;
    protected int id;
    String incomingTopic;
    protected EvermindMessage incomingTopicMessage;
    private EvermindMessage incomingMessage;
    private int incomingID = -1;

    public JMSServerConnection(NetworkConnection connection, String username, String password) throws IOException {
        super(new SingleReadBufferInputStream(connection.getInputStream()), new BufferedOutputStream(connection.getOutputStream()));
        this.connection = connection;
        this.dataOut.write(163);
        this.dataOut.writeShort(1);
        this.dataOut.writeShort(1);
        if (username == null) {
            throw new IOException("No username specified");
        }
        if (password == null) {
            throw new IOException("No password specified");
        }
        this.dataOut.writeUTF(username);
        this.dataOut.writeUTF(password);
        this.out.flush();
        int identifier = this.dataIn.read();
        if (identifier != 163) {
            this.close();
            if (identifier == -1) {
                throw new IOException("Disconnected");
            }
            throw new IOException("Not an OC4J-JMS server");
        }
        short major = this.dataIn.readShort();
        short minor = this.dataIn.readShort();
        if (major != 1) {
            this.close();
            throw new IOException("OC4J-JMS protocol mismatch (client upgrade may be needed)");
        }
        this.id = this.dataIn.readInt();
        if (this.id == -1) {
            String reason = this.dataIn.readUTF();
            this.close();
            throw new SecurityException("Invalid username/password for " + connection.getInetAddress() + ":" + connection.getPort() + " (" + reason + ")");
        }
    }

    public int getID() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.alive = false;
        try {
            OutputStream outputStream = this.out;
            synchronized (outputStream) {
                this.out.write(64);
                this.out.flush();
                this.in.close();
                this.out.close();
                this.connection.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized EvermindQueueBrowserEnumeration getQueueBrowserEnumeration(EvermindQueueBrowser browser) throws JMSException {
        OutputStream outputStream = this.out;
        synchronized (outputStream) {
            try {
                int queueID = this.getQueueID(browser.getQueue().getQueueName());
                int selectorID = -1;
                String selector = browser.getMessageSelector();
                if (selector != null) {
                    selectorID = this.getSelectorID(selector);
                }
                this.out.write(67);
                this.dataOut.writeInt(selectorID);
                this.dataOut.writeInt(queueID);
                this.out.flush();
                EvermindQueueBrowserEnumeration enumeration = new EvermindQueueBrowserEnumeration(browser, this.currentBrowserEnumerationID++);
                enumeration.initialize(this.in, this.dataIn);
                return enumeration;
            }
            catch (IOException e) {
                throw new JMSException("Disconnected");
            }
        }
    }

    public synchronized EvermindMessage receive(String queueName, String selector, long timeout, byte acknowledgeMode) throws JMSException {
        try {
            int queueIndex = this.getQueueID(queueName);
            int selectorIndex = selector == null ? -1 : this.getSelectorID(selector);
            this.out.write(65);
            this.dataOut.writeInt(queueIndex);
            this.dataOut.writeInt(selectorIndex);
            this.dataOut.writeLong(timeout);
            this.out.write(acknowledgeMode);
            this.out.flush();
            return this.receive(this.listenID++);
        }
        catch (IOException e) {
            this.close();
            throw new JMSException("Disconnected");
        }
    }

    public void createQueue(String name) throws JMSException {
        try {
            int queueID = this.getQueueID(name);
            this.out.write(66);
            this.dataOut.writeInt(queueID);
        }
        catch (IOException e) {
            this.close();
            throw new JMSException("Disconnected");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EvermindMessage receiveTopicMessage() throws JMSException {
        EvermindMessage message = null;
        InputStream inputStream = this.in;
        synchronized (inputStream) {
            while (this.incomingTopicMessage == null) {
                this.readCommand();
                if (this.incomingTopicMessage == null) {
                    this.notify();
                    continue;
                }
                message = this.incomingTopicMessage;
                this.incomingTopicMessage = null;
                this.notify();
                break;
            }
            return message;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private EvermindMessage receive(int id) throws JMSException {
        try {
            while (this.alive) {
                JMSServerConnection jMSServerConnection = this;
                synchronized (jMSServerConnection) {
                    if (!this.listening) {
                        this.listening = true;
                        this.readCommand();
                        this.listening = false;
                    } else {
                        this.wait();
                    }
                    if (this.incomingID == id) {
                        this.incomingID = -1;
                        EvermindMessage message = this.incomingMessage;
                        this.incomingMessage = null;
                        return message;
                    }
                    this.notify();
                }
            }
            throw new JMSException("Disconnected");
        }
        catch (InterruptedException e) {
            throw new JMSException("Interrupted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(String queueName, EvermindMessage message, boolean queue) throws JMSException {
        try {
            OutputStream outputStream = this.out;
            synchronized (outputStream) {
                int queueIndex = this.getQueueID(queueName);
                this.out.write(message.getTypeID());
                this.out.write(queue ? 1 : 0);
                this.dataOut.writeInt(queueIndex);
                message.write(this.out, this.dataOut);
                this.out.flush();
            }
        }
        catch (IOException e) {
            this.close();
            throw new JMSException("Disconnected");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readCommand() throws JMSException {
        InputStream inputStream = this.in;
        synchronized (inputStream) {
            try {
                int command = this.in.read();
                if (command < 0) {
                    throw new IOException("Disconnected");
                }
                if (command >= 1 && command <= 7) {
                    if (this.in.read() == 1) {
                        this.incomingID = this.dataIn.readInt();
                        this.incomingMessage = EvermindMessage.readMessage(command, this.in, this.dataIn);
                    } else {
                        this.incomingTopic = this.dataIn.readUTF();
                        this.incomingTopicMessage = EvermindMessage.readMessage(command, this.in, this.dataIn);
                    }
                    return;
                }
                switch (command) {
                    case 70: {
                        break;
                    }
                    default: {
                        if (JMSProperties.getJMSDebug()) {
                            System.out.println("Unknown command: " + command);
                        }
                    }
                    case 64: {
                        this.alive = false;
                        break;
                    }
                }
            }
            catch (IOException e) {
                this.disconnectedMessage = "IO Error: " + e;
                this.incomingMessage = null;
                this.incomingTopicMessage = null;
                this.close();
                throw new JMSException("IO Error: " + e);
            }
        }
    }

    synchronized void getQueueBrowserEnumerationMessages(EvermindQueueBrowserEnumeration enumeration) throws JMSException {
        try {
            this.out.write(69);
            this.dataOut.writeInt(enumeration.getID());
            this.out.flush();
            enumeration.readMessageBurst(this.in, this.dataIn);
        }
        catch (IOException e) {
            this.close();
            throw new JMSException("Disconnected");
        }
    }

    public synchronized List getDefinedQueueNames() throws JMSException {
        InputStream inputStream = this.in;
        synchronized (inputStream) {
            try {
                this.out.write(96);
                this.out.flush();
                ArrayList<String> queues = new ArrayList<String>();
                int count = this.dataIn.readInt();
                for (int i = 0; i < count; ++i) {
                    queues.add(this.dataIn.readUTF());
                }
                return queues;
            }
            catch (IOException e) {
                this.close();
                throw new JMSException("Disconnected");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerTopicInterest(String topicName) throws JMSException {
        OutputStream outputStream = this.out;
        synchronized (outputStream) {
            try {
                this.out.write(71);
                this.dataOut.writeUTF(topicName);
                this.out.flush();
            }
            catch (IOException e) {
                this.close();
                throw new JMSException("IO Error: " + e.getMessage());
            }
        }
    }

    public String toString() {
        return "ServerConnection " + this.id + "/" + this.connection;
    }

    public synchronized void acknowledgeMessages(EvermindMessage[] messages, int start, int end, boolean commit) throws JMSException {
        try {
            for (int i = start; i < end; ++i) {
                this.out.write(70);
                this.dataOut.writeLong(messages[i].sender);
                this.dataOut.writeInt(messages[i].id);
                this.dataOut.writeBoolean(commit);
            }
            this.out.flush();
        }
        catch (IOException e) {
            this.close();
            throw new JMSException("IO Error: " + e.getMessage());
        }
    }
}

