/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.multicastjms;

import com.evermind.server.multicastjms.JMSCommands;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public abstract class JMSConnection
implements JMSCommands {
    public static final short MAJOR_VERSION = 1;
    public static final short MINOR_VERSION = 1;
    public static final int JMS_PROTOCOL_IDENTIFIER = 163;
    protected InputStream in;
    protected DataInputStream dataIn;
    protected OutputStream out;
    protected DataOutputStream dataOut;
    protected boolean alive = true;
    protected List queueNames = new ArrayList();
    protected List selectors = new ArrayList();

    public JMSConnection(InputStream in, OutputStream out) throws IOException {
        this.in = in;
        this.out = out;
        this.dataIn = new DataInputStream(in);
        this.dataOut = new DataOutputStream(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getQueueID(String name) throws IOException {
        OutputStream outputStream = this.out;
        synchronized (outputStream) {
            int index = this.queueNames.indexOf(name);
            if (index < 0) {
                index = this.queueNames.size();
                this.queueNames.add(name);
                this.out.write(24);
                this.dataOut.writeUTF(name);
            }
            return index;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSelectorID(String name) throws IOException {
        OutputStream outputStream = this.out;
        synchronized (outputStream) {
            int index = this.selectors.indexOf(name);
            if (index < 0) {
                index = this.selectors.size();
                this.selectors.add(name);
                this.out.write(25);
                this.dataOut.writeUTF(name);
            }
            return index;
        }
    }
}

