/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.multicastjms;

import com.evermind.server.multicastjms.EvermindMessage;
import com.evermind.server.multicastjms.EvermindMessageProducer;
import com.evermind.server.multicastjms.EvermindTopic;
import com.evermind.server.multicastjms.EvermindTopicSession;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import javax.jms.Topic;
import javax.jms.TopicPublisher;

public class EvermindTopicPublisher
extends EvermindMessageProducer
implements TopicPublisher {
    protected EvermindTopicSession session;
    protected EvermindTopic topic;

    public EvermindTopicPublisher(EvermindTopicSession session, EvermindTopic topic) {
        this.session = session;
        this.topic = topic;
    }

    public Topic getTopic() {
        return this.topic;
    }

    public void publish(Message message) throws MessageFormatException, JMSException {
        this.publish(this.topic, message, this.deliveryMode, this.priority, this.timeToLive);
    }

    public void publish(Topic topic, Message message) throws MessageFormatException, JMSException {
        this.publish(topic, message, this.deliveryMode, this.priority, this.timeToLive);
    }

    public void publish(Message message, int deliveryMode, int priority, long timeToLive) throws MessageFormatException, JMSException {
        this.publish(this.topic, message, deliveryMode, priority, timeToLive);
    }

    public void publish(Topic topic, Message message, int deliveryMode, int priority, long timeToLive) throws MessageFormatException, JMSException {
        try {
            this.session.publish(topic, (EvermindMessage)message);
        }
        catch (ClassCastException e) {
            throw new MessageFormatException("Illegal message");
        }
    }
}

