/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.multicastjms;

import com.evermind.server.multicastjms.JMSServer;
import com.evermind.server.multicastjms.LocalTopicConnection;
import com.evermind.server.multicastjms.MulticastTopicConnection;
import com.evermind.server.multicastjms.PointcastTopicConnection;
import com.evermind.server.multicastjms.deployment.TopicConnectionFactoryConfig;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;

public class EvermindTopicConnectionFactory
implements TopicConnectionFactory,
Serializable {
    protected InetAddress address;
    protected int port;
    protected long id;
    protected String username;
    protected String password;
    protected transient JMSServer server;

    public EvermindTopicConnectionFactory(TopicConnectionFactoryConfig config, JMSServer server) throws UnknownHostException, InstantiationException {
        String configHost = config.getHost();
        if (configHost == null) {
            configHost = server.getConfig().getAddress().getHostAddress();
        }
        this.address = configHost.equals("0.0.0.0") ? InetAddress.getByName("127.0.0.1") : InetAddress.getByName(configHost);
        this.port = config.getPort();
        this.username = config.getUsername();
        this.password = config.getPassword();
        this.id = config.getId();
        this.server = server;
    }

    public EvermindTopicConnectionFactory(InetAddress address, int port, int id, String username, String password, JMSServer server) {
        this(address, port, id, username, password);
        this.server = server;
    }

    public EvermindTopicConnectionFactory(InetAddress address, int port, int id, String username, String password) {
        this.address = address;
        this.port = port;
        this.id = id;
        this.username = username;
        this.password = password;
    }

    public void setServer(JMSServer server) {
        this.server = server;
    }

    public TopicConnection createTopicConnection() throws JMSException {
        try {
            if (this.server != null && (this.address.equals(this.server.getConfig().getAddress()) || this.address.equals(InetAddress.getByName("127.0.0.1")) && this.server.getConfig().getAddress().equals(InetAddress.getByName("0.0.0.0"))) && this.port == this.server.getConfig().getPort()) {
                return new LocalTopicConnection(this.server);
            }
        }
        catch (IOException e) {
        }
        catch (InstantiationException e) {
            // empty catch block
        }
        try {
            if (this.address.isMulticastAddress()) {
                return new MulticastTopicConnection(this.address, this.port, this.id);
            }
            return new PointcastTopicConnection(this.address, this.port, this.username, this.password);
        }
        catch (IOException e) {
            throw new JMSException("Unable to connect");
        }
    }

    public TopicConnection createTopicConnection(String username, String password) throws JMSException {
        try {
            if (this.server != null && (this.address.equals(this.server.getConfig().getAddress()) || this.address.equals(InetAddress.getByName("127.0.0.1")) && this.server.getConfig().getAddress().equals(InetAddress.getByName("0.0.0.0")) && this.port == this.server.getConfig().getPort())) {
                return new LocalTopicConnection(this.server);
            }
        }
        catch (IOException e) {
        }
        catch (InstantiationException e) {
            // empty catch block
        }
        try {
            if (this.address.isMulticastAddress()) {
                return new MulticastTopicConnection(this.address, this.port, this.id);
            }
            return new PointcastTopicConnection(this.address, this.port, username, password);
        }
        catch (IOException e) {
            throw new JMSException("Unable to connect");
        }
    }

    public Connection createConnection() throws JMSException {
        throw new JMSException("JMS 1.1 features not supported");
    }

    public Connection createConnection(String user, String pwd) throws JMSException {
        throw new JMSException("JMS 1.1 features not supported");
    }
}

