/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.multicastjms;

import com.evermind.server.multicastjms.EvermindConnection;
import com.evermind.server.multicastjms.EvermindMessage;
import com.evermind.server.multicastjms.EvermindTopicConnectionConsumer;
import com.evermind.server.multicastjms.EvermindTopicSession;
import com.evermind.server.multicastjms.JMSCommands;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import javax.jms.ConnectionConsumer;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;

public abstract class EvermindTopicConnection
extends EvermindConnection
implements TopicConnection,
JMSCommands,
Runnable {
    protected InetAddress address;
    protected int port;
    protected List sessions = new ArrayList();
    protected boolean alive = false;
    protected String disconnectedMessage;

    protected EvermindTopicConnection(InetAddress address, int port) throws IOException {
        this.address = address;
        this.port = port;
    }

    public synchronized void close() throws JMSException {
        for (int i = 0; i < this.sessions.size(); ++i) {
            EvermindTopicSession session = (EvermindTopicSession)this.sessions.get(i);
            session.close();
        }
        super.close();
        this.stop();
    }

    protected void notifySessions(String topicName, EvermindMessage message) {
        if (!this.started) {
            return;
        }
        for (int i = 0; i < this.sessions.size(); ++i) {
            EvermindTopicSession session = (EvermindTopicSession)this.sessions.get(i);
            session.addMessage(topicName, message);
        }
    }

    public synchronized TopicSession createTopicSession(boolean transacted, int acknowledgeMode) throws JMSException {
        EvermindTopicSession session = new EvermindTopicSession(this, transacted, acknowledgeMode);
        this.sessions.add(session);
        return session;
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String messageSelector, ServerSessionPool sessionPool, int maxMessages) {
        return new EvermindTopicConnectionConsumer(this, topic, messageSelector, sessionPool, maxMessages);
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) {
        return new EvermindTopicConnectionConsumer(this, topic, messageSelector, sessionPool, maxMessages);
    }

    protected abstract void send(String var1, EvermindMessage var2) throws IOException, JMSException;

    protected abstract void distribute(String var1, EvermindMessage var2) throws IOException, JMSException;

    protected abstract void registerTopicInterest(String var1) throws JMSException;
}

