/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.multicastjms;

import com.evermind.io.IOUtils;
import com.evermind.server.multicastjms.EvermindMessage;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import javax.jms.TextMessage;

public class EvermindTextMessage
extends EvermindMessage
implements TextMessage {
    private String value;
    private boolean readMode;

    public EvermindTextMessage() {
    }

    public EvermindTextMessage(String text) {
        this.value = text;
    }

    public int getTypeID() {
        return 5;
    }

    public void read(InputStream in, DataInputStream dataIn) throws IOException {
        super.read(in, dataIn);
        this.value = IOUtils.readLongUTF(in, true);
        this.readMode = true;
    }

    public void write(OutputStream out, DataOutputStream dataOut) throws IOException {
        super.write(out, dataOut);
        IOUtils.writeLongUTF(out, this.value, true);
        this.readMode = true;
    }

    public void clearBody() {
        this.value = null;
        this.readMode = false;
    }

    public void setText(String value) throws MessageNotWriteableException {
        if (this.readMode) {
            throw new MessageNotWriteableException("In read mode");
        }
        this.value = value;
    }

    public String getText() throws MessageNotReadableException {
        return this.value;
    }

    public EvermindMessage cloneMessage() {
        return this.clone(new EvermindTextMessage());
    }

    public EvermindTextMessage clone(EvermindTextMessage other) {
        other.value = this.value;
        other.readMode = true;
        return (EvermindTextMessage)super.clone(other);
    }
}

