/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.multicastjms;

import com.evermind.server.multicastjms.EvermindQueueConnection;
import com.evermind.server.multicastjms.JMSServer;
import com.evermind.server.multicastjms.LocalQueueConnection;
import com.evermind.server.multicastjms.deployment.QueueConnectionFactoryConfig;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;

public class EvermindQueueConnectionFactory
implements QueueConnectionFactory,
Serializable {
    protected InetAddress address;
    protected int port;
    protected String username;
    protected String password;
    protected transient JMSServer server;

    public EvermindQueueConnectionFactory(QueueConnectionFactoryConfig config, JMSServer server) throws UnknownHostException, InstantiationException {
        String configHost = config.getHost();
        if (configHost == null) {
            configHost = server.getConfig().getAddress().getHostAddress();
        }
        this.address = configHost.equals("0.0.0.0") ? InetAddress.getByName("127.0.0.1") : InetAddress.getByName(configHost);
        this.port = config.getPort();
        this.username = config.getUsername();
        this.password = config.getPassword();
        this.server = server;
    }

    public EvermindQueueConnectionFactory(InetAddress address, int port, String username, String password) {
        this.address = address;
        this.port = port;
        this.username = username;
        this.password = password;
    }

    public void setServer(JMSServer server) {
        this.server = server;
    }

    public QueueConnection createQueueConnection() throws JMSException {
        try {
            if (this.server != null && (this.address.equals(this.server.getConfig().getAddress()) || this.address.equals(InetAddress.getByName("127.0.0.1")) && this.server.getConfig().getAddress().equals(InetAddress.getByName("0.0.0.0")) && this.port == this.server.getConfig().getPort())) {
                return new LocalQueueConnection(this.server);
            }
        }
        catch (UnknownHostException e) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        return new EvermindQueueConnection(this.address, this.port, this.username, this.password);
    }

    public QueueConnection createQueueConnection(String username, String password) throws JMSException {
        try {
            if (this.server != null && (this.address.equals(this.server.getConfig().getAddress()) || this.address.equals(InetAddress.getByName("127.0.0.1")) && this.server.getConfig().getAddress().equals(InetAddress.getByName("0.0.0.0")) && this.port == this.server.getConfig().getPort())) {
                return new LocalQueueConnection(this.server);
            }
        }
        catch (UnknownHostException e) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        return new EvermindQueueConnection(this.address, this.port, username, password);
    }

    public Connection createConnection() throws JMSException {
        throw new JMSException("JMS 1.1 features not supported");
    }

    public Connection createConnection(String user, String pwd) throws JMSException {
        throw new JMSException("JMS 1.1 features not supported");
    }
}

