/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.multicastjms;

import com.evermind.server.ejb.EJBInputStream;
import com.evermind.server.multicastjms.EvermindMessage;
import com.evermind.util.JMSProperties;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotWriteableException;
import javax.jms.ObjectMessage;

public class EvermindObjectMessage
extends EvermindMessage
implements ObjectMessage {
    Serializable object;
    byte[] data;
    boolean readMode;

    public EvermindObjectMessage() {
    }

    public EvermindObjectMessage(Serializable object) {
        this.object = object;
    }

    public void setObject(Serializable object) throws MessageNotWriteableException {
        if (this.readMode) {
            throw new MessageNotWriteableException("In read mode");
        }
        this.object = object;
        this.data = null;
    }

    public int getTypeID() {
        return 1;
    }

    public void read(InputStream in, DataInputStream dataIn) throws IOException {
        super.read(in, dataIn);
        int length = dataIn.readInt();
        this.data = new byte[length];
        in.read(this.data);
        this.readMode = true;
    }

    public void write(OutputStream out, DataOutputStream dataOut) throws IOException {
        super.write(out, dataOut);
        if (this.data == null) {
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            new ObjectOutputStream(byteOut).writeObject(this.object);
            this.data = byteOut.toByteArray();
        }
        dataOut.writeInt(this.data.length);
        out.write(this.data);
        this.readMode = true;
    }

    public Serializable getObject() throws MessageFormatException {
        if (this.object == null && this.data != null) {
            try {
                this.object = (Serializable)new EJBInputStream((InputStream)new ByteArrayInputStream(this.data), Thread.currentThread().getContextClassLoader()).readObject();
            }
            catch (Exception e) {
                if (JMSProperties.getJMSDebug()) {
                    System.err.println("Error deserializing:");
                    e.printStackTrace();
                }
                throw new MessageFormatException("Unable to deserialize object: " + e);
            }
        }
        return this.object;
    }

    public void clearBody() {
        this.readMode = false;
        this.object = null;
        this.data = null;
    }

    public EvermindMessage cloneMessage() {
        return this.clone(new EvermindObjectMessage());
    }

    public EvermindObjectMessage clone(EvermindObjectMessage other) {
        other.object = this.object;
        other.data = this.data;
        other.readMode = true;
        return (EvermindObjectMessage)super.clone(other);
    }
}

