/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.multicastjms;

import com.evermind.server.multicastjms.EvermindMessage;
import com.evermind.server.multicastjms.JMSCommands;
import com.evermind.server.multicastjms.Property;
import com.evermind.server.multicastjms.PropertyMap;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;

public class EvermindMapMessage
extends EvermindMessage
implements MapMessage,
JMSCommands {
    private PropertyMap map = new PropertyMap();
    private boolean readMode;

    public int getTypeID() {
        return 4;
    }

    public void clearBody() {
        this.map = new PropertyMap();
        this.readMode = false;
    }

    public void read(InputStream in, DataInputStream dataIn) throws IOException {
        super.read(in, dataIn);
        this.map.read(in, dataIn);
        this.readMode = true;
    }

    public void write(OutputStream out, DataOutputStream dataOut) throws IOException {
        super.write(out, dataOut);
        this.map.write(out, dataOut);
        this.readMode = true;
    }

    public Object getObject(String name) throws JMSException {
        if (!this.readMode) {
            throw new MessageNotReadableException("In write mode");
        }
        return this.map.getObjectProperty(name);
    }

    public byte getByte(String name) throws JMSException {
        if (!this.readMode) {
            throw new MessageNotReadableException("In write mode");
        }
        return this.map.getByteProperty(name);
    }

    public short getShort(String name) throws JMSException {
        if (!this.readMode) {
            throw new MessageNotReadableException("In write mode");
        }
        return this.map.getShortProperty(name);
    }

    public int getInt(String name) throws JMSException {
        if (!this.readMode) {
            throw new MessageNotReadableException("In write mode");
        }
        return this.map.getIntProperty(name);
    }

    public long getLong(String name) throws JMSException {
        if (!this.readMode) {
            throw new MessageNotReadableException("In write mode");
        }
        return this.map.getLongProperty(name);
    }

    public byte[] getBytes(String name) throws JMSException {
        if (!this.readMode) {
            throw new MessageNotReadableException("In write mode");
        }
        return this.map.getBytesProperty(name);
    }

    public float getFloat(String name) throws JMSException {
        if (!this.readMode) {
            throw new MessageNotReadableException("In write mode");
        }
        return this.map.getFloatProperty(name);
    }

    public boolean getBoolean(String name) throws JMSException {
        if (!this.readMode) {
            throw new MessageNotReadableException("In write mode");
        }
        return this.map.getBooleanProperty(name);
    }

    public double getDouble(String name) throws JMSException {
        if (!this.readMode) {
            throw new MessageNotReadableException("In write mode");
        }
        return this.map.getDoubleProperty(name);
    }

    public String getString(String name) throws JMSException {
        if (!this.readMode) {
            throw new MessageNotReadableException("In write mode");
        }
        return this.map.getStringProperty(name);
    }

    public char getChar(String name) throws JMSException {
        if (!this.readMode) {
            throw new MessageNotReadableException("In write mode");
        }
        return this.map.getCharProperty(name);
    }

    public void setLong(String name, long value) throws MessageNotReadableException {
        if (this.readMode) {
            throw new MessageNotReadableException("In read mode");
        }
        this.map.setLongProperty(name, value);
    }

    public void setInt(String name, int value) throws MessageNotReadableException {
        if (this.readMode) {
            throw new MessageNotReadableException("In read mode");
        }
        this.map.setIntProperty(name, value);
    }

    public void setChar(String name, char value) throws MessageNotReadableException {
        if (this.readMode) {
            throw new MessageNotReadableException("In read mode");
        }
        this.map.setCharProperty(name, value);
    }

    public void setDouble(String name, double value) throws MessageNotReadableException {
        if (this.readMode) {
            throw new MessageNotReadableException("In read mode");
        }
        this.map.setDoubleProperty(name, value);
    }

    public void setFloat(String name, float value) throws MessageNotReadableException {
        if (this.readMode) {
            throw new MessageNotReadableException("In read mode");
        }
        this.map.setFloatProperty(name, value);
    }

    public void setBoolean(String name, boolean value) throws MessageNotWriteableException {
        if (this.readMode) {
            throw new MessageNotWriteableException("In read mode");
        }
        this.map.setBooleanProperty(name, value);
    }

    public void setByte(String name, byte value) throws MessageNotWriteableException {
        if (this.readMode) {
            throw new MessageNotWriteableException("In read mode");
        }
        this.map.setByteProperty(name, value);
    }

    public void setString(String name, String value) throws MessageNotWriteableException {
        if (this.readMode) {
            throw new MessageNotWriteableException("In read mode");
        }
        this.map.setStringProperty(name, value);
    }

    public void setObject(String name, Object value) throws MessageNotWriteableException, MessageFormatException {
        if (this.readMode) {
            throw new MessageNotWriteableException("In read mode");
        }
        this.map.setObjectProperty(name, value);
    }

    public void setShort(String name, short value) throws MessageNotWriteableException {
        if (this.readMode) {
            throw new MessageNotWriteableException("In read mode");
        }
        this.map.setShortProperty(name, value);
    }

    public void setBytes(String name, byte[] value, int start, int end) throws MessageNotWriteableException {
        if (this.readMode) {
            throw new MessageNotWriteableException("In read mode");
        }
        this.map.setBytesProperty(name, value, start, end);
    }

    public void setBytes(String name, byte[] value) throws MessageNotWriteableException {
        if (this.readMode) {
            throw new MessageNotWriteableException("In read mode");
        }
        this.map.setBytesProperty(name, value);
    }

    public Enumeration getMapNames() throws MessageNotReadableException {
        if (!this.readMode) {
            throw new MessageNotReadableException("In write mode");
        }
        return this.map.getPropertyNames();
    }

    public boolean itemExists(String name) {
        return this.map.propertyExists(name);
    }

    private void addMapping(Property property) {
        this.map.addProperty(property);
    }

    int getMappingCount() {
        return this.map.getPropertyCount();
    }

    Property[] getMappings() {
        return this.map.getProperties();
    }

    public EvermindMessage cloneMessage() {
        return this.clone(new EvermindMapMessage());
    }

    public EvermindMapMessage clone(EvermindMapMessage other) {
        other.properties = this.properties;
        other.readMode = true;
        return (EvermindMapMessage)super.clone(other);
    }
}

