/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms.filter;

import com.evermind.server.jms.filter.Apply;
import com.evermind.server.jms.filter.BooleanExpression;
import com.evermind.server.jms.filter.GeneralException;
import com.evermind.server.jms.filter.IStringExpression;
import com.evermind.server.jms.filter.QueryTypeException;
import javax.jms.Message;

class StringNeqExpr
extends BooleanExpression {
    StringNeqExpr(IStringExpression leftOp, IStringExpression rightOp) {
        super("(" + leftOp.toString() + " <> " + rightOp.toString() + ")", leftOp, rightOp);
    }

    public void eval(Message m) throws QueryTypeException {
        this.m_null = false;
        this.m_val = false;
        if (this.m_leftExpr.isNull() || this.m_rightExpr.isNull()) {
            this.m_null = true;
        } else {
            String lop = ((IStringExpression)this.m_leftExpr).getStringVal();
            this.m_val = !lop.equals(((IStringExpression)this.m_rightExpr).getStringVal());
        }
    }

    public boolean equals(Object expr) {
        if (expr instanceof StringNeqExpr) {
            return this.m_leftExpr.equals(((StringNeqExpr)expr).m_leftExpr) && this.m_rightExpr.equals(((StringNeqExpr)expr).m_rightExpr);
        }
        return false;
    }

    public Object depthFirstApply(Apply app) throws GeneralException {
        this.m_leftExpr = (IStringExpression)this.m_leftExpr.depthFirstApply(app);
        this.m_rightExpr = (IStringExpression)this.m_rightExpr.depthFirstApply(app);
        return app.apply(this);
    }
}

