/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms.filter;

import com.evermind.server.jms.filter.AndExpression;
import com.evermind.server.jms.filter.BooleanEqExpr;
import com.evermind.server.jms.filter.BooleanNeqExpr;
import com.evermind.server.jms.filter.DoubleAdd;
import com.evermind.server.jms.filter.DoubleDiv;
import com.evermind.server.jms.filter.DoubleEqExpr;
import com.evermind.server.jms.filter.DoubleGtEqExpr;
import com.evermind.server.jms.filter.DoubleGtExpr;
import com.evermind.server.jms.filter.DoubleLtEqExpr;
import com.evermind.server.jms.filter.DoubleLtExpr;
import com.evermind.server.jms.filter.DoubleMult;
import com.evermind.server.jms.filter.DoubleNeqExpr;
import com.evermind.server.jms.filter.DoubleSub;
import com.evermind.server.jms.filter.DynamicAdd;
import com.evermind.server.jms.filter.DynamicDiv;
import com.evermind.server.jms.filter.DynamicEqExpr;
import com.evermind.server.jms.filter.DynamicGtEqExpr;
import com.evermind.server.jms.filter.DynamicGtExpr;
import com.evermind.server.jms.filter.DynamicLtEqExpr;
import com.evermind.server.jms.filter.DynamicLtExpr;
import com.evermind.server.jms.filter.DynamicMult;
import com.evermind.server.jms.filter.DynamicNeqExpr;
import com.evermind.server.jms.filter.DynamicSub;
import com.evermind.server.jms.filter.FloatAdd;
import com.evermind.server.jms.filter.FloatDiv;
import com.evermind.server.jms.filter.FloatEqExpr;
import com.evermind.server.jms.filter.FloatGtEqExpr;
import com.evermind.server.jms.filter.FloatGtExpr;
import com.evermind.server.jms.filter.FloatLtEqExpr;
import com.evermind.server.jms.filter.FloatLtExpr;
import com.evermind.server.jms.filter.FloatMult;
import com.evermind.server.jms.filter.FloatNeqExpr;
import com.evermind.server.jms.filter.FloatSub;
import com.evermind.server.jms.filter.IBooleanExpression;
import com.evermind.server.jms.filter.IDoubleExpression;
import com.evermind.server.jms.filter.IDynamicExpression;
import com.evermind.server.jms.filter.IExpression;
import com.evermind.server.jms.filter.IFloatExpression;
import com.evermind.server.jms.filter.IIntegerExpression;
import com.evermind.server.jms.filter.ILongExpression;
import com.evermind.server.jms.filter.IStringExpression;
import com.evermind.server.jms.filter.IntegerAdd;
import com.evermind.server.jms.filter.IntegerDiv;
import com.evermind.server.jms.filter.IntegerEqExpr;
import com.evermind.server.jms.filter.IntegerGtEqExpr;
import com.evermind.server.jms.filter.IntegerGtExpr;
import com.evermind.server.jms.filter.IntegerLtEqExpr;
import com.evermind.server.jms.filter.IntegerLtExpr;
import com.evermind.server.jms.filter.IntegerMult;
import com.evermind.server.jms.filter.IntegerNeqExpr;
import com.evermind.server.jms.filter.IntegerSub;
import com.evermind.server.jms.filter.LongAdd;
import com.evermind.server.jms.filter.LongDiv;
import com.evermind.server.jms.filter.LongEqExpr;
import com.evermind.server.jms.filter.LongGtEqExpr;
import com.evermind.server.jms.filter.LongGtExpr;
import com.evermind.server.jms.filter.LongLtEqExpr;
import com.evermind.server.jms.filter.LongLtExpr;
import com.evermind.server.jms.filter.LongMult;
import com.evermind.server.jms.filter.LongNeqExpr;
import com.evermind.server.jms.filter.LongSub;
import com.evermind.server.jms.filter.NotExpression;
import com.evermind.server.jms.filter.OrExpression;
import com.evermind.server.jms.filter.PNode;
import com.evermind.server.jms.filter.Query;
import com.evermind.server.jms.filter.QuerySemanticException;
import com.evermind.server.jms.filter.StringEqExpr;
import com.evermind.server.jms.filter.StringNeqExpr;
import com.evermind.server.jms.filter.WrapDynamicExpression;

class PBinaryExpr
extends PNode {
    PNode m_leftExpr;
    PNode m_rightExpr;
    int m_op;

    PBinaryExpr(PNode leftExpr, PNode rightExpr, int op) {
        this.m_leftExpr = leftExpr;
        this.m_rightExpr = rightExpr;
        this.m_op = op;
    }

    IExpression convert(Query q) throws QuerySemanticException {
        IExpression lexpr = this.m_leftExpr.convert(q);
        IExpression rexpr = this.m_rightExpr.convert(q);
        if (lexpr.typeOf() == 1 || rexpr.typeOf() == 1) {
            return this.convertBoolean(lexpr, rexpr);
        }
        if (lexpr.typeOf() == 3 || rexpr.typeOf() == 3) {
            return this.convertString(lexpr, rexpr);
        }
        if (lexpr.typeOf() == 6 || rexpr.typeOf() == 6) {
            return this.convertDouble(lexpr, rexpr);
        }
        if (lexpr.typeOf() == 7 || rexpr.typeOf() == 7) {
            return this.convertDynamic(lexpr, rexpr);
        }
        if (lexpr.typeOf() == 5 || rexpr.typeOf() == 5) {
            return this.convertFloat(lexpr, rexpr);
        }
        if (lexpr.typeOf() == 4 || rexpr.typeOf() == 4) {
            return this.convertLong(lexpr, rexpr);
        }
        if (lexpr.typeOf() == 2 || rexpr.typeOf() == 2) {
            return this.convertInt(lexpr, rexpr);
        }
        throw Query.semanticError("the expression: '" + this + "' : is not supported ");
    }

    IExpression convertBoolean(IExpression lexpr, IExpression rexpr) throws QuerySemanticException {
        if (lexpr.typeOf() != 1 && lexpr.typeOf() != 7) {
            throw new QuerySemanticException(" cannot perform boolean operations with non-boolean types: " + this);
        }
        if (rexpr.typeOf() != 1 && rexpr.typeOf() != 7) {
            throw new QuerySemanticException(" cannot perform boolean operations with non-boolean types: " + this);
        }
        IBooleanExpression lop = (IBooleanExpression)lexpr;
        IBooleanExpression rop = (IBooleanExpression)rexpr;
        switch (this.m_op) {
            case 1: {
                return new AndExpression(lop, rop);
            }
            case 2: {
                return new OrExpression(lop, rop);
            }
            case 10: {
                return new BooleanEqExpr(lop, rop);
            }
            case 13: {
                return new BooleanNeqExpr(lop, rop);
            }
        }
        throw Query.semanticError("Operator '" + Query.tokenToString(this.m_op) + "' not supported for Boolean expressions" + this);
    }

    IExpression convertString(IExpression lexpr, IExpression rexpr) throws QuerySemanticException {
        if (lexpr.typeOf() != 3 && lexpr.typeOf() != 7) {
            throw new QuerySemanticException(" cannot perform string operations with non-string types: " + this);
        }
        if (rexpr.typeOf() != 3 && rexpr.typeOf() != 7) {
            throw new QuerySemanticException(" cannot perform string operations with non-string types: " + this);
        }
        IStringExpression lop = (IStringExpression)lexpr;
        IStringExpression rop = (IStringExpression)rexpr;
        switch (this.m_op) {
            case 13: {
                return new StringNeqExpr(lop, rop);
            }
            case 10: {
                return new StringEqExpr(lop, rop);
            }
        }
        throw Query.semanticError("Operator '" + Query.tokenToString(this.m_op) + "' not supported for String expressions: " + this);
    }

    IExpression convertDouble(IExpression lexpr, IExpression rexpr) throws QuerySemanticException {
        if (lexpr.typeOf() != 2 && lexpr.typeOf() != 4 && lexpr.typeOf() != 5 && lexpr.typeOf() != 6 && lexpr.typeOf() != 7) {
            throw new QuerySemanticException(" cannot perform operation for " + lexpr.toString() + " when used with a double in: " + this);
        }
        if (rexpr.typeOf() != 2 && rexpr.typeOf() != 4 && rexpr.typeOf() != 5 && rexpr.typeOf() != 6 && rexpr.typeOf() != 7) {
            throw new QuerySemanticException(" cannot perform operation for " + rexpr.toString() + " when used with a double in: " + this);
        }
        IDoubleExpression lop = (IDoubleExpression)lexpr;
        IDoubleExpression rop = (IDoubleExpression)rexpr;
        switch (this.m_op) {
            case 9: {
                return new DoubleGtExpr(lop, rop);
            }
            case 8: {
                return new DoubleLtExpr(lop, rop);
            }
            case 12: {
                return new DoubleGtEqExpr(lop, rop);
            }
            case 11: {
                return new DoubleLtEqExpr(lop, rop);
            }
            case 10: {
                return new DoubleEqExpr(lop, rop);
            }
            case 17: {
                return new DoubleAdd(lop, rop);
            }
            case 19: {
                return new DoubleMult(lop, rop);
            }
            case 18: {
                return new DoubleSub(lop, rop);
            }
            case 20: {
                return new DoubleDiv(lop, rop);
            }
            case 13: {
                return new DoubleNeqExpr(lop, rop);
            }
        }
        throw Query.semanticError("Operator '" + Query.tokenToString(this.m_op) + "' not supported for Double expressions in: " + this);
    }

    IExpression convertFloat(IExpression lexpr, IExpression rexpr) throws QuerySemanticException {
        if (lexpr.typeOf() != 2 && lexpr.typeOf() != 4 && lexpr.typeOf() != 5) {
            throw new QuerySemanticException(" cannot perform operation for " + lexpr.toString() + " when used with a float in: " + this);
        }
        if (rexpr.typeOf() != 2 && rexpr.typeOf() != 4 && rexpr.typeOf() != 5) {
            throw new QuerySemanticException(" cannot perform operation for " + rexpr.toString() + " when used with a float in: " + this);
        }
        IFloatExpression lop = (IFloatExpression)lexpr;
        IFloatExpression rop = (IFloatExpression)rexpr;
        switch (this.m_op) {
            case 9: {
                return new FloatGtExpr(lop, rop);
            }
            case 8: {
                return new FloatLtExpr(lop, rop);
            }
            case 12: {
                return new FloatGtEqExpr(lop, rop);
            }
            case 11: {
                return new FloatLtEqExpr(lop, rop);
            }
            case 10: {
                return new FloatEqExpr(lop, rop);
            }
            case 17: {
                return new FloatAdd(lop, rop);
            }
            case 19: {
                return new FloatMult(lop, rop);
            }
            case 18: {
                return new FloatSub(lop, rop);
            }
            case 20: {
                return new FloatDiv(lop, rop);
            }
            case 13: {
                return new FloatNeqExpr(lop, rop);
            }
        }
        throw Query.semanticError("Operator '" + Query.tokenToString(this.m_op) + "' not supported for Float expressions in: " + this);
    }

    IExpression convertLong(IExpression lexpr, IExpression rexpr) throws QuerySemanticException {
        if (lexpr.typeOf() != 2 && lexpr.typeOf() != 4) {
            throw new QuerySemanticException(" cannot perform operation for " + lexpr.toString() + " when used with a long in: " + this);
        }
        if (rexpr.typeOf() != 2 && rexpr.typeOf() != 4) {
            throw new QuerySemanticException(" cannot perform operation for " + rexpr.toString() + " when used with a long in: " + this);
        }
        ILongExpression lop = (ILongExpression)lexpr;
        ILongExpression rop = (ILongExpression)rexpr;
        switch (this.m_op) {
            case 9: {
                return new LongGtExpr(lop, rop);
            }
            case 8: {
                return new LongLtExpr(lop, rop);
            }
            case 12: {
                return new LongGtEqExpr(lop, rop);
            }
            case 11: {
                return new LongLtEqExpr(lop, rop);
            }
            case 10: {
                return new LongEqExpr(lop, rop);
            }
            case 17: {
                return new LongAdd(lop, rop);
            }
            case 19: {
                return new LongMult(lop, rop);
            }
            case 18: {
                return new LongSub(lop, rop);
            }
            case 20: {
                return new LongDiv(lop, rop);
            }
            case 13: {
                return new LongNeqExpr(lop, rop);
            }
        }
        throw Query.semanticError("Operator '" + Query.tokenToString(this.m_op) + "' not supported for Long expressions in: " + this);
    }

    IExpression convertInt(IExpression lexpr, IExpression rexpr) throws QuerySemanticException {
        if (lexpr.typeOf() != 2) {
            throw new QuerySemanticException(" cannot perform operation for " + lexpr.toString() + " when used with a int in: " + this);
        }
        if (rexpr.typeOf() != 2) {
            throw new QuerySemanticException(" cannot perform operation for " + rexpr.toString() + " when used with a int in: " + this);
        }
        IIntegerExpression lop = (IIntegerExpression)lexpr;
        IIntegerExpression rop = (IIntegerExpression)rexpr;
        switch (this.m_op) {
            case 9: {
                return new IntegerGtExpr(lop, rop);
            }
            case 8: {
                return new IntegerLtExpr(lop, rop);
            }
            case 12: {
                return new IntegerGtEqExpr(lop, rop);
            }
            case 11: {
                return new IntegerLtEqExpr(lop, rop);
            }
            case 10: {
                return new IntegerEqExpr(lop, rop);
            }
            case 17: {
                return new IntegerAdd(lop, rop);
            }
            case 19: {
                return new IntegerMult(lop, rop);
            }
            case 18: {
                return new IntegerSub(lop, rop);
            }
            case 20: {
                return new IntegerDiv(lop, rop);
            }
            case 13: {
                return new IntegerNeqExpr(lop, rop);
            }
        }
        throw Query.semanticError("Operator '" + Query.tokenToString(this.m_op) + "' not supported for Integer expressions in: " + this);
    }

    IExpression convertDynamic(IExpression lexpr, IExpression rexpr) throws QuerySemanticException {
        IDynamicExpression lDyn = null;
        IDynamicExpression rDyn = null;
        lDyn = lexpr instanceof IDynamicExpression ? (IDynamicExpression)lexpr : new WrapDynamicExpression(lexpr);
        rDyn = rexpr instanceof IDynamicExpression ? (IDynamicExpression)rexpr : new WrapDynamicExpression(rexpr);
        switch (this.m_op) {
            case 9: {
                return new DynamicGtExpr(lDyn, rDyn);
            }
            case 8: {
                return new DynamicLtExpr(lDyn, rDyn);
            }
            case 12: {
                return new DynamicGtEqExpr(lDyn, rDyn);
            }
            case 11: {
                return new DynamicLtEqExpr(lDyn, rDyn);
            }
            case 10: {
                return new DynamicEqExpr(lDyn, rDyn);
            }
            case 17: {
                return new DynamicAdd(lDyn, rDyn);
            }
            case 19: {
                return new DynamicMult(lDyn, rDyn);
            }
            case 18: {
                return new DynamicSub(lDyn, rDyn);
            }
            case 20: {
                return new DynamicDiv(lDyn, rDyn);
            }
            case 13: {
                return new DynamicNeqExpr(lDyn, rDyn);
            }
            case 2: {
                return new OrExpression(lDyn, rDyn);
            }
            case 1: {
                return new AndExpression(lDyn, rDyn);
            }
            case 3: {
                return new NotExpression(lDyn);
            }
        }
        throw Query.semanticError("Operator '" + Query.tokenToString(this.m_op) + "' not supported for dynamic expressions in: " + this);
    }

    public String toString() {
        return "(" + this.m_leftExpr.toString() + " " + Query.tokenToString(this.m_op) + " " + this.m_rightExpr.toString() + ")";
    }
}

