/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms.filter;

import com.evermind.server.jms.filter.Query;
import com.evermind.server.jms.filter.QuerySyntaxException;

class InexactParser {
    private int index;

    InexactParser() {
    }

    int getIndex() {
        return this.index;
    }

    Object parse(String buffer, int start, int length) throws QuerySyntaxException {
        Object obj = this.inexact1(buffer, start, length);
        if (obj != null) {
            return obj;
        }
        obj = this.inexact2(buffer, start, length);
        if (obj != null) {
            return obj;
        }
        obj = this.inexact3(buffer, start, length);
        if (obj != null) {
            return obj;
        }
        return this.inexact4(buffer, start, length);
    }

    private Object inexact1(String buffer, int start, int length) throws QuerySyntaxException {
        if (start >= length) {
            return null;
        }
        int state = 0;
        this.index = start;
        while (this.index < length) {
            char curChar = buffer.charAt(this.index);
            switch (state) {
                case 0: {
                    if (curChar == '-' || curChar == '+') {
                        state = 1;
                        break;
                    }
                    if (Query.isAsciiDigit(curChar, 10) != -1) {
                        state = 2;
                        break;
                    }
                    return null;
                }
                case 1: {
                    if (Query.isAsciiDigit(curChar, 10) != -1) {
                        state = 2;
                        break;
                    }
                    return null;
                }
                case 2: {
                    if (Query.isAsciiDigit(curChar, 10) != -1) {
                        state = 2;
                        break;
                    }
                    if (curChar == '.') {
                        state = 3;
                        break;
                    }
                    return null;
                }
                case 3: {
                    if (Query.isAsciiDigit(curChar, 10) != -1) {
                        state = 4;
                        break;
                    }
                    if (curChar == 'e' || curChar == 'E') {
                        state = 5;
                        break;
                    }
                    if (curChar == 'f' || curChar == 'F') {
                        ++this.index;
                        return this.extractFloat(start, this.index - 1, buffer);
                    }
                    if (curChar == 'd' || curChar == 'D') {
                        ++this.index;
                        return this.extractDouble(start, this.index - 1, buffer);
                    }
                    return this.extractDouble(start, this.index, buffer);
                }
                case 4: {
                    if (Query.isAsciiDigit(curChar, 10) != -1) {
                        state = 4;
                        break;
                    }
                    if (curChar == 'e' || curChar == 'E') {
                        state = 5;
                        break;
                    }
                    if (curChar == 'f' || curChar == 'F') {
                        ++this.index;
                        return this.extractFloat(start, this.index - 1, buffer);
                    }
                    if (curChar == 'd' || curChar == 'D') {
                        ++this.index;
                        return this.extractDouble(start, this.index - 1, buffer);
                    }
                    return this.extractDouble(start, this.index, buffer);
                }
                case 5: {
                    if (curChar == '+' || curChar == '-') {
                        state = 6;
                        break;
                    }
                    if (Query.isAsciiDigit(curChar, 10) != -1) {
                        state = 7;
                        break;
                    }
                    return null;
                }
                case 6: {
                    if (Query.isAsciiDigit(curChar, 10) != -1) {
                        state = 7;
                        break;
                    }
                    return null;
                }
                case 7: {
                    if (Query.isAsciiDigit(curChar, 10) != -1) {
                        state = 7;
                        break;
                    }
                    if (curChar == 'f' || curChar == 'F') {
                        ++this.index;
                        return this.extractFloat(start, this.index - 1, buffer);
                    }
                    if (curChar == 'd' || curChar == 'D') {
                        ++this.index;
                        return this.extractDouble(start, this.index - 1, buffer);
                    }
                    return this.extractDouble(start, this.index, buffer);
                }
                default: {
                    return null;
                }
            }
            ++this.index;
        }
        switch (state) {
            case 3: 
            case 4: 
            case 7: {
                return this.extractDouble(start, this.index, buffer);
            }
        }
        return null;
    }

    private Object inexact2(String buffer, int start, int length) throws QuerySyntaxException {
        if (start >= length) {
            return null;
        }
        int state = 0;
        this.index = start;
        while (this.index < length) {
            char curChar = buffer.charAt(this.index);
            switch (state) {
                case 0: {
                    if (curChar == '+' || curChar == '-') {
                        state = 1;
                        break;
                    }
                    if (curChar == '.') {
                        state = 2;
                        break;
                    }
                    return null;
                }
                case 1: {
                    if (curChar == '.') {
                        state = 2;
                        break;
                    }
                    return null;
                }
                case 2: {
                    if (Query.isAsciiDigit(curChar, 10) != -1) {
                        state = 3;
                        break;
                    }
                    return null;
                }
                case 3: {
                    if (Query.isAsciiDigit(curChar, 10) != -1) {
                        state = 3;
                        break;
                    }
                    if (curChar == 'e' || curChar == 'E') {
                        state = 4;
                        break;
                    }
                    if (curChar == 'f' || curChar == 'F') {
                        ++this.index;
                        return this.extractFloat(start, this.index - 1, buffer);
                    }
                    if (curChar == 'd' || curChar == 'D') {
                        ++this.index;
                        return this.extractDouble(start, this.index - 1, buffer);
                    }
                    return this.extractDouble(start, this.index, buffer);
                }
                case 4: {
                    if (curChar == '+' || curChar == '-') {
                        state = 5;
                        break;
                    }
                    if (Query.isAsciiDigit(curChar, 10) != -1) {
                        state = 6;
                        break;
                    }
                    return null;
                }
                case 5: {
                    if (Query.isAsciiDigit(curChar, 10) != -1) {
                        state = 6;
                        break;
                    }
                    return null;
                }
                case 6: {
                    if (Query.isAsciiDigit(curChar, 10) != -1) {
                        state = 6;
                        break;
                    }
                    if (curChar == 'f' || curChar == 'F') {
                        ++this.index;
                        return this.extractFloat(start, this.index - 1, buffer);
                    }
                    if (curChar == 'd' || curChar == 'D') {
                        ++this.index;
                        return this.extractDouble(start, this.index - 1, buffer);
                    }
                    return this.extractDouble(start, this.index, buffer);
                }
                default: {
                    return null;
                }
            }
            ++this.index;
        }
        switch (state) {
            case 3: 
            case 6: {
                return this.extractDouble(start, this.index, buffer);
            }
        }
        return null;
    }

    private Object inexact3(String buffer, int start, int length) throws QuerySyntaxException {
        if (start >= length) {
            return null;
        }
        int state = 0;
        this.index = start;
        while (this.index < length) {
            char curChar = buffer.charAt(this.index);
            switch (state) {
                case 0: {
                    if (curChar == '+' || curChar == '-') {
                        state = 1;
                        break;
                    }
                    if (Query.isAsciiDigit(curChar, 10) != -1) {
                        state = 2;
                        break;
                    }
                    return null;
                }
                case 1: {
                    if (Query.isAsciiDigit(curChar, 10) != -1) {
                        state = 2;
                        break;
                    }
                    return null;
                }
                case 2: {
                    if (Query.isAsciiDigit(curChar, 10) != -1) {
                        state = 2;
                        break;
                    }
                    if (curChar == 'e' || curChar == 'E') {
                        state = 3;
                        break;
                    }
                    return null;
                }
                case 3: {
                    if (curChar == '+' || curChar == '-') {
                        state = 4;
                        break;
                    }
                    if (Query.isAsciiDigit(curChar, 10) != -1) {
                        state = 5;
                        break;
                    }
                    return null;
                }
                case 4: {
                    if (Query.isAsciiDigit(curChar, 10) != -1) {
                        state = 5;
                        break;
                    }
                    return null;
                }
                case 5: {
                    if (Query.isAsciiDigit(curChar, 10) != -1) {
                        state = 5;
                        break;
                    }
                    if (curChar == 'f' || curChar == 'F') {
                        ++this.index;
                        return this.extractFloat(start, this.index - 1, buffer);
                    }
                    if (curChar == 'd' || curChar == 'D') {
                        ++this.index;
                        return this.extractDouble(start, this.index - 1, buffer);
                    }
                    return this.extractDouble(start, this.index, buffer);
                }
                default: {
                    return null;
                }
            }
            ++this.index;
        }
        switch (state) {
            case 5: {
                return this.extractDouble(start, this.index, buffer);
            }
        }
        return null;
    }

    private Object inexact4(String buffer, int start, int length) throws QuerySyntaxException {
        if (start >= length) {
            return null;
        }
        int state = 0;
        this.index = start;
        while (this.index < length) {
            char curChar = buffer.charAt(this.index);
            switch (state) {
                case 0: {
                    if (curChar == '+' || curChar == '-') {
                        state = 1;
                        break;
                    }
                    if (Query.isAsciiDigit(curChar, 10) != -1) {
                        state = 2;
                        break;
                    }
                    return null;
                }
                case 1: {
                    if (Query.isAsciiDigit(curChar, 10) != -1) {
                        state = 2;
                        break;
                    }
                    return null;
                }
                case 2: {
                    if (Query.isAsciiDigit(curChar, 10) != -1) {
                        state = 2;
                        break;
                    }
                    if (curChar == 'e' || curChar == 'E') {
                        state = 3;
                        break;
                    }
                    if (curChar == 'f' || curChar == 'F') {
                        ++this.index;
                        return this.extractFloat(start, this.index - 1, buffer);
                    }
                    if (curChar == 'd' || curChar == 'D') {
                        ++this.index;
                        return this.extractDouble(start, this.index - 1, buffer);
                    }
                    return null;
                }
                case 3: {
                    if (curChar == '+' || curChar == '-') {
                        state = 4;
                        break;
                    }
                    if (Query.isAsciiDigit(curChar, 10) != -1) {
                        state = 5;
                        break;
                    }
                    return null;
                }
                case 4: {
                    if (Query.isAsciiDigit(curChar, 10) != -1) {
                        state = 5;
                        break;
                    }
                    return null;
                }
                case 5: {
                    if (Query.isAsciiDigit(curChar, 10) != -1) {
                        state = 5;
                        break;
                    }
                    if (curChar == 'f' || curChar == 'F') {
                        ++this.index;
                        return this.extractFloat(start, this.index - 1, buffer);
                    }
                    if (curChar == 'd' || curChar == 'D') {
                        ++this.index;
                        return this.extractDouble(start, this.index - 1, buffer);
                    }
                    return this.extractDouble(start, this.index, buffer);
                }
                default: {
                    return null;
                }
            }
            ++this.index;
        }
        return null;
    }

    private Object extractFloat(int start, int end, String buffer) throws QuerySyntaxException {
        if (buffer == null || start < 0 || end < start || end > buffer.length()) {
            return null;
        }
        String subStr = buffer.substring(start, end);
        try {
            return new Float(subStr);
        }
        catch (NumberFormatException nfe) {
            throw new QuerySyntaxException(start, "could not parse as float ->" + subStr + "<-");
        }
    }

    private Object extractDouble(int start, int end, String buffer) throws QuerySyntaxException {
        if (buffer == null || start < 0 || end < start || end > buffer.length()) {
            return null;
        }
        String subStr = buffer.substring(start, end);
        try {
            return new Double(subStr);
        }
        catch (NumberFormatException nfe) {
            throw new QuerySyntaxException(start, "could not parse as double ->" + subStr + "<-");
        }
    }
}

