/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms.filter;

import com.evermind.server.jms.filter.Apply;
import com.evermind.server.jms.filter.BooleanExpression;
import com.evermind.server.jms.filter.GeneralException;
import com.evermind.server.jms.filter.IFloatExpression;
import com.evermind.server.jms.filter.QueryTypeException;
import javax.jms.Message;

class FloatGtEqExpr
extends BooleanExpression {
    FloatGtEqExpr(IFloatExpression leftOp, IFloatExpression rightOp) {
        super("(" + leftOp.toString() + " >= " + rightOp.toString() + ")", leftOp, rightOp);
    }

    public void eval(Message m) throws QueryTypeException {
        this.m_null = false;
        this.m_val = false;
        if (this.m_leftExpr.isNull() || this.m_rightExpr.isNull()) {
            this.m_null = true;
        } else {
            this.m_val = ((IFloatExpression)this.m_leftExpr).getFloatVal() >= ((IFloatExpression)this.m_rightExpr).getFloatVal();
        }
    }

    public boolean equals(Object expr) {
        if (expr instanceof FloatGtEqExpr) {
            return this.m_leftExpr.equals(((FloatGtEqExpr)expr).m_leftExpr) && this.m_rightExpr.equals(((FloatGtEqExpr)expr).m_rightExpr);
        }
        return false;
    }

    public Object depthFirstApply(Apply app) throws GeneralException {
        this.m_leftExpr = (IFloatExpression)this.m_leftExpr.depthFirstApply(app);
        this.m_rightExpr = (IFloatExpression)this.m_rightExpr.depthFirstApply(app);
        return app.apply(this);
    }
}

