/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms.filter;

import com.evermind.server.jms.filter.Apply;
import com.evermind.server.jms.filter.DynamicBooleanExpression;
import com.evermind.server.jms.filter.GeneralException;
import com.evermind.server.jms.filter.IDynamicExpression;
import com.evermind.server.jms.filter.QueryTypeException;
import javax.jms.Message;

class DynamicLtEqExpr
extends DynamicBooleanExpression {
    DynamicLtEqExpr(IDynamicExpression leftOp, IDynamicExpression rightOp) {
        super("(" + leftOp.toString() + " <= " + rightOp.toString() + ")", leftOp, rightOp);
    }

    public void eval(Message m) throws QueryTypeException {
        this.m_null = false;
        this.m_val = false;
        if (this.m_leftExpr.isNull() || this.m_rightExpr.isNull()) {
            this.m_null = true;
            return;
        }
        int l_type = this.m_leftExpr.getCurrentType();
        int r_type = this.m_rightExpr.getCurrentType();
        this.m_val = l_type == 6 || r_type == 6 ? this.m_leftExpr.getDoubleVal() <= this.m_rightExpr.getDoubleVal() : (l_type == 5 || r_type == 5 ? this.m_leftExpr.getFloatVal() <= this.m_rightExpr.getFloatVal() : (l_type == 4 || r_type == 4 ? this.m_leftExpr.getLongVal() <= this.m_rightExpr.getLongVal() : this.m_leftExpr.getIntVal() <= this.m_rightExpr.getIntVal()));
    }

    public boolean equals(Object expr) {
        if (expr instanceof DynamicLtEqExpr) {
            return this.m_leftExpr.equals(((DynamicLtEqExpr)expr).m_leftExpr) && this.m_rightExpr.equals(((DynamicLtEqExpr)expr).m_rightExpr);
        }
        return false;
    }

    public Object depthFirstApply(Apply app) throws GeneralException {
        this.m_leftExpr = (IDynamicExpression)this.m_leftExpr.depthFirstApply(app);
        this.m_rightExpr = (IDynamicExpression)this.m_rightExpr.depthFirstApply(app);
        return app.apply(this);
    }
}

