/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms.filter;

import com.evermind.server.jms.filter.Apply;
import com.evermind.server.jms.filter.DynamicExpression;
import com.evermind.server.jms.filter.GeneralException;
import com.evermind.server.jms.filter.IDynamicExpression;
import com.evermind.server.jms.filter.QueryTypeException;
import javax.jms.Message;

class DynamicAdd
extends DynamicExpression {
    DynamicAdd(IDynamicExpression leftExpr, IDynamicExpression rightExpr) {
        super("(" + leftExpr.toString() + " + " + rightExpr.toString() + ")", leftExpr, rightExpr);
    }

    public void eval(Message m) throws QueryTypeException {
        if (this.m_leftExpr.isNull() || this.m_rightExpr.isNull()) {
            this.m_null = true;
            return;
        }
        this.m_null = false;
        this.cur_type = -1;
        int l_type = this.m_leftExpr.getCurrentType();
        int r_type = this.m_rightExpr.getCurrentType();
        if (l_type == 6 || r_type == 6) {
            this.setDoubleVal(this.m_leftExpr.getDoubleVal() + this.m_rightExpr.getDoubleVal());
        } else if (l_type == 5 || r_type == 5) {
            this.setFloatVal(this.m_leftExpr.getFloatVal() + this.m_rightExpr.getFloatVal());
        } else if (l_type == 4 || r_type == 4) {
            this.setLongVal(this.m_leftExpr.getLongVal() + this.m_rightExpr.getLongVal());
        } else {
            this.setIntVal(this.m_leftExpr.getIntVal() + this.m_rightExpr.getIntVal());
        }
    }

    public boolean equals(Object expr) {
        if (expr instanceof DynamicAdd) {
            return this.m_leftExpr.equals(((DynamicAdd)expr).m_leftExpr) && this.m_rightExpr.equals(((DynamicAdd)expr).m_rightExpr);
        }
        return false;
    }

    public Object depthFirstApply(Apply app) throws GeneralException {
        this.m_leftExpr = (IDynamicExpression)this.m_leftExpr.depthFirstApply(app);
        this.m_rightExpr = (IDynamicExpression)this.m_rightExpr.depthFirstApply(app);
        return app.apply(this);
    }
}

